/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.utils;

import java.util.Vector;
import org.apache.xalan.utils.HeapObject;

public class Heap
extends Vector {
    private HeapObject[] m_a = new HeapObject[50];
    private int m_n;
    final Sentinel m_sentinel = new Sentinel();

    public void insert(HeapObject heapObject) {
        ++this.m_n;
        this.m_a[this.m_n] = heapObject;
        this.upheap(this.m_n);
    }

    private void upheap(int n) {
        HeapObject heapObject = this.m_a[n];
        this.m_a[0] = this.m_sentinel;
        while (this.m_a[n / 2].getHeapValue() < heapObject.getHeapValue()) {
            this.m_a[n] = this.m_a[n / 2];
            n /= 2;
        }
        this.m_a[n] = heapObject;
    }

    public HeapObject remove() {
        HeapObject heapObject = this.m_a[1];
        this.m_a[1] = this.m_a[this.m_n--];
        this.downheap(1);
        return heapObject;
    }

    private void downheap(int n) {
        HeapObject heapObject = this.m_a[n];
        while (n <= this.m_n / 2) {
            int n2 = n + n;
            if (n2 < this.m_n && this.m_a[n2].getHeapValue() < this.m_a[n2 + 1].getHeapValue()) {
                ++n2;
            }
            if (heapObject.getHeapValue() >= this.m_a[n2].getHeapValue()) break;
            this.m_a[n] = this.m_a[n2];
            n = n2;
        }
        this.m_a[n] = heapObject;
    }

    HeapObject replace(HeapObject heapObject) {
        this.m_a[0] = heapObject;
        this.downheap(0);
        return this.m_a[0];
    }

    void change() {
    }

    void delete() {
    }

    class Sentinel
    implements HeapObject {
        public int getHeapValue() {
            return Short.MAX_VALUE;
        }

        Sentinel() {
            Heap.this = Heap.this;
        }
    }
}

