/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.utils;

public class StringToStringTable {
    private int m_blocksize;
    private String[] m_map;
    private int m_firstFree;
    private int m_mapSize;

    public StringToStringTable() {
        this.m_mapSize = this.m_blocksize = 16;
        this.m_map = new String[this.m_blocksize];
    }

    public StringToStringTable(int n) {
        this.m_blocksize = n;
        this.m_mapSize = n;
        this.m_map = new String[n];
    }

    public final int getLength() {
        return this.m_firstFree;
    }

    public final void put(String string, String string2) {
        if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            String[] stringArray = new String[this.m_mapSize];
            System.arraycopy(this.m_map, 0, stringArray, 0, this.m_firstFree + 1);
            this.m_map = stringArray;
        }
        this.m_map[this.m_firstFree] = string;
        ++this.m_firstFree;
        this.m_map[this.m_firstFree] = string2;
        ++this.m_firstFree;
    }

    public final String get(String string) {
        int n = 0;
        while (n < this.m_firstFree) {
            if (this.m_map[n].equals(string)) {
                return this.m_map[n + 1];
            }
            n += 2;
        }
        return null;
    }

    public final void remove(String string) {
        int n = 0;
        while (n < this.m_firstFree) {
            if (this.m_map[n].equals(string)) {
                if (n + 2 < this.m_firstFree) {
                    System.arraycopy(this.m_map, n + 2, this.m_map, n, this.m_firstFree - (n + 2));
                }
                this.m_firstFree -= 2;
                this.m_map[this.m_firstFree] = null;
                this.m_map[this.m_firstFree + 1] = null;
                return;
            }
            n += 2;
        }
    }

    public final String getIgnoreCase(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            if (this.m_map[n].equalsIgnoreCase(string)) {
                return this.m_map[n + 1];
            }
            n += 2;
        }
        return null;
    }

    public final String getByValue(String string) {
        int n = 1;
        while (n < this.m_firstFree) {
            if (this.m_map[n].equals(string)) {
                return this.m_map[n - 1];
            }
            n += 2;
        }
        return null;
    }

    public final String elementAt(int n) {
        return this.m_map[n];
    }

    public final boolean contains(String string) {
        int n = 0;
        while (n < this.m_firstFree) {
            if (this.m_map[n].equals(string)) {
                return true;
            }
            n += 2;
        }
        return false;
    }

    public final boolean containsValue(String string) {
        int n = 1;
        while (n < this.m_firstFree) {
            if (this.m_map[n].equals(string)) {
                return true;
            }
            n += 2;
        }
        return false;
    }
}

