/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize.transition;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

class Encodings {
    public static boolean m_shouldNormalizeLinebreaks;
    static final int DefaultLastPrintable = 127;
    private static final EncodingInfo[] _encodings;

    static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        int n = 0;
        while (n < _encodings.length) {
            if (Encodings._encodings[n].name.equals(string)) {
                try {
                    return new OutputStreamWriter(outputStream, Encodings._encodings[n].javaName);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            ++n;
        }
        return new OutputStreamWriter(outputStream, string);
    }

    static int getLastPrintable(String string) {
        int n = 0;
        while (n < _encodings.length) {
            if (Encodings._encodings[n].name.equalsIgnoreCase(string)) {
                return Encodings._encodings[n].lastPrintable;
            }
            ++n;
        }
        return 127;
    }

    static int getLastPrintable() {
        return 127;
    }

    Encodings() {
    }

    static {
        _encodings = new EncodingInfo[]{new EncodingInfo("WINDOWS-1250", "Cp1250", 255), new EncodingInfo("UTF-8", "UTF8", 65535), new EncodingInfo("US-ASCII", "ISO8859_1", 127), new EncodingInfo("ISO-8859-1", "ISO8859_1", 255), new EncodingInfo("ISO-8859-2", "ISO8859_2", 255), new EncodingInfo("ISO-8859-3", "ISO8859_3", 255), new EncodingInfo("ISO-8859-4", "ISO8859_4", 255), new EncodingInfo("ISO-8859-5", "ISO8859_5", 255), new EncodingInfo("ISO-8859-6", "ISO8859_6", 255), new EncodingInfo("ISO-8859-7", "ISO8859_7", 255), new EncodingInfo("ISO-8859-8", "ISO8859_8", 255), new EncodingInfo("ISO-8859-9", "ISO8859_9", 255), new EncodingInfo("US-ASCII", "8859_1", 255), new EncodingInfo("ISO-8859-1", "8859_1", 255), new EncodingInfo("ISO-8859-2", "8859_2", 255), new EncodingInfo("ISO-8859-3", "8859_3", 255), new EncodingInfo("ISO-8859-4", "8859_4", 255), new EncodingInfo("ISO-8859-5", "8859_5", 255), new EncodingInfo("ISO-8859-6", "8859_6", 255), new EncodingInfo("ISO-8859-7", "8859_7", 255), new EncodingInfo("ISO-8859-8", "8859_8", 255), new EncodingInfo("ISO-8859-9", "8859_9", 255), new EncodingInfo("ISO-2022-JP", "JIS", 65535), new EncodingInfo("SHIFT_JIS", "SJIS", 65535), new EncodingInfo("EUC-JP", "EUCJIS", 65535), new EncodingInfo("GB2312", "GB2312", 65535), new EncodingInfo("BIG5", "Big5", 65535), new EncodingInfo("EUC-KR", "KSC5601", 65535), new EncodingInfo("ISO-2022-KR", "ISO2022KR", 65535), new EncodingInfo("KOI8-R", "KOI8_R", 65535), new EncodingInfo("EBCDIC-CP-US", "Cp037", 255), new EncodingInfo("EBCDIC-CP-CA", "Cp037", 255), new EncodingInfo("EBCDIC-CP-NL", "Cp037", 255), new EncodingInfo("EBCDIC-CP-DK", "Cp277", 255), new EncodingInfo("EBCDIC-CP-NO", "Cp277", 255), new EncodingInfo("EBCDIC-CP-FI", "Cp278", 255), new EncodingInfo("EBCDIC-CP-SE", "Cp278", 255), new EncodingInfo("EBCDIC-CP-IT", "Cp280", 255), new EncodingInfo("EBCDIC-CP-ES", "Cp284", 255), new EncodingInfo("EBCDIC-CP-GB", "Cp285", 255), new EncodingInfo("EBCDIC-CP-FR", "Cp297", 255), new EncodingInfo("EBCDIC-CP-AR1", "Cp420", 255), new EncodingInfo("EBCDIC-CP-HE", "Cp424", 255), new EncodingInfo("EBCDIC-CP-CH", "Cp500", 255), new EncodingInfo("EBCDIC-CP-ROECE", "Cp870", 255), new EncodingInfo("EBCDIC-CP-YU", "Cp870", 255), new EncodingInfo("EBCDIC-CP-IS", "Cp871", 255), new EncodingInfo("EBCDIC-CP-AR2", "Cp918", 255), new EncodingInfo("ASCII", "ASCII", 127), new EncodingInfo("ISO-Latin-1", "ASCII", 255), new EncodingInfo("UTF-8", "UTF8", 65535), new EncodingInfo("UNICODE", "Unicode", 65535), new EncodingInfo("UTF-16", "Unicode", 65535)};
    }

    static final class EncodingInfo {
        final String name;
        final String javaName;
        final int lastPrintable;

        EncodingInfo(String string, String string2, int n) {
            this.name = string;
            this.javaName = string2;
            this.lastPrintable = n;
        }
    }
}

