/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize.transition;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.serialize.OutputFormat;
import org.apache.xml.serialize.transition.FastStringBuffer;
import org.apache.xml.serialize.transition.Printer;

class IndentPrinter
extends Printer {
    private int _spaces = 0;
    private int _thisIndent = 0;
    private int _nextIndent = 0;
    private int _lineWidth = 7200;
    private static char[] _spacechars = new char[200];
    private FastStringBuffer _line = new FastStringBuffer(2048);
    private FastStringBuffer _text = new FastStringBuffer(2048);
    public static int TRY_TO_FLUSH_AT;

    private final void resetTextBuf() {
        this._text.reset();
    }

    private final void resetLineBuf() {
        this._line.reset();
    }

    private final void flushLineBuf() throws IOException {
        this._writer.write(this._line.m_map, 0, this._line.m_firstFree);
        this.resetLineBuf();
    }

    IndentPrinter(Writer writer, OutputFormat outputFormat) {
        super(writer, outputFormat);
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public void enterDTD() {
        if (this._dtdWriter == null) {
            this._line.append(this._text);
            this.resetTextBuf();
            this.flushLine(false);
            this._dtdWriter = new StringWriter();
            this._docWriter = this._writer;
            this._writer = this._dtdWriter;
        }
    }

    public String leaveDTD() {
        if (this._writer == this._dtdWriter) {
            this._line.append(this._text);
            this.resetTextBuf();
            this.flushLine(false);
            this._writer = this._docWriter;
            return this._dtdWriter.toString();
        }
        return null;
    }

    public void printText(String string) {
        this._text.append(string);
    }

    public void printText(StringBuffer stringBuffer) {
        this._text.append(stringBuffer);
    }

    public void printText(char c) {
        this._text.append(c);
    }

    public void printText(char[] cArray, int n, int n2) {
        this._text.append(cArray, n, n2);
    }

    public void printSpace() {
        int n = this._text.length();
        if (n > 0) {
            if (this._spaces > 0) {
                this._line.append(_spacechars, 0, this._spaces);
                this._spaces = 0;
            }
            this._line.append(this._text);
            this.resetTextBuf();
            if (this._line.length() > TRY_TO_FLUSH_AT) {
                this.flushLine(false);
            }
        }
        ++this._spaces;
    }

    public void breakLine() {
        this.breakLine(false);
    }

    public void breakLine(boolean bl) {
        bl = true;
        if (this._text.length() > 0) {
            if (this._spaces > 0) {
                this._line.append(_spacechars, 0, this._spaces);
                this._spaces = 0;
            }
            this._line.append(this._text);
            this.resetTextBuf();
        }
        this.flushLine(bl);
        try {
            this._writer.write(this.getLineSeparator());
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    public void flushLine(boolean bl) {
        block5: {
            bl = true;
            if (this._line.length() > 0) {
                try {
                    if (this._format.getIndent() && !bl) {
                        int n = this._thisIndent;
                        int n2 = this.getLineWidth();
                        if (2 * n > n2 && n2 > 0) {
                            n = n2 / 2;
                        }
                        this._writer.write(_spacechars, 0, n);
                    }
                    this._thisIndent = this._nextIndent;
                    this._spaces = 0;
                    this.flushLineBuf();
                    return;
                }
                catch (IOException iOException) {
                    if (this._exception != null) break block5;
                    this._exception = iOException;
                    return;
                }
            }
        }
    }

    public void flush() {
        if (this._line.length() > 0 || this._text.length() > 0) {
            this.breakLine();
        }
        try {
            this._writer.flush();
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    public void indent() {
        this._nextIndent += this._format.getIndentAmount();
    }

    public void unindent() {
        this._nextIndent -= this._format.getIndentAmount();
        if (this._nextIndent < 0) {
            this._nextIndent = 0;
        }
        if (this._line.length() + this._spaces + this._text.length() == 0) {
            this._thisIndent = this._nextIndent;
        }
    }

    public int getNextIndent() {
        return this._nextIndent;
    }

    public void setNextIndent(int n) {
        this._nextIndent = n;
    }

    public void setThisIndent(int n) {
        this._thisIndent = n;
    }

    static {
        int n = 0;
        while (n < 200) {
            IndentPrinter._spacechars[n] = 32;
            ++n;
        }
        TRY_TO_FLUSH_AT = 1024;
    }
}

