/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize.transition;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.serialize.OutputFormat;

public class Printer {
    protected OutputFormat _format;
    protected Writer _writer;
    protected StringWriter _dtdWriter;
    protected Writer _docWriter;
    protected IOException _exception;
    private static final int BufferSize = 4096;
    private final char[] _buffer = new char[4096];
    private int _pos;
    protected final String _lineSeparator = System.getProperty("line.separator");
    protected final int _lineSepLen = this._lineSeparator.length();

    public Printer(Writer writer, OutputFormat outputFormat) {
        this._writer = writer;
        this._format = outputFormat;
        this._exception = null;
        this._dtdWriter = null;
        this._docWriter = null;
        this._pos = 0;
    }

    public IOException getException() {
        return this._exception;
    }

    public void enterDTD() {
        if (this._dtdWriter == null) {
            this.flushLine(false);
            this._dtdWriter = new StringWriter();
            this._docWriter = this._writer;
            this._writer = this._dtdWriter;
        }
    }

    public String leaveDTD() {
        if (this._writer == this._dtdWriter) {
            this.flushLine(false);
            this._writer = this._docWriter;
            return this._dtdWriter.toString();
        }
        return null;
    }

    public void printText(String string) {
        try {
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                if (this._pos == 4096) {
                    this._writer.write(this._buffer);
                    this._pos = 0;
                }
                this._buffer[this._pos] = string.charAt(n2);
                ++this._pos;
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    public void printText(StringBuffer stringBuffer) {
        try {
            int n = stringBuffer.length();
            int n2 = 0;
            while (n2 < n) {
                if (this._pos == 4096) {
                    this._writer.write(this._buffer);
                    this._pos = 0;
                }
                this._buffer[this._pos] = stringBuffer.charAt(n2);
                ++this._pos;
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    public void printText(char[] cArray, int n, int n2) {
        try {
            while (n2-- > 0) {
                if (this._pos == 4096) {
                    this._writer.write(this._buffer);
                    this._pos = 0;
                }
                this._buffer[this._pos] = cArray[n];
                ++this._pos;
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    public void printText(char c) {
        try {
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            this._buffer[this._pos] = c;
            ++this._pos;
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    public void printSpace() {
        try {
            if (this._pos == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            this._buffer[this._pos] = 32;
            ++this._pos;
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    public void breakLine() {
        try {
            if (this._pos + (this._lineSepLen - 1) == 4096) {
                this._writer.write(this._buffer);
                this._pos = 0;
            }
            int n = 0;
            while (n < this._lineSepLen) {
                this._buffer[this._pos] = this._lineSeparator.charAt(n);
                ++this._pos;
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            if (this._exception == null) {
                this._exception = iOException;
            }
            return;
        }
    }

    public void breakLine(boolean bl) {
        this.breakLine();
    }

    public void flushLine(boolean bl) {
    }

    public void flush() {
        block2: {
            try {
                this._writer.write(this._buffer, 0, this._pos);
                this._writer.flush();
            }
            catch (IOException iOException) {
                if (this._exception != null) break block2;
                this._exception = iOException;
            }
        }
        this._pos = 0;
    }

    public void indent() {
    }

    public void unindent() {
    }

    public int getNextIndent() {
        return 0;
    }

    public void setNextIndent(int n) {
    }

    public void setThisIndent(int n) {
    }
}

