/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize.transition;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.serialize.OutputFormat;
import org.apache.serialize.Serializer;
import org.apache.serialize.SerializerFactory;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String string) {
        this._method = string;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            throw new IllegalArgumentException("SER004 The method '" + string + "' is not supported by this factory\n" + string);
        }
    }

    public Serializer makeSerializer(OutputFormat outputFormat) {
        Serializer serializer = SerializerFactory.getSerializer(outputFormat);
        serializer.setOutputFormat(outputFormat);
        return serializer;
    }

    public Serializer makeSerializer(Writer writer, OutputFormat outputFormat) {
        Serializer serializer = SerializerFactory.getSerializer(outputFormat);
        serializer.setWriter(writer);
        return serializer;
    }

    public Serializer makeSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        Serializer serializer = SerializerFactory.getSerializer(outputFormat);
        serializer.setOutputStream(outputStream);
        return serializer;
    }

    protected String getSupportedMethod() {
        return this._method;
    }
}

