/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize.transition;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.serialize.OutputFormat;
import org.apache.serialize.QName;
import org.apache.xml.serialize.transition.BaseMarkupSerializer;
import org.apache.xml.serialize.transition.ElementState;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;

public final class XMLSerializer
extends BaseMarkupSerializer {
    public XMLSerializer() {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setMethod("xml");
        this.setOutputFormat(outputFormat);
    }

    public XMLSerializer(OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat();
            outputFormat.setMethod("xml");
        }
        this.setOutputFormat(outputFormat);
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat();
            outputFormat.setMethod("xml");
        }
        this.setOutputFormat(outputFormat);
        this.setWriter(writer);
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat();
            outputFormat.setMethod("xml");
        }
        this.setOutputFormat(outputFormat);
        this.setOutputStream(outputStream);
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            outputFormat = new OutputFormat();
            outputFormat.setMethod("xml");
        }
        super.setOutputFormat(outputFormat);
    }

    public boolean isCDataElement(String string, String string2) {
        QName[] qNameArray = this._format.getCDataElements();
        if (qNameArray == null) {
            return false;
        }
        int n = 0;
        while (n < qNameArray.length) {
            if (qNameArray[n].equals(string, string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isNonEscapingElement(String string, String string2) {
        QName[] qNameArray = this._format.getNonEscapingElements();
        if (qNameArray == null) {
            return false;
        }
        int n = 0;
        while (n < qNameArray.length) {
            if (qNameArray[n].equals(string, string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        String string4;
        String string5;
        Object object;
        boolean bl = false;
        if (this._printer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string2 == null ? string3 : string2);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (elementState.inCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean bl2 = elementState.preserveSpace;
        if (string3 == null) {
            string3 = string2;
            if (string != null && ((String)(object = this.getPrefix(string))).length() > 0) {
                string3 = String.valueOf(object) + ":" + string2;
            }
            bl = true;
        }
        this._printer.printText('<');
        this._printer.printText(string3);
        this._printer.indent();
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                this._printer.printSpace();
                string5 = attributes.getQName(n);
                if (string5 == null) {
                    string5 = attributes.getLocalName(n);
                    String string6 = attributes.getURI(n);
                    if (!(string6 == null || string != null && string6.equals(string) || (object = this.getPrefix(string6)) == null || ((String)object).length() <= 0)) {
                        string5 = String.valueOf(object) + ":" + string5;
                    }
                }
                if ((string4 = attributes.getValue(n)) == null) {
                    string4 = "";
                }
                this._printer.printText(string5);
                this._printer.printText("=\"");
                this.printEscaped(string4);
                this._printer.printText('\"');
                if (string5.equals("xml:space")) {
                    bl2 = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        }
        if (bl) {
            object = this._prefixes.keys();
            while (object.hasMoreElements()) {
                this._printer.printSpace();
                string4 = (String)object.nextElement();
                string5 = (String)this._prefixes.get(string4);
                if (string5.length() == 0) {
                    this._printer.printText("xmlns=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                    continue;
                }
                this._printer.printText("xmlns:");
                this._printer.printText(string5);
                this._printer.printText("=\"");
                this.printEscaped(string4);
                this._printer.printText('\"');
            }
        }
        elementState = this.enterElementState(string, string2, string3, bl2);
        elementState.doCData = this.isCDataElement(string, string2);
        elementState.unescaped = this.isNonEscapingElement(string, string2);
    }

    public void endElement(String string, String string2, String string3) {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this._printer.printText("/>");
        } else {
            if (elementState.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !elementState.preserveSpace && elementState.afterElement) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(elementState.rawName);
            this._printer.printText('>');
        }
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String string, AttributeList attributeList) {
        if (this._printer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (elementState.inCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean bl = elementState.preserveSpace;
        this._printer.printText('<');
        this._printer.printText(string);
        this._printer.indent();
        if (attributeList != null) {
            int n = 0;
            while (n < attributeList.getLength()) {
                this._printer.printSpace();
                String string2 = attributeList.getName(n);
                String string3 = attributeList.getValue(n);
                if (string3 != null) {
                    this._printer.printText(string2);
                    this._printer.printText("=\"");
                    this.printEscaped(string3);
                    this._printer.printText('\"');
                }
                if (string2.equals("xml:space")) {
                    bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        }
        elementState = this.enterElementState(null, null, string, bl);
        elementState.doCData = this.isCDataElement(null, string);
        elementState.unescaped = this.isNonEscapingElement(null, string);
    }

    public void endElement(String string) {
        this.endElement(null, null, string);
    }

    protected void startDocument(String string) {
        String string2 = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                String string3 = this._format.getEncoding();
                if (string3 != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(string3);
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this._printer.printText(stringBuffer);
                this._printer.breakLine();
            }
            if (this._docTypeSystemId != null) {
                this._printer.printText("<!DOCTYPE ");
                this._printer.printText(string);
                if (this._docTypePublicId != null) {
                    this._printer.printText(" PUBLIC ");
                    this.printDoctypeURL(this._docTypePublicId);
                    if (this._indenting) {
                        this._printer.breakLine();
                        int n = 0;
                        while (n < 18 + string.length()) {
                            this._printer.printText(" ");
                            ++n;
                        }
                    } else {
                        this._printer.printText(" ");
                    }
                    this.printDoctypeURL(this._docTypeSystemId);
                } else {
                    this._printer.printText(" SYSTEM ");
                    this.printDoctypeURL(this._docTypeSystemId);
                }
                if (string2 != null && string2.length() > 0) {
                    this._printer.printText(" [");
                    this.printText(string2, true, true);
                    this._printer.printText(']');
                }
                this._printer.printText(">");
                this._printer.breakLine();
            } else if (string2 != null && string2.length() > 0) {
                this._printer.printText("<!DOCTYPE ");
                this._printer.printText(string);
                this._printer.printText(" [");
                this.printText(string2, true, true);
                this._printer.printText("]>");
                this._printer.breakLine();
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element element) {
        String string = element.getTagName();
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (elementState.inCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean bl = elementState.preserveSpace;
        this._printer.printText('<');
        this._printer.printText(string);
        this._printer.indent();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string2 = attr.getName();
                String string3 = attr.getValue();
                if (string3 == null) {
                    string3 = "";
                }
                if (attr.getSpecified()) {
                    this._printer.printSpace();
                    this._printer.printText(string2);
                    this._printer.printText("=\"");
                    this.printEscaped(string3);
                    this._printer.printText('\"');
                }
                if (string2.equals("xml:space")) {
                    bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        }
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(null, null, string, bl);
            elementState.doCData = this.isCDataElement(null, string);
            elementState.unescaped = this.isNonEscapingElement(null, string);
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            this.endElement(string);
            return;
        }
        this._printer.unindent();
        this._printer.printText("/>");
        elementState.afterElement = true;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    protected String getEntityRef(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

