/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xalan.utils.DefaultErrorHandler;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.DOMOrder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOM2Helper
extends DOMHelper {
    private Document m_doc;
    private boolean m_useDOM2getNamespaceURI = false;

    public void checkNode(Node node) throws SAXException {
    }

    public boolean supportsSAX() {
        return true;
    }

    public void setDocument(Document document) {
        this.m_doc = document;
    }

    public Document getDocument() {
        return this.m_doc;
    }

    public void parse(InputSource inputSource) throws SAXException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String string = inputSource.getSystemId() == null ? "Input XSL" : inputSource.getSystemId();
            documentBuilder.setErrorHandler(new DefaultErrorHandler(string));
            this.setDocument(documentBuilder.parse(inputSource));
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public Element getElementByID(String string, Document document) {
        return document.getElementById(string);
    }

    public boolean isNodeAfter(Node node, Node node2) {
        try {
            int n = ((DOMOrder)((Object)node)).getUid();
            int n2 = ((DOMOrder)((Object)node2)).getUid();
            return n <= n2;
        }
        catch (ClassCastException classCastException) {
            return super.isNodeAfter(node, node2);
        }
    }

    public Node getParentOfNode(Node node) throws RuntimeException {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    public String getLocalNameOfNode(Node node) {
        String string = node.getLocalName();
        if (string == null) {
            return super.getLocalNameOfNode(node);
        }
        return string;
    }

    public String getNamespaceOfNode(Node node) {
        return node.getNamespaceURI();
    }
}

