/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.utils.FastStringBuffer;
import org.apache.xalan.utils.NSInfo;
import org.apache.xalan.utils.StringBufferPool;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DOMHelper {
    Hashtable m_NSInfos = new Hashtable();
    protected static final NSInfo m_NSInfoUnProcWithXMLNS = new NSInfo(false, true);
    protected static final NSInfo m_NSInfoUnProcWithoutXMLNS = new NSInfo(false, false);
    protected static final NSInfo m_NSInfoUnProcNoAncestorXMLNS = new NSInfo(false, false, 2);
    protected static final NSInfo m_NSInfoNullWithXMLNS = new NSInfo(true, true);
    protected static final NSInfo m_NSInfoNullWithoutXMLNS = new NSInfo(true, false);
    protected static final NSInfo m_NSInfoNullNoAncestorXMLNS = new NSInfo(true, false, 2);
    protected Vector m_candidateNoAncestorXMLNS = new Vector();
    protected Document m_DOMFactory;

    public Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(54, null));
        }
    }

    public boolean shouldStripSourceNode(Node node) throws SAXException {
        return false;
    }

    public String getUniqueID(Node node) {
        return "N" + Integer.toHexString(node.hashCode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNodeAfter(Node node, Node node2) {
        int n;
        int n2;
        Node node3;
        if (node == node2) {
            return true;
        }
        boolean bl = false;
        Node node4 = this.getParentOfNode(node);
        if (node4 == (node3 = this.getParentOfNode(node2))) {
            if (node4 != null) {
                return DOMHelper.isNodeAfterSibling(node4, node, node2);
            }
            if (node != node2) return true;
            return false;
        }
        int n3 = 2;
        int n4 = 2;
        while (node4 != null) {
            ++n3;
            node4 = this.getParentOfNode(node4);
        }
        while (node3 != null) {
            ++n4;
            node3 = this.getParentOfNode(node3);
        }
        Node node5 = node;
        Node node6 = node2;
        if (n3 < n4) {
            n2 = n4 - n3;
            n = 0;
            while (n < n2) {
                node6 = this.getParentOfNode(node6);
                ++n;
            }
        } else if (n3 > n4) {
            n2 = n3 - n4;
            n = 0;
            while (n < n2) {
                node5 = this.getParentOfNode(node5);
                ++n;
            }
        }
        Node node7 = null;
        Node node8 = null;
        while (node5 != null) {
            if (node5 == node6) {
                if (node7 != null) return DOMHelper.isNodeAfterSibling(node5, node7, node8);
                if (n3 >= n4) return false;
                return true;
            }
            node7 = node5;
            node5 = this.getParentOfNode(node5);
            node8 = node6;
            node6 = this.getParentOfNode(node6);
        }
        return bl;
    }

    private static boolean isNodeAfterSibling(Node node, Node node2, Node node3) {
        boolean bl = false;
        short s = node2.getNodeType();
        short s2 = node3.getNodeType();
        if (s != 2 && s2 == 2) {
            bl = false;
        } else if (s == 2 && s2 != 2) {
            bl = true;
        } else if (s == 2) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = 0;
            while (n2 < n) {
                Node node4 = namedNodeMap.item(n2);
                if (node2 == node4) {
                    if (bl3) {
                        bl = false;
                        break;
                    }
                    bl2 = true;
                } else if (node3 == node4) {
                    if (bl2) {
                        bl = true;
                        break;
                    }
                    bl3 = true;
                }
                ++n2;
            }
        } else {
            Node node5 = node.getFirstChild();
            boolean bl4 = false;
            boolean bl5 = false;
            while (node5 != null) {
                if (node2 == node5) {
                    if (bl5) {
                        bl = false;
                        break;
                    }
                    bl4 = true;
                } else if (node3 == node5) {
                    if (bl4) {
                        bl = true;
                        break;
                    }
                    bl5 = true;
                }
                node5 = node5.getNextSibling();
            }
        }
        return bl;
    }

    public short getLevel(Node node) {
        short s = 1;
        while ((node = this.getParentOfNode(node)) != null) {
            s = (short)(s + 1);
        }
        return s;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public String getNamespaceForPrefix(String var1_1, Element var2_2) {
        block5: {
            var4_3 /* !! */  = var2_2;
            var5_4 = null;
            if (!var1_1.equals("xml")) ** GOTO lbl22
            var5_4 = "http://www.w3.org/XML/1998/namespace";
            break block5;
lbl-1000:
            // 1 sources

            {
                if (var3_5 == 1) {
                    var6_6 = var4_3 /* !! */ .getAttributes();
                    var7_7 = 0;
                    while (var7_7 < var6_6.getLength()) {
                        var8_8 = var6_6.item(var7_7);
                        var9_9 = var8_8.getNodeName();
                        var10_10 = var9_9.startsWith("xmlns:");
                        if (var10_10 || var9_9.equals("xmlns")) {
                            var11_11 = var9_9.indexOf(58);
                            v0 = var12_12 = var10_10 != false ? var9_9.substring(var11_11 + 1) : "";
                            if (var12_12.equals(var1_1)) {
                                var5_4 = var8_8.getNodeValue();
                                break;
                            }
                        }
                        ++var7_7;
                    }
                }
                var4_3 /* !! */  = this.getParentOfNode(var4_3 /* !! */ );
lbl22:
                // 2 sources

                ** while (var4_3 /* !! */  != null && var5_4 == null && ((var3_5 = var4_3 /* !! */ .getNodeType()) == 1 || var3_5 == 5))
            }
        }
        return var5_4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNamespaceOfNode(Node node) {
        String string;
        boolean bl;
        NSInfo nSInfo;
        short s = node.getNodeType();
        if (s != 2) {
            Object v = this.m_NSInfos.get(node);
            nSInfo = v == null ? null : (NSInfo)v;
            bl = nSInfo == null ? false : nSInfo.m_hasProcessedNS;
        } else {
            bl = false;
            nSInfo = null;
        }
        if (bl) {
            return nSInfo.m_namespace;
        }
        String string2 = null;
        String string3 = node.getNodeName();
        int n = string3.indexOf(58);
        if (s == 2) {
            if (n <= 0) return string2;
            string = string3.substring(0, n);
        } else {
            string = n >= 0 ? string3.substring(0, n) : "";
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.equals("xml")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
        } else {
            int n2;
            Node node2 = node;
            while (node2 != null && string2 == null) {
                if (nSInfo != null && nSInfo.m_ancestorHasXMLNSAttrs == 2) break;
                short s2 = node2.getNodeType();
                if (nSInfo == null || nSInfo.m_hasXMLNSAttrs) {
                    boolean bl4 = false;
                    if (s2 == 1) {
                        NamedNodeMap namedNodeMap = node2.getAttributes();
                        int n3 = 0;
                        while (n3 < namedNodeMap.getLength()) {
                            Node node3 = namedNodeMap.item(n3);
                            String string4 = node3.getNodeName();
                            if (string4.charAt(0) == 'x') {
                                boolean bl5 = string4.startsWith("xmlns:");
                                if (string4.equals("xmlns") || bl5) {
                                    String string5;
                                    if (node == node2) {
                                        bl3 = true;
                                    }
                                    bl4 = true;
                                    bl2 = true;
                                    String string6 = string5 = bl5 ? string4.substring(6) : "";
                                    if (string5.equals(string)) {
                                        string2 = node3.getNodeValue();
                                        break;
                                    }
                                }
                            }
                            ++n3;
                        }
                    }
                    if (s2 != 2 && nSInfo == null && node != node2) {
                        nSInfo = bl4 ? m_NSInfoUnProcWithXMLNS : m_NSInfoUnProcWithoutXMLNS;
                        this.m_NSInfos.put(node2, nSInfo);
                    }
                }
                if (s2 == 2) {
                    node2 = this.getParentOfNode(node2);
                } else {
                    this.m_candidateNoAncestorXMLNS.addElement(node2);
                    this.m_candidateNoAncestorXMLNS.addElement(nSInfo);
                    node2 = node2.getParentNode();
                }
                if (node2 == null) continue;
                Object v = this.m_NSInfos.get(node2);
                NSInfo nSInfo2 = nSInfo = v == null ? null : (NSInfo)v;
            }
            if ((n2 = this.m_candidateNoAncestorXMLNS.size()) > 0) {
                if (!bl2 && node2 == null) {
                    int n4 = 0;
                    while (n4 < n2) {
                        Object e = this.m_candidateNoAncestorXMLNS.elementAt(n4 + 1);
                        if (e == m_NSInfoUnProcWithoutXMLNS) {
                            this.m_NSInfos.put(this.m_candidateNoAncestorXMLNS.elementAt(n4), m_NSInfoUnProcNoAncestorXMLNS);
                        } else if (e == m_NSInfoNullWithoutXMLNS) {
                            this.m_NSInfos.put(this.m_candidateNoAncestorXMLNS.elementAt(n4), m_NSInfoNullNoAncestorXMLNS);
                        }
                        n4 += 2;
                    }
                }
                this.m_candidateNoAncestorXMLNS.removeAllElements();
            }
        }
        if (s == 2) return string2;
        if (string2 == null) {
            if (bl2) {
                if (bl3) {
                    this.m_NSInfos.put(node, m_NSInfoNullWithXMLNS);
                    return string2;
                } else {
                    this.m_NSInfos.put(node, m_NSInfoNullWithoutXMLNS);
                }
                return string2;
            } else {
                this.m_NSInfos.put(node, m_NSInfoNullNoAncestorXMLNS);
            }
            return string2;
        } else {
            this.m_NSInfos.put(node, new NSInfo(string2, bl3));
        }
        return string2;
    }

    public String getLocalNameOfNode(Node node) {
        String string = node.getNodeName();
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public String getExpandedElementName(Element element) {
        String string = this.getNamespaceOfNode(element);
        if (string != null) {
            return String.valueOf(string) + ":" + this.getLocalNameOfNode(element);
        }
        return this.getLocalNameOfNode(element);
    }

    public String getExpandedAttributeName(Attr attr) {
        String string = this.getNamespaceOfNode(attr);
        if (string != null) {
            return String.valueOf(string) + ":" + this.getLocalNameOfNode(attr);
        }
        return this.getLocalNameOfNode(attr);
    }

    public boolean isIgnorableWhitespace(Text text) {
        boolean bl = false;
        return bl;
    }

    public Node getRoot(Node node) {
        Node node2 = null;
        while (node != null) {
            node2 = node;
            node = this.getParentOfNode(node);
        }
        return node2;
    }

    public Node getRootNode(Node node) {
        if (node.getNodeType() == 9) {
            return node;
        }
        return node.getOwnerDocument();
    }

    public boolean isNamespaceNode(Node node) {
        if (node.getNodeType() == 2) {
            String string = node.getNodeName();
            return string.startsWith("xmlns:") || string.equals("xmlns");
        }
        return false;
    }

    public Node getParentOfNode(Node node) throws RuntimeException {
        Node node2;
        short s = node.getNodeType();
        if (s == 2) {
            Document document = node.getOwnerDocument();
            Element element = document.getDocumentElement();
            if (element == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(56, null));
            }
            node2 = this.locateAttrParent(element, node);
        } else {
            node2 = node.getParentNode();
        }
        return node2;
    }

    public Element getElementByID(String string, Document document) {
        return null;
    }

    public String getUnparsedEntityURI(String string, Document document) {
        NamedNodeMap namedNodeMap;
        Entity entity;
        String string2;
        String string3 = "";
        DocumentType documentType = document.getDoctype();
        if (documentType != null && (string2 = (entity = (Entity)(namedNodeMap = documentType.getEntities()).getNamedItem(string)).getNotationName()) != null && (string3 = entity.getSystemId()) == null) {
            string3 = entity.getPublicId();
        }
        return string3;
    }

    private Node locateAttrParent(Element element, Node node) {
        Node node2 = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (node == namedNodeMap.item(n2)) {
                    node2 = element;
                    break;
                }
                ++n2;
            }
        }
        if (node2 == null) {
            Node node3 = element.getFirstChild();
            while (node3 != null) {
                if (node3.getNodeType() == 1 && (node2 = this.locateAttrParent((Element)node3, node)) != null) break;
                node3 = node3.getNextSibling();
            }
        }
        return node2;
    }

    public void setDOMFactory(Document document) {
        this.m_DOMFactory = document;
    }

    public Document getDOMFactory() {
        if (this.m_DOMFactory == null) {
            this.m_DOMFactory = this.createDocument();
        }
        return this.m_DOMFactory;
    }

    public static String getNodeData(Node node) {
        String string;
        FastStringBuffer fastStringBuffer = StringBufferPool.get();
        try {
            DOMHelper.getNodeData(node, fastStringBuffer);
            string = fastStringBuffer.length() > 0 ? fastStringBuffer.toString() : "";
        }
        finally {
            Object var4_3 = null;
            StringBufferPool.free(fastStringBuffer);
        }
        return string;
    }

    public static void getNodeData(Node node, FastStringBuffer fastStringBuffer) {
        switch (node.getNodeType()) {
            case 11: {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    DOMHelper.getNodeData(nodeList.item(n2), fastStringBuffer);
                    ++n2;
                }
                return;
            }
            case 1: 
            case 9: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    DOMHelper.getNodeData(node2, fastStringBuffer);
                    node2 = node2.getNextSibling();
                }
                return;
            }
            case 3: 
            case 4: {
                fastStringBuffer.append(node.getNodeValue());
                return;
            }
            case 2: {
                fastStringBuffer.append(node.getNodeValue());
                return;
            }
        }
    }
}

