/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.trax.ProcessorException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Expression {
    protected XPath m_xpath;

    public abstract XObject execute(XPathContext var1) throws SAXException;

    public void warn(XPathContext xPathContext, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createXPATHWarning(n, objectArray);
        ErrorHandler errorHandler = xPathContext.getPrimaryReader().getErrorHandler();
        if (errorHandler != null) {
            errorHandler.warning(new ProcessorException(string));
        }
    }

    public void assert(boolean bl, String string) throws SAXException {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    public void error(XPathContext xPathContext, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        ProcessorException processorException = new ProcessorException(string, this.m_xpath.getLocator());
        ErrorHandler errorHandler = xPathContext.getPrimaryReader().getErrorHandler();
        if (errorHandler != null) {
            errorHandler.fatalError(processorException);
            return;
        }
        System.out.println(String.valueOf(processorException.getMessage()) + "; file " + processorException.getSystemId() + "; line " + processorException.getLineNumber() + "; column " + processorException.getColumnNumber());
    }
}

