/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.xalan.utils.NodeVector;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSet
extends NodeVector
implements NodeList,
NodeIterator,
Cloneable,
ContextNodeList {
    protected int m_next;
    protected boolean m_mutable = true;
    protected boolean m_cacheNodes = true;

    public NodeSet() {
    }

    public NodeSet(int n) {
        super(n);
    }

    public NodeSet(NodeList nodeList) {
        this.addNodes(nodeList);
    }

    public NodeSet(NodeSet nodeSet) {
        this.addNodes((NodeIterator)nodeSet);
    }

    public NodeSet(NodeIterator nodeIterator) {
        this.addNodes(nodeIterator);
    }

    public NodeSet(Node node) {
        this.addNode(node);
    }

    public Node getRoot() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSet nodeSet = (NodeSet)super.clone();
        return nodeSet;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSet nodeSet = (NodeSet)this.clone();
        nodeSet.reset();
        return nodeSet;
    }

    public void reset() {
        this.m_next = 0;
    }

    public int getWhatToShow() {
        return -17;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public Node nextNode() throws DOMException {
        if (this.m_next < this.size()) {
            Node node = this.elementAt(this.m_next);
            ++this.m_next;
            return node;
        }
        return null;
    }

    public Node previousNode() throws DOMException {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return null;
    }

    public void detach() {
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public void runTo(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        if (n >= 0 && this.m_next < this.m_firstFree) {
            this.m_next = n;
            return;
        }
        this.m_next = this.m_firstFree - 1;
    }

    public Node item(int n) {
        this.runTo(n);
        return this.elementAt(n);
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public void addNode(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.addElement(node);
    }

    public void insertNode(Node node, int n) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.insertElementAt(node, n);
    }

    public void removeNode(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.removeElement(node);
    }

    public void addNodes(NodeList nodeList) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        if (nodeList != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node != null) {
                    this.addElement(node);
                }
                ++n2;
            }
        }
    }

    public void addNodes(NodeSet nodeSet) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        this.addNodes((NodeIterator)nodeSet);
    }

    public void addNodes(NodeIterator nodeIterator) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        if (nodeIterator != null) {
            Node node;
            while ((node = nodeIterator.nextNode()) != null) {
                this.addElement(node);
            }
        }
    }

    public void addNodesInDocOrder(NodeList nodeList, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node != null) {
                this.addNodeInDocOrder(node, xPathContext);
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addNodesInDocOrder(NodeIterator var1_1, XPathContext var2_2) {
        if (this.m_mutable) ** GOTO lbl5
        throw new RuntimeException("This NodeSet is not mutable!");
lbl-1000:
        // 1 sources

        {
            this.addNodeInDocOrder(var3_3, var2_2);
lbl5:
            // 2 sources

            ** while ((var3_3 = var1_1.nextNode()) != null)
        }
lbl6:
        // 1 sources

    }

    private boolean addNodesInDocOrder(int n, int n2, int n3, NodeList nodeList, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        boolean bl = false;
        Node node = nodeList.item(n3);
        int n4 = n2;
        while (n4 >= n) {
            Node node2 = this.elementAt(n4);
            if (node2 == node) {
                n4 = -2;
                break;
            }
            if (!xPathContext.getDOMHelper().isNodeAfter(node, node2)) {
                boolean bl2;
                this.insertElementAt(node, n4 + 1);
                if (--n3 <= 0 || (bl2 = this.addNodesInDocOrder(0, n4, n3, nodeList, xPathContext))) break;
                this.addNodesInDocOrder(n4, this.size() - 1, n3, nodeList, xPathContext);
                break;
            }
            --n4;
        }
        if (n4 == -1) {
            this.insertElementAt(node, 0);
        }
        return bl;
    }

    public int addNodeInDocOrder(Node node, boolean bl, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        int n = -1;
        if (bl) {
            int n2 = this.size();
            int n3 = n2 - 1;
            while (n3 >= 0) {
                Node node2 = this.elementAt(n3);
                if (node2 == node) {
                    n3 = -2;
                    break;
                }
                if (!xPathContext.getDOMHelper().isNodeAfter(node, node2)) break;
                --n3;
            }
            if (n3 != -2) {
                n = n3 + 1;
                this.insertElementAt(node, n);
            }
        } else {
            n = this.size();
            boolean bl2 = false;
            int n4 = 0;
            while (n4 < n) {
                if (this.item(n4).equals(node)) {
                    bl2 = true;
                    break;
                }
                ++n4;
            }
            if (!bl2) {
                this.addElement(node);
            }
        }
        return n;
    }

    public int addNodeInDocOrder(Node node, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        return this.addNodeInDocOrder(node, true, xPathContext);
    }

    public int size() {
        return super.size();
    }

    public void addElement(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.addElement(node);
    }

    public void insertElementAt(Node node, int n) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.insertElementAt(node, n);
    }

    public void appendNodes(NodeVector nodeVector) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.appendNodes(nodeVector);
    }

    public void removeAllElements() {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.removeAllElements();
    }

    public boolean removeElement(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        return super.removeElement(node);
    }

    public void removeElementAt(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.removeElementAt(n);
    }

    public void setElementAt(Node node, int n) {
        if (!this.m_mutable) {
            throw new RuntimeException("This NodeSet is not mutable!");
        }
        super.setElementAt(node, n);
    }

    public Node elementAt(int n) {
        this.runTo(n);
        return super.elementAt(n);
    }

    public boolean contains(Node node) {
        this.runTo(-1);
        return super.contains(node);
    }

    public int indexOf(Node node, int n) {
        this.runTo(-1);
        return super.indexOf(node, n);
    }

    public int indexOf(Node node) {
        this.runTo(-1);
        return super.indexOf(node);
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public void setCurrentPos(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.m_next = n;
    }

    public Node getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        return this.elementAt(this.m_next);
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public void setShouldCacheNodes(boolean bl) {
        if (!this.isFresh()) {
            throw new RuntimeException("Can not call setShouldCacheNodes after nextNode has been called!");
        }
        this.m_cacheNodes = bl;
        this.m_mutable = true;
    }
}

