/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.IOException;
import java.util.Vector;
import org.apache.trax.TransformException;
import org.apache.trax.URIResolver;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.utils.SystemIDResolver;
import org.apache.xpath.DOM2Helper;
import org.apache.xpath.SourceTree;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceTreeManager {
    private Vector m_sourceTree = new Vector();
    URIResolver m_uriResolver;
    EntityResolver m_entityResolver;

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.m_entityResolver = entityResolver;
    }

    public String findURIFromDoc(Document document) {
        Document document2 = document.getOwnerDocument();
        if (document2 == null) {
            document2 = document;
        }
        String string = null;
        int n = this.m_sourceTree.size();
        int n2 = 0;
        while (n2 < n) {
            SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(n2);
            if (document2 == sourceTree.m_root) {
                string = sourceTree.m_url;
                break;
            }
            ++n2;
        }
        return string;
    }

    public InputSource resolveURI(String string, String string2, Locator locator) throws TransformException, IOException {
        InputSource inputSource;
        String string3;
        try {
            string3 = SystemIDResolver.getAbsoluteURI(string2, string);
        }
        catch (SAXException sAXException) {
            if (this.m_entityResolver != null) {
                try {
                    return this.m_entityResolver.resolveEntity(null, string2);
                }
                catch (SAXException sAXException2) {
                    throw new TransformException("URL of base: " + string + " and url: " + string2 + " can't be resolved", locator, sAXException2);
                }
            }
            throw new TransformException("URL of base: " + string + " and url: " + string2 + " can't be resolved", locator, sAXException);
        }
        try {
            inputSource = this.m_entityResolver != null ? this.m_entityResolver.resolveEntity(null, string2) : new InputSource(string3);
        }
        catch (SAXException sAXException) {
            throw new TransformException("URL: " + string2 + " can't be resolved", locator, sAXException);
        }
        return inputSource;
    }

    public void putDocumentInCache(Node node, InputSource inputSource) {
        if (inputSource.getSystemId() != null) {
            this.m_sourceTree.addElement(new SourceTree(node, inputSource.getSystemId()));
        }
    }

    public Node findNodeFromURL(String string, String string2, Locator locator) throws TransformException {
        try {
            InputSource inputSource = this.resolveURI(string, string2, locator);
            if (inputSource.getSystemId() != null) {
                string2 = inputSource.getSystemId();
            }
            Node node = null;
            int n = this.m_sourceTree.size();
            int n2 = 0;
            while (n2 < n) {
                SourceTree sourceTree = (SourceTree)this.m_sourceTree.elementAt(n2);
                if (string2.equals(sourceTree.m_url)) {
                    node = sourceTree.m_root;
                    break;
                }
                ++n2;
            }
            return node;
        }
        catch (IOException iOException) {
            throw new TransformException(iOException, locator);
        }
    }

    public Node getSourceTree(String string, String string2, Locator locator) throws TransformException {
        try {
            InputSource inputSource = this.resolveURI(string, string2, locator);
            return this.getSourceTree(inputSource, locator);
        }
        catch (IOException iOException) {
            throw new TransformException(iOException, locator);
        }
    }

    public Node getSourceTree(InputSource inputSource, Locator locator) throws TransformException {
        Node node;
        if (inputSource.getSystemId() != null && (node = this.findNodeFromURL(null, inputSource.getSystemId(), locator)) != null) {
            return node;
        }
        node = null;
        if (this.m_uriResolver != null) {
            node = this.m_uriResolver.getDOMNode(inputSource);
        }
        if (node == null) {
            node = this.getDOMNode(inputSource, locator);
        }
        if (node != null) {
            this.putDocumentInCache(node, inputSource);
        }
        return node;
    }

    public Node getDOMNode(InputSource inputSource, Locator locator) throws TransformException {
        Node node = null;
        String string = System.getProperty("org.apache.xalan.source.liaison");
        if (string != null) {
            try {
                DOM2Helper dOM2Helper = (DOM2Helper)Class.forName(string).newInstance();
                dOM2Helper.parse(inputSource);
                node = dOM2Helper.getDocument();
            }
            catch (SAXException sAXException) {
                throw new TransformException(sAXException, locator);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TransformException("XML Liaison class " + string + " specified but not found", locator, classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TransformException("XML Liaison class " + string + " found but cannot be loaded", locator, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new TransformException("XML Liaison class " + string + " loaded but cannot be instantiated (no empty public constructor?)", locator, instantiationException);
            }
            catch (ClassCastException classCastException) {
                throw new TransformException("XML Liaison class " + string + " does not implement DOM2Helper", locator, classCastException);
            }
        }
        try {
            XMLReader xMLReader = this.getXMLReader(inputSource, locator);
            SourceTreeHandler sourceTreeHandler = new SourceTreeHandler();
            if (sourceTreeHandler instanceof SourceTreeHandler) {
                sourceTreeHandler.setUseMultiThreading(false);
            }
            xMLReader.setContentHandler(sourceTreeHandler);
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sourceTreeHandler);
            }
            catch (SAXException sAXException) {}
            xMLReader.parse(inputSource);
            if (sourceTreeHandler instanceof SourceTreeHandler) {
                node = sourceTreeHandler.getRoot();
            }
        }
        catch (IOException iOException) {
            throw new TransformException(iOException, locator);
        }
        catch (SAXException sAXException) {
            throw new TransformException(sAXException, locator);
        }
        return node;
    }

    public XMLReader getXMLReader(InputSource inputSource, Locator locator) throws TransformException {
        try {
            XMLReader xMLReader;
            XMLReader xMLReader2 = xMLReader = this.m_uriResolver != null ? this.m_uriResolver.getXMLReader(inputSource) : null;
            if (xMLReader == null) {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            try {
                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                xMLReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException sAXException) {}
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new TransformException(sAXException, locator);
        }
    }
}

