/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.util.Stack;
import org.apache.xalan.utils.IntStack;
import org.apache.xalan.utils.QName;
import org.apache.xpath.Arg;
import org.apache.xpath.objects.XObject;
import org.xml.sax.SAXException;

public class VariableStack
extends Stack {
    private static final Integer contextMarker = new Integer(0);
    private int m_globalStackFrameIndex = -1;
    private int m_currentStackFrameIndex;
    private IntStack m_elemFramePos = new IntStack();

    public VariableStack() {
        this.pushContextMarker();
    }

    public void markGlobalStackFrame() {
        this.m_globalStackFrameIndex = this.size();
        this.push(contextMarker);
    }

    public void setCurrentStackFrameIndex(int n) {
        this.m_currentStackFrameIndex = n;
    }

    public int getCurrentStackFrameIndex() {
        return this.m_currentStackFrameIndex;
    }

    public void pushContextMarker() {
        this.push(contextMarker);
    }

    public Object push(Object object) {
        if (this.m_currentStackFrameIndex == this.size()) {
            ++this.m_currentStackFrameIndex;
        }
        return super.push(object);
    }

    public Object pop() {
        if (this.m_currentStackFrameIndex == this.size()) {
            --this.m_currentStackFrameIndex;
        }
        return super.pop();
    }

    public void setStackSize(int n) {
        boolean bl = this.m_currentStackFrameIndex == this.size();
        this.setSize(n);
        if (bl) {
            this.m_currentStackFrameIndex = n;
        }
    }

    public void popCurrentContext() {
        int n = this.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.elementAt(n2) == contextMarker) {
                this.setStackSize(n2);
                return;
            }
            --n2;
        }
    }

    public void pushVariable(QName qName, XObject xObject) {
        this.push(new Arg(qName, xObject, false));
    }

    public XObject getParamVariable(QName qName) throws SAXException {
        XObject xObject = null;
        int n = this.getCurrentStackFrameIndex();
        int n2 = n - 1;
        while (n2 >= 0) {
            Object e = this.elementAt(n2);
            if (e == contextMarker) break;
            if (((Arg)e).equals(qName)) {
                xObject = ((Arg)e).getVal();
                break;
            }
            --n2;
        }
        return xObject;
    }

    public Object getVariable(QName qName) throws SAXException {
        int n = this.getCurrentStackFrameIndex();
        int n2 = n - 1;
        while (n2 >= 0) {
            Object e = this.elementAt(n2);
            if (e == contextMarker) break;
            if (((Arg)e).equals(qName)) {
                return ((Arg)e).getVal();
            }
            --n2;
        }
        int n3 = this.m_globalStackFrameIndex - 1;
        while (n3 >= 1) {
            Object e = this.elementAt(n3);
            if (e == contextMarker) break;
            if (((Arg)e).equals(qName)) {
                return ((Arg)e).getVal();
            }
            --n3;
        }
        return null;
    }

    public void pushElemFrame() {
        this.m_elemFramePos.push(this.size());
    }

    public void popElemFrame() {
        int n = this.m_elemFramePos.pop();
        boolean bl = this.m_currentStackFrameIndex == this.size();
        this.setSize(n);
        if (bl) {
            this.m_currentStackFrameIndex = n;
        }
    }
}

