/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import org.apache.trax.TransformException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.utils.PrefixResolver;
import org.apache.xalan.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.functions.Function;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XPath
implements Serializable {
    private Expression m_mainExp;
    private Locator m_locator;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    private static final boolean DEBUG_MATCHES = false;
    private Vector m_targetStrings;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    public Expression getExpression() {
        return this.m_mainExp;
    }

    public void setExpression(Expression expression) {
        this.m_mainExp = expression;
    }

    public Locator getLocator() {
        return this.m_locator;
    }

    public void setLocator(Locator locator) {
        this.m_locator = locator;
    }

    public String getPatternString() {
        return this.m_patternString;
    }

    public XPath(String string, Locator locator, PrefixResolver prefixResolver, int n) throws SAXException {
        if (locator != null) {
            this.m_locator = new LocatorImpl(locator);
        }
        this.m_patternString = string;
        XPathParser xPathParser = new XPathParser();
        Compiler compiler = new Compiler(null, locator);
        if (n == 0) {
            xPathParser.initXPath(compiler, string, prefixResolver);
        } else if (n == 1) {
            xPathParser.initMatchPattern(compiler, string, prefixResolver);
        } else {
            throw new RuntimeException("Can not deal with XPath type: " + n);
        }
        Expression expression = compiler.compile(0);
        this.setExpression(expression);
        if (n == 1) {
            this.calcTargetStrings(compiler);
        }
    }

    /*
     * Unable to fully structure code
     */
    public XObject execute(XPathContext var1_1, Node var2_2, PrefixResolver var3_3) throws SAXException {
        var4_4 = var1_1.getNamespaceContext();
        var1_1.setNamespaceContext(var3_3);
        var1_1.pushCurrentNode(var2_2);
        var1_1.pushCurrentExpressionNode(var2_2);
        var5_5 = null;
        try {
            try {
                var5_5 = this.m_mainExp.execute(var1_1);
            }
            catch (Exception var8_6) {
                if (var8_6 instanceof TransformException) {
                    throw (TransformException)var8_6;
                }
                ** GOTO lbl15
            }
lbl-1000:
            // 1 sources

            {
                var8_7 = ((WrappedRuntimeException)var8_7).getException();
lbl15:
                // 2 sources

                ** while (var8_7 instanceof WrappedRuntimeException)
            }
lbl16:
            // 1 sources

            throw new TransformException("Error in XPath", this.m_locator, var8_7);
            var7_8 = null;
            var1_1.setNamespaceContext(var4_4);
            var1_1.popCurrentNode();
            var1_1.popCurrentExpressionNode();
        }
        catch (Throwable var6_10) {
            var7_9 = null;
            var1_1.setNamespaceContext(var4_4);
            var1_1.popCurrentNode();
            var1_1.popCurrentExpressionNode();
            throw var6_10;
        }
        return var5_5;
    }

    public double getMatchScore(XPathContext xPathContext, Node node) throws SAXException {
        xPathContext.pushCurrentNode(node);
        xPathContext.pushCurrentExpressionNode(node);
        try {
            XObject xObject = this.m_mainExp.execute(xPathContext);
            double d = xObject.num();
            Object var6_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public void installFunction(String string, int n, Function function) {
        FunctionTable.installFunction(function, n);
    }

    private void calcTargetStrings(Compiler compiler) {
        Vector<String> vector = new Vector<String>();
        int n = 2;
        while (compiler.getOp(n) == 31) {
            int n2 = compiler.getNextOpPos(n);
            n = OpMap.getFirstChildPos(n);
            while (compiler.getOp(n) != -1) {
                int n3 = compiler.getNextOpPos(n);
                int n4 = compiler.getOp(n3);
                if (n4 == 29 || n4 == -1) {
                    int n5 = compiler.getOp(n);
                    n += 3;
                    block0 : switch (n5) {
                        case 25: {
                            vector.addElement("*");
                            break;
                        }
                        case 50: {
                            vector.addElement("/");
                            break;
                        }
                        case 51: 
                        case 52: 
                        case 53: {
                            int n6 = compiler.getOp(n);
                            ++n;
                            switch (n6) {
                                case 1030: {
                                    vector.addElement("#comment");
                                    break block0;
                                }
                                case 1031: {
                                    vector.addElement("#text");
                                    break block0;
                                }
                                case 1033: {
                                    vector.addElement("*");
                                    break block0;
                                }
                                case 35: {
                                    vector.addElement("/");
                                    break block0;
                                }
                                case 36: {
                                    vector.addElement("*");
                                    break block0;
                                }
                                case 1032: {
                                    vector.addElement("*");
                                    break block0;
                                }
                                case 34: {
                                    int n7 = compiler.getOp(n + 1);
                                    if (n7 >= 0) {
                                        String string = (String)compiler.m_tokenQueue[n7];
                                        if (string.equals("*")) {
                                            vector.addElement("*");
                                            break block0;
                                        }
                                        vector.addElement(string);
                                        break block0;
                                    }
                                    vector.addElement("*");
                                    break block0;
                                }
                            }
                            vector.addElement("*");
                            break;
                        }
                    }
                }
                n = n3;
            }
            n = n2;
        }
        this.m_targetStrings = vector;
    }

    public Vector getTargetElementStrings() {
        return this.m_targetStrings;
    }

    public void warn(XPathContext xPathContext, Node node, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createXPATHWarning(n, objectArray);
        ErrorHandler errorHandler = xPathContext.getPrimaryReader().getErrorHandler();
        if (errorHandler != null) {
            errorHandler.warning(new TransformException(string));
        }
    }

    public void assert(boolean bl, String string) throws SAXException {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    public void error(XPathContext xPathContext, Node node, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        ErrorHandler errorHandler = xPathContext.getPrimaryReader().getErrorHandler();
        TransformException transformException = new TransformException(string, xPathContext.getSAXLocator());
        if (errorHandler != null) {
            errorHandler.fatalError(transformException);
            return;
        }
        System.out.println(String.valueOf(transformException.getMessage()) + "; file " + transformException.getSystemId() + "; line " + transformException.getLineNumber() + "; column " + transformException.getColumnNumber());
    }
}

