/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.trax.TransformException;
import org.apache.trax.URIResolver;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.utils.NodeVector;
import org.apache.xalan.utils.PrefixResolver;
import org.apache.xalan.utils.QName;
import org.apache.xpath.DOM2Helper;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.SourceTreeManager;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XPathContext
implements ExpressionContext {
    Locator m_saxLocation;
    private Object m_owner;
    private ExtensionsTable m_extensionsTable = new ExtensionsTable();
    private VariableStack m_variableStacks = new VariableStack();
    private DOMHelper m_domHelper;
    private SourceTreeManager m_sourceTreeManager = new SourceTreeManager();
    private URIResolver m_uriResolver;
    public XMLReader m_primaryReader;
    private static XSLMessages m_XSLMessages = new XSLMessages();
    private Stack m_contextNodeLists = new Stack();
    private PrefixResolver m_currentPrefixResolver;
    private NodeVector m_currentNodes = new NodeVector();
    private Stack m_currentExpressionNodes = new Stack();
    private Stack m_axesIteratorStack = new Stack();

    public XPathContext() {
    }

    public XPathContext(Object object) {
        this.m_owner = object;
    }

    public void copyFromOtherLiaison(XPathContext xPathContext) throws SAXException {
    }

    public void reset() {
    }

    public void setSAXLocator(Locator locator) {
        this.m_saxLocation = locator;
    }

    public Locator getSAXLocator() {
        return this.m_saxLocation;
    }

    public Object getOwnerObject() {
        return this.m_owner;
    }

    public ExtensionsTable getExtensionsTable() {
        return this.m_extensionsTable;
    }

    void setExtensionsTable(ExtensionsTable extensionsTable) {
        this.m_extensionsTable = extensionsTable;
    }

    public VariableStack getVarStack() {
        return this.m_variableStacks;
    }

    public void setVarStack(VariableStack variableStack) {
        this.m_variableStacks = variableStack;
    }

    public XObject getVariable(QName qName) throws SAXException {
        Object object = this.getVarStack().getVariable(qName);
        if (object != null && !(object instanceof XObject)) {
            object = new XObject(object);
        }
        return (XObject)object;
    }

    public final DOMHelper getDOMHelper() {
        if (this.m_domHelper == null) {
            this.m_domHelper = new DOM2Helper();
        }
        return this.m_domHelper;
    }

    public void setDOMHelper(DOMHelper dOMHelper) {
        this.m_domHelper = dOMHelper;
    }

    public final SourceTreeManager getSourceTreeManager() {
        return this.m_sourceTreeManager;
    }

    public void setSourceTreeManager(SourceTreeManager sourceTreeManager) {
        this.m_sourceTreeManager = sourceTreeManager;
    }

    public final URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public final XMLReader getPrimaryReader() {
        return this.m_primaryReader;
    }

    public void setPrimaryReader(XMLReader xMLReader) {
        this.m_primaryReader = xMLReader;
    }

    public final String getAbsoluteURI(String string, String string2) throws SAXException {
        InputSource inputSource;
        try {
            inputSource = this.getSourceTreeManager().resolveURI(string2, string, this.getSAXLocator());
        }
        catch (IOException iOException) {
            Object var3_4 = null;
            throw new SAXException(iOException);
        }
        return inputSource.getSystemId();
    }

    private void assert(boolean bl, String string) throws SAXException {
        ErrorHandler errorHandler = this.getPrimaryReader().getErrorHandler();
        if (errorHandler != null) {
            errorHandler.fatalError(new TransformException(XSLMessages.createMessage(30, new Object[]{string})));
        }
    }

    public final ContextNodeList getContextNodeList() {
        if (this.m_contextNodeLists.size() > 0) {
            return (ContextNodeList)this.m_contextNodeLists.peek();
        }
        return null;
    }

    public final void pushContextNodeList(ContextNodeList contextNodeList) {
        this.m_contextNodeLists.push(contextNodeList);
    }

    public final void popContextNodeList() {
        this.m_contextNodeLists.pop();
    }

    public final Node getCurrentNode() {
        return this.m_currentNodes.peepOrNull();
    }

    public final void pushCurrentNodeAndExpression(Node node, Node node2) {
        this.m_currentNodes.push(node);
        this.m_currentExpressionNodes.push(node2);
    }

    public final void popCurrentNodeAndExpression() {
        this.m_currentNodes.pop();
        this.m_currentExpressionNodes.pop();
    }

    public final void pushCurrentNode(Node node) {
        this.m_currentNodes.push(node);
    }

    public final void popCurrentNode() {
        this.m_currentNodes.popQuick();
    }

    public final Node getCurrentExpressionNode() {
        try {
            return (Node)this.m_currentExpressionNodes.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public final void pushCurrentExpressionNode(Node node) {
        this.m_currentExpressionNodes.push(node);
    }

    public final void popCurrentExpressionNode() {
        this.m_currentExpressionNodes.pop();
    }

    public final PrefixResolver getNamespaceContext() {
        return this.m_currentPrefixResolver;
    }

    public final void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_currentPrefixResolver = prefixResolver;
    }

    public final void pushSubContextList(SubContextList subContextList) {
        this.m_axesIteratorStack.push(subContextList);
    }

    public final void popSubContextList() {
        this.m_axesIteratorStack.pop();
    }

    public SubContextList getSubContextList() {
        if (this.m_axesIteratorStack.isEmpty()) {
            return null;
        }
        return (SubContextList)this.m_axesIteratorStack.peek();
    }

    public final Node getContextNode() {
        return this.getCurrentNode();
    }

    public final NodeIterator getContextNodes() {
        try {
            ContextNodeList contextNodeList = this.getContextNodeList();
            if (contextNodeList != null) {
                return contextNodeList.cloneWithReset();
            }
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final double toNumber(Node node) {
        return XNodeSet.getNumberFromNode(node);
    }

    public final String toString(Node node) {
        return XNodeSet.getStringFromNode(node);
    }
}

