/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Stack;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.ReverseAxesWalker;
import org.w3c.dom.Node;

public class AncestorWalker
extends ReverseAxesWalker {
    protected Stack m_ancestors;

    public AncestorWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    protected void pushAncestors(Node node) {
        this.m_ancestors = new Stack();
        DOMHelper dOMHelper = this.m_lpi.getDOMHelper();
        while ((node = dOMHelper.getParentOfNode(node)) != null) {
            this.m_ancestors.push(node);
        }
        this.m_nextLevelAmount = this.m_ancestors.isEmpty() ? 0 : 1;
    }

    public void setRoot(Node node) {
        this.pushAncestors(node);
        super.setRoot(node);
    }

    public Node firstChild() {
        Node node = this.m_ancestors.isEmpty() ? null : (Node)this.m_ancestors.pop();
        this.m_nextLevelAmount = this.m_ancestors.isEmpty() ? 0 : 1;
        return this.setCurrentIfNotNull(node);
    }

    protected int getLevelMax() {
        DOMHelper dOMHelper = this.m_lpi.getDOMHelper();
        Node node = dOMHelper.getParentOfNode(this.m_root);
        if (node == null) {
            return 1;
        }
        return dOMHelper.getLevel(node);
    }
}

