/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.StringTokenizer;
import org.apache.xalan.stree.Child;
import org.apache.xalan.utils.PrefixResolver;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.NodeTestFilter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public abstract class AxesWalker
extends NodeTest
implements Cloneable,
TreeWalker,
NodeFilter,
SubContextList {
    boolean DEBUG = false;
    boolean DEBUG_WAITING = false;
    boolean DEBUG_TRAVERSAL = false;
    boolean DEBUG_LOCATED = false;
    boolean DEBUG_PREDICATECOUNTING = false;
    protected LocPathIterator m_lpi;
    private int m_stepType;
    private int m_argLen;
    protected int m_analysis = 1;
    protected int[] m_proximityPositions;
    int m_predicateIndex = -1;
    int m_predicateCount;
    private Expression[] m_predicates;
    Node m_root;
    boolean m_isFresh;
    Node m_currentNode;
    protected AxesWalker m_nextWalker;
    AxesWalker m_prevWalker;
    private boolean m_waitingForNext = false;
    protected int m_nextLevelAmount;
    private boolean m_didSwitch = false;
    boolean m_isDone = false;
    protected boolean m_testedForNTF = false;
    Node m_prevReturned;
    static boolean m_didDumpAll;

    public LocPathIterator getLocPathIterator() {
        return this.m_lpi;
    }

    public void setLocPathIterator(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    public AxesWalker(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    public void init(Compiler compiler, int n, int n2) throws SAXException {
        this.m_stepType = n2;
        switch (n2) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_argLen = compiler.getArgLength(n);
                break;
            }
            default: {
                this.m_argLen = compiler.getArgLengthOfStep(n);
            }
        }
        this.initPredicateInfo(compiler, n);
    }

    public Object clone() throws CloneNotSupportedException {
        AxesWalker axesWalker = (AxesWalker)super.clone();
        if (this.m_proximityPositions != null && this.m_proximityPositions == axesWalker.m_proximityPositions) {
            axesWalker.m_proximityPositions = new int[this.m_proximityPositions.length];
            System.arraycopy(this.m_proximityPositions, 0, axesWalker.m_proximityPositions, 0, this.m_proximityPositions.length);
        }
        this.m_testedForNTF = false;
        return axesWalker;
    }

    public void reset() {
        this.setCurrentNode(this.m_root);
        this.m_isFresh = true;
    }

    protected int getStepType() {
        return this.m_stepType;
    }

    protected int getArgLen() {
        return this.m_argLen;
    }

    int getAnalysis() {
        return this.m_analysis;
    }

    void setAnalysis(int n) {
        this.m_analysis = n;
    }

    public int getProximityPosition() {
        return this.getProximityPosition(this.m_predicateIndex);
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition();
    }

    protected int getProximityPosition(int n) {
        if (n >= 0) {
            return this.m_proximityPositions[n];
        }
        return 0;
    }

    public void resetProximityPositions() throws SAXException {
        if (this.m_predicateCount > 0) {
            if (this.m_proximityPositions == null) {
                this.m_proximityPositions = new int[this.m_predicateCount];
            }
            int n = 0;
            while (n < this.m_predicateCount) {
                this.initProximityPosition(n);
                ++n;
            }
        }
    }

    public void initProximityPosition(int n) throws SAXException {
        this.m_proximityPositions[n] = 0;
    }

    protected void countProximityPosition(int n) {
        if (n < this.m_proximityPositions.length) {
            int n2 = n;
            this.m_proximityPositions[n2] = this.m_proximityPositions[n2] + 1;
        }
    }

    public boolean isReverseAxes() {
        return false;
    }

    public int getPredicateIndex() {
        return this.m_predicateIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean executePredicates(Node node, XPathContext xPathContext) throws SAXException {
        int n;
        PrefixResolver prefixResolver;
        block10: {
            boolean bl;
            block9: {
                this.m_predicateIndex = 0;
                int n2 = this.m_predicateCount;
                if (n2 == 0) {
                    return true;
                }
                prefixResolver = xPathContext.getNamespaceContext();
                n = xPathContext.getVarStack().getCurrentStackFrameIndex();
                try {
                    xPathContext.pushSubContextList(this);
                    xPathContext.getVarStack().setCurrentStackFrameIndex(this.m_lpi.getStackFrameIndex());
                    xPathContext.setNamespaceContext(this.m_lpi.getPrefixResolver());
                    xPathContext.pushCurrentNode(node);
                    int n3 = 0;
                    while (n3 < n2) {
                        XObject xObject = this.m_predicates[n3].execute(xPathContext);
                        if (xObject.getType() == 2) {
                            if (this.DEBUG_PREDICATECOUNTING) {
                                System.out.println("=============");
                                System.out.println("m_predicateIndex: " + this.m_predicateIndex);
                                System.out.println("getProximityPosition(m_predicateIndex): " + this.getProximityPosition(this.m_predicateIndex));
                                System.out.println("pred.num(): " + xObject.num());
                            }
                            if (this.getProximityPosition(this.m_predicateIndex) != (int)xObject.num()) {
                                boolean bl2 = false;
                                Object var8_10 = null;
                                xPathContext.popCurrentNode();
                                xPathContext.setNamespaceContext(prefixResolver);
                                xPathContext.popSubContextList();
                                xPathContext.getVarStack().setCurrentStackFrameIndex(n);
                                return bl2;
                            }
                        } else if (!xObject.bool()) {
                            bl = false;
                            break block9;
                        }
                        this.countProximityPosition(++this.m_predicateIndex);
                        ++n3;
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    xPathContext.popCurrentNode();
                    xPathContext.setNamespaceContext(prefixResolver);
                    xPathContext.popSubContextList();
                    xPathContext.getVarStack().setCurrentStackFrameIndex(n);
                    throw throwable;
                }
            }
            Object var8_11 = null;
            xPathContext.popCurrentNode();
            xPathContext.setNamespaceContext(prefixResolver);
            xPathContext.popSubContextList();
            xPathContext.getVarStack().setCurrentStackFrameIndex(n);
            return bl;
        }
        Object var8_12 = null;
        xPathContext.popCurrentNode();
        xPathContext.setNamespaceContext(prefixResolver);
        xPathContext.popSubContextList();
        xPathContext.getVarStack().setCurrentStackFrameIndex(n);
        this.m_predicateIndex = -1;
        return true;
    }

    public int getPredicateCount() {
        return this.m_predicateCount;
    }

    public void setPredicateCount(int n) {
        this.m_predicateCount = n;
    }

    private void initPredicateInfo(Compiler compiler, int n) throws SAXException {
        int n2 = compiler.getFirstPredicateOpPos(n);
        this.m_predicates = compiler.getCompiledPredicates(n2);
        this.m_predicateCount = this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    boolean isAncestorOfRootContext(Node node) {
        Node node2 = this.m_root;
        while ((node2 = node2.getParentNode()) != null) {
            if (!node2.equals(node)) continue;
            return true;
        }
        return false;
    }

    public Node getRoot() {
        return this.m_root;
    }

    public void setRoot(Node node) {
        this.m_isFresh = true;
        this.m_root = node;
        this.m_currentNode = node;
        this.m_prevReturned = null;
        if (node == null) {
            throw new RuntimeException("\n !!!! Error! Setting the root of a walker to null!!!");
        }
        try {
            this.resetProximityPositions();
            return;
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.getMessage());
        }
    }

    public final Node getCurrentNode() {
        return this.m_currentNode;
    }

    public void setCurrentNode(Node node) throws DOMException {
        this.m_currentNode = node;
    }

    protected Node setCurrentIfNotNull(Node node) throws DOMException {
        if (node != null) {
            this.m_currentNode = node;
        }
        return node;
    }

    public NodeFilter getFilter() {
        return this;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public Node parentNode() {
        return null;
    }

    public Node firstChild() {
        return null;
    }

    public Node nextSibling() {
        return null;
    }

    public Node lastChild() {
        throw new RuntimeException("lastChild not supported!");
    }

    public Node previousSibling() {
        throw new RuntimeException("previousSibling not supported!");
    }

    public Node previousNode() {
        throw new RuntimeException("previousNode not supported!");
    }

    public void setNextWalker(AxesWalker axesWalker) {
        this.m_nextWalker = axesWalker;
    }

    public AxesWalker getNextWalker() {
        return this.m_nextWalker;
    }

    public void setPrevWalker(AxesWalker axesWalker) {
        this.m_prevWalker = axesWalker;
    }

    public AxesWalker getPrevWalker() {
        return this.m_prevWalker;
    }

    public String toString() {
        String string;
        String string2;
        Class<?> clazz = this.getClass();
        String string3 = clazz.getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        try {
            string2 = this.m_root == null ? "null" : String.valueOf(this.m_root.getNodeName()) + "{" + ((Child)this.m_root).getUid() + "}";
            string = this.m_root == null ? "null" : String.valueOf(this.m_currentNode.getNodeName()) + "{" + ((Child)this.m_currentNode).getUid() + "}";
        }
        catch (ClassCastException classCastException) {
            string2 = this.m_root == null ? "null" : this.m_root.getNodeName();
            string = this.m_root == null ? "null" : this.m_currentNode.getNodeName();
        }
        return String.valueOf(string3) + "[" + string2 + "][" + string + "]";
    }

    protected String nodeToString(Node node) {
        try {
            if (node != null) {
                return String.valueOf(node.getNodeName()) + "{" + ((Child)node).getUid() + "}";
            }
            return "null";
        }
        catch (ClassCastException classCastException) {
            if (node != null) {
                return node.getNodeName();
            }
            return "null";
        }
    }

    private Node returnNextNode(Node node) {
        if (this.DEBUG_LOCATED && node != null) {
            this.printDebug("RETURN --->" + this.nodeToString(node));
        } else if (this.DEBUG_LOCATED) {
            this.printDebug("RETURN --->null");
        }
        return node;
    }

    private void printDebug(String string) {
        if (this.DEBUG) {
            System.out.print("\n");
            if (this.m_currentNode != null) {
                try {
                    Child child = (Child)this.m_currentNode;
                    int n = child.getLevel();
                    int n2 = 0;
                    while (n2 < n) {
                        System.out.print(" ");
                        ++n2;
                    }
                }
                catch (ClassCastException classCastException) {}
            }
            System.out.print(string);
        }
    }

    private void dumpAll(Node node, int n) {
        Object object;
        int n2 = 0;
        while (n2 < n) {
            System.out.print(" ");
            ++n2;
        }
        System.out.print(this.nodeToString(node));
        if (node.getNodeType() == 3 && (object = node.getNodeValue()) != null) {
            System.out.print("+= -->" + ((String)object).trim());
        }
        System.out.println("");
        object = node.getAttributes();
        if (object != null) {
            int n3 = object.getLength();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = 0;
                while (n5 < n) {
                    System.out.print(" ");
                    ++n5;
                }
                System.out.print("attr -->");
                System.out.print(this.nodeToString(object.item(n4)));
                String string = object.item(n4).getNodeValue();
                if (string != null) {
                    System.out.print("+= -->" + string.trim());
                }
                System.out.println("");
                ++n4;
            }
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.dumpAll(node2, n + 1);
            node2 = node2.getNextSibling();
        }
    }

    private void printDebugAdd(String string) {
        if (this.DEBUG) {
            System.out.print("; " + string);
        }
    }

    private void printEntryDebug() {
        if (this.DEBUG_TRAVERSAL) {
            System.out.print("\n============================\n");
            if (this.m_currentNode != null) {
                try {
                    Child child = (Child)this.m_currentNode;
                    int n = child.getLevel();
                    int n2 = 0;
                    while (n2 < n) {
                        System.out.print("+");
                        ++n2;
                    }
                }
                catch (ClassCastException classCastException) {}
            }
            System.out.print(" " + this.toString() + ", " + this.nodeToString(this.m_currentNode));
            this.printWaiters();
        }
    }

    private void printWaiters() {
        if (this.DEBUG_WAITING) {
            int n = this.m_lpi.m_waiting.size();
            int n2 = 0;
            while (n2 < n) {
                AxesWalker axesWalker = (AxesWalker)this.m_lpi.m_waiting.elementAt(n2);
                this.printDebug("[" + axesWalker.toString() + " WAITING... ]");
                ++n2;
            }
            this.printDebug("Waiting count: " + n);
        }
    }

    protected int getLevelMax() {
        return 0;
    }

    protected int getNextLevelAmount() {
        return this.m_nextLevelAmount;
    }

    protected boolean checkOKToTraverse(AxesWalker axesWalker, AxesWalker axesWalker2, Node node, int n) {
        boolean bl;
        DOMHelper dOMHelper = this.m_lpi.getDOMHelper();
        short s = dOMHelper.getLevel(node);
        Node node2 = axesWalker.m_currentNode;
        if (this.DEBUG_WAITING) {
            this.printDebug("[prevStepWalker.getLevelMax():" + axesWalker.getLevelMax() + " > level:" + s + "?]");
        }
        if (!axesWalker.m_isDone && axesWalker.getLevelMax() > s) {
            boolean bl2;
            boolean bl3 = bl2 = !dOMHelper.isNodeAfter(node2, node);
            if (this.DEBUG_WAITING) {
                this.printDebug("[isNodeAfter:" + bl2 + "?]");
            }
            if (bl2) {
                short s2 = dOMHelper.getLevel(node2);
                if (this.DEBUG_WAITING) {
                    this.printDebug("[prevStepLevel:" + s2 + " <= (level:" + s + "+nextLevelAmount:" + n + "):" + (s + n) + "?]");
                }
                bl = s2 <= s + n;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        if (this.DEBUG_WAITING) {
            this.printDebug("checkOKToTraverse = " + bl);
        }
        return bl;
    }

    AxesWalker checkWaiting(AxesWalker axesWalker) {
        if (axesWalker != null && axesWalker.m_currentNode == null) {
            return axesWalker;
        }
        int n = this.m_lpi.m_waiting.size();
        int n2 = 0;
        while (n2 < n) {
            AxesWalker axesWalker2 = (AxesWalker)this.m_lpi.m_waiting.elementAt(n2);
            AxesWalker axesWalker3 = axesWalker2.m_prevWalker;
            if (axesWalker3 != null) {
                if (this.DEBUG_WAITING) {
                    this.printDebug("Calling checkOKToTraverse(" + axesWalker3.toString() + ", " + axesWalker2.toString() + ", .);");
                }
                if (this.checkOKToTraverse(axesWalker3, axesWalker2, axesWalker2.m_currentNode, axesWalker2.m_nextLevelAmount)) {
                    if (axesWalker != null) {
                        AxesWalker axesWalker4 = axesWalker;
                        if (this.DEBUG_WAITING) {
                            this.printDebug("[Moving " + axesWalker4.toString() + ", " + this.nodeToString(axesWalker4.m_currentNode) + " to WAITING list]");
                        }
                        if (!this.isWaiting(axesWalker4)) {
                            this.m_lpi.addToWaitList(axesWalker4);
                        }
                    }
                    axesWalker = axesWalker2;
                    this.m_lpi.removeFromWaitList(axesWalker);
                    if (this.DEBUG_WAITING) {
                        this.printDebug("[And using WAITING on " + axesWalker2.toString());
                    }
                    axesWalker.printEntryDebug();
                    this.m_didSwitch = true;
                    break;
                }
            }
            ++n2;
        }
        return axesWalker;
    }

    private AxesWalker getEarliestWaiting() {
        DOMHelper dOMHelper = this.m_lpi.getDOMHelper();
        AxesWalker axesWalker = null;
        int n = this.m_lpi.m_waiting.size();
        int n2 = 0;
        while (n2 < n) {
            AxesWalker axesWalker2 = (AxesWalker)this.m_lpi.m_waiting.elementAt(n2);
            if (axesWalker == null) {
                axesWalker = axesWalker2;
            } else if (!dOMHelper.isNodeAfter(axesWalker2.m_currentNode, axesWalker.m_currentNode)) {
                axesWalker = axesWalker2;
            }
            ++n2;
        }
        if (axesWalker != null) {
            this.m_lpi.removeFromWaitList(axesWalker);
            if (this.DEBUG_WAITING) {
                this.printDebug("[(getEarliestWaiting)Using WAITING on " + axesWalker.toString());
            }
            super.printEntryDebug();
        }
        return axesWalker;
    }

    boolean isWaiting(AxesWalker axesWalker) {
        int n = this.m_lpi.m_waiting.size();
        int n2 = 0;
        while (n2 < n) {
            AxesWalker axesWalker2 = (AxesWalker)this.m_lpi.m_waiting.elementAt(n2);
            if (axesWalker2 == axesWalker) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    AxesWalker checkNeedsToWait(AxesWalker axesWalker) {
        AxesWalker axesWalker2 = axesWalker.m_prevWalker;
        if (axesWalker2 != null) {
            if (this.DEBUG_WAITING) {
                this.printDebug("Calling checkOKToTraverse(" + axesWalker2.toString() + ", " + axesWalker.toString() + ", .);");
            }
            if (!this.checkOKToTraverse(axesWalker2, axesWalker, axesWalker.m_currentNode, axesWalker.m_nextLevelAmount)) {
                if (this.DEBUG_WAITING) {
                    this.printDebug("[Adding " + axesWalker.toString() + " to WAITING list");
                }
                if (this.isWaiting(axesWalker)) {
                    try {
                        if (this.DEBUG_WAITING) {
                            this.printDebug("checkNeedsToWait.clone: " + axesWalker.toString());
                        }
                        this.m_lpi.addToWaitList((AxesWalker)axesWalker.clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                } else {
                    this.m_lpi.addToWaitList(axesWalker);
                }
                axesWalker = axesWalker.m_prevWalker;
                axesWalker.printEntryDebug();
            }
        }
        return axesWalker;
    }

    protected Node getNextNode() {
        Node node;
        if (this.m_isFresh) {
            this.m_isFresh = false;
        }
        if ((node = this.getCurrentNode()).supports("NodeTestFilter", "1.0")) {
            ((NodeTestFilter)((Object)node)).setNodeTest(this);
        }
        Node node2 = this.firstChild();
        while (node2 == null) {
            Node node3;
            node2 = this.nextSibling();
            if (node2 == null && (node3 = this.parentNode()) == null) break;
        }
        if (node2 == null) {
            this.m_isDone = true;
        }
        return node2;
    }

    public Node nextNode() {
        if (this.DEBUG_TRAVERSAL && !m_didDumpAll) {
            m_didDumpAll = true;
        }
        Node node = null;
        AxesWalker axesWalker = this.m_lpi.getLastUsedWalker();
        this.m_didSwitch = false;
        boolean bl = true;
        while (true) {
            AxesWalker axesWalker2;
            if (bl) {
                axesWalker2 = this.checkWaiting(axesWalker);
                if (this.m_didSwitch) {
                    this.m_didSwitch = false;
                    axesWalker = axesWalker2;
                } else if (axesWalker != null && (axesWalker2 = this.checkNeedsToWait(axesWalker)) != axesWalker) {
                    axesWalker = axesWalker2;
                    continue;
                }
            } else {
                bl = true;
            }
            if (axesWalker != null) {
                node = axesWalker.getNextNode();
                if (this.DEBUG_TRAVERSAL) {
                    axesWalker.printDebug(String.valueOf(axesWalker.toString()) + "--NEXT->" + this.nodeToString(node) + ")");
                }
                if (node == null) {
                    axesWalker = axesWalker.m_prevWalker;
                    if (axesWalker != null) {
                        axesWalker.printEntryDebug();
                        continue;
                    }
                    axesWalker = this.getEarliestWaiting();
                    if (axesWalker == null) continue;
                    bl = false;
                    continue;
                }
                if (axesWalker.acceptNode(node) != 1) {
                    if (!this.DEBUG_TRAVERSAL) continue;
                    this.printDebugAdd("[FILTER_SKIP]");
                    continue;
                }
                if (this.DEBUG_TRAVERSAL) {
                    this.printDebugAdd("[FILTER_ACCEPT]");
                }
                if (axesWalker.m_nextWalker == null) {
                    if (this.DEBUG_TRAVERSAL) {
                        this.printDebug("May be returning: " + this.nodeToString(node));
                    }
                    if (this.DEBUG_TRAVERSAL && this.m_prevReturned != null) {
                        this.printDebugAdd(", m_prevReturned: " + this.nodeToString(this.m_prevReturned));
                    }
                    this.m_lpi.setLastUsedWalker(axesWalker);
                } else {
                    axesWalker2 = axesWalker;
                    axesWalker = axesWalker.m_nextWalker;
                    if (this.isWaiting(axesWalker)) {
                        try {
                            axesWalker = (AxesWalker)axesWalker.clone();
                            axesWalker.setRoot(node);
                            if (this.DEBUG_WAITING) {
                                this.printDebug("clone: " + axesWalker.toString());
                            }
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    } else {
                        axesWalker.setRoot(node);
                    }
                    axesWalker.m_prevWalker = axesWalker2;
                    axesWalker.printEntryDebug();
                    continue;
                }
            }
            if (node == null || this.m_prevReturned == null || node.getOwnerDocument() != this.m_prevReturned.getOwnerDocument() || !this.m_lpi.getDOMHelper().isNodeAfter(node, this.m_prevReturned)) break;
        }
        this.m_prevReturned = node;
        if (this.DEBUG_LOCATED) {
            return this.returnNextNode(node);
        }
        return node;
    }

    public int getLastPos(XPathContext xPathContext) {
        AxesWalker axesWalker;
        int n = this.getProximityPosition();
        try {
            axesWalker = (AxesWalker)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        axesWalker.setPredicateCount(axesWalker.getPredicateCount() - 1);
        axesWalker.setNextWalker(null);
        axesWalker.setPrevWalker(null);
        LocPathIterator locPathIterator = axesWalker.getLocPathIterator();
        AxesWalker axesWalker2 = locPathIterator.getLastUsedWalker();
        try {
            Node node;
            locPathIterator.setLastUsedWalker(axesWalker);
            while ((node = axesWalker.nextNode()) != null) {
                ++n;
            }
        }
        finally {
            Object var7_7 = null;
            locPathIterator.setLastUsedWalker(axesWalker2);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short acceptNode(Node node) {
        XPathContext xPathContext;
        block6: {
            short s;
            xPathContext = this.m_lpi.getXPathContext();
            try {
                try {
                    xPathContext.pushCurrentNode(node);
                    XObject xObject = this.execute(xPathContext);
                    if (xObject == NodeTest.SCORE_NONE) break block6;
                    if (this.m_predicateCount > 0) {
                        this.countProximityPosition(0);
                        if (!this.executePredicates(node, xPathContext)) {
                            short s2 = 3;
                            Object var5_7 = null;
                            xPathContext.popCurrentNode();
                            return s2;
                        }
                    }
                    s = 1;
                }
                catch (SAXException sAXException) {
                    throw new RuntimeException(sAXException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
            Object var5_8 = null;
            xPathContext.popCurrentNode();
            return s;
        }
        Object var5_9 = null;
        xPathContext.popCurrentNode();
        return 3;
    }
}

