/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import org.apache.xalan.utils.PrefixResolver;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTestFilter;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class FilterExprWalker
extends AxesWalker {
    Expression m_expr;
    NodeIterator m_nodeSet;
    Node m_peek;

    public FilterExprWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public void init(Compiler compiler, int n, int n2) throws SAXException {
        super.init(compiler, n, n2);
        switch (n2) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_expr = compiler.compile(n);
                return;
            }
        }
        this.m_expr = compiler.compile(n + 2);
    }

    public void setRoot(Node node) {
        XPathContext xPathContext = this.m_lpi.getXPathContext();
        PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
        int n = xPathContext.getVarStack().getCurrentStackFrameIndex();
        try {
            try {
                xPathContext.pushCurrentNode(node);
                xPathContext.getVarStack().setCurrentStackFrameIndex(this.m_lpi.getStackFrameIndex());
                xPathContext.setNamespaceContext(this.m_lpi.getPrefixResolver());
                XObject xObject = this.m_expr.execute(this.m_lpi.getXPathContext());
                this.m_nodeSet = xObject != null ? xObject.nodeset() : null;
                this.m_peek = null;
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException.getMessage());
            }
            Object var6_7 = null;
            xPathContext.popCurrentNode();
            xPathContext.getVarStack().setCurrentStackFrameIndex(n);
            xPathContext.setNamespaceContext(prefixResolver);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            xPathContext.popCurrentNode();
            xPathContext.getVarStack().setCurrentStackFrameIndex(n);
            xPathContext.setNamespaceContext(prefixResolver);
            throw throwable;
        }
        super.setRoot(node);
    }

    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker filterExprWalker = (FilterExprWalker)super.clone();
        if (this.m_nodeSet != null) {
            filterExprWalker.m_nodeSet = (NodeIterator)((ContextNodeList)((Object)this.m_nodeSet)).clone();
        }
        return filterExprWalker;
    }

    public void setLocPathIterator(LocPathIterator locPathIterator) {
        super.setLocPathIterator(locPathIterator);
    }

    public short acceptNode(Node node) {
        try {
            if (this.m_predicateCount > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(node, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.getMessage());
        }
    }

    public Node getNextNode() {
        Node node;
        if (this.m_peek != null) {
            node = this.m_peek;
            this.m_peek = null;
        } else if (this.m_nodeSet != null) {
            Node node2 = this.getCurrentNode();
            if (node2 instanceof NodeTestFilter) {
                ((NodeTestFilter)((Object)node2)).setNodeTest(this);
            }
            node = this.m_nodeSet.nextNode();
        } else {
            node = null;
        }
        this.m_nextLevelAmount = node == null ? 0 : (node.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(node);
    }

    protected int getLevelMax() {
        return 1;
    }
}

