/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Stack;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.w3c.dom.Node;

public class FollowingWalker
extends AxesWalker {
    protected Stack m_ancestors = new Stack();
    Node m_currentAncestor;

    public FollowingWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public void setRoot(Node node) {
        super.setRoot(node);
        this.m_currentAncestor = node;
        this.m_nextLevelAmount = 0;
    }

    public Node parentNode() {
        Node node;
        Node node2 = this.m_currentAncestor != null ? this.m_currentAncestor.getParentNode() : null;
        Node node3 = this.m_currentNode.getParentNode();
        if (node3 == node2) {
            node = null;
            Node node4 = this.m_currentAncestor;
            while (node4 != null && (node4 = node4.getParentNode()) != null) {
                node = node4.getNextSibling();
                if (node != null || node4 == null) break;
            }
            this.m_currentAncestor = node4;
        } else {
            node = node3;
        }
        return this.setCurrentIfNotNull(node);
    }

    public Node firstChild() {
        Node node;
        Node node2 = node = this.m_currentAncestor == this.m_currentNode ? this.m_currentNode.getNextSibling() : this.m_currentNode.getFirstChild();
        this.m_nextLevelAmount = node == null ? 0 : (node.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(node);
    }

    public Node nextSibling() {
        Node node = this.m_currentNode.getNextSibling();
        this.m_nextLevelAmount = node == null ? 0 : (node.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(node);
    }

    protected int getLevelMax() {
        return Short.MAX_VALUE;
    }
}

