/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import org.apache.xalan.utils.ObjectPool;
import org.apache.xalan.utils.PrefixResolver;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class LocPathIterator
extends Expression
implements Cloneable,
NodeIterator,
ContextNodeList,
NodeList {
    ObjectPool m_pool = new ObjectPool();
    NodeSet m_cachedNodes;
    private int m_next;
    protected AxesWalker m_firstWalker;
    private AxesWalker m_lastUsedWalker;
    public Vector m_waiting = new Vector();
    Node m_lastFetched;
    protected boolean m_foundLast = false;
    protected XPathContext m_execContext;
    protected DOMHelper m_dhelper;
    protected Node m_context;
    protected int m_stackFrameIndex;
    protected Node m_currentContextNode;
    protected PrefixResolver m_prefixResolver;

    public LocPathIterator(PrefixResolver prefixResolver) {
        this.m_prefixResolver = prefixResolver;
    }

    public LocPathIterator(Compiler compiler, int n) throws SAXException {
        int n2 = OpMap.getFirstChildPos(n);
        this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, n2, 0);
    }

    public LocPathIterator(Compiler compiler, int n, boolean bl) throws SAXException {
        this.m_firstWalker = WalkerFactory.loadOneWalker(this, compiler, n);
    }

    public XObject execute(XPathContext xPathContext) throws SAXException {
        try {
            LocPathIterator locPathIterator = (LocPathIterator)this.m_pool.getInstanceIfFree();
            if (locPathIterator == null) {
                locPathIterator = (LocPathIterator)this.clone();
            }
            locPathIterator.initContext(xPathContext);
            return new XNodeSet(locPathIterator);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void initContext(XPathContext xPathContext) {
        this.m_context = xPathContext.getCurrentNode();
        this.m_currentContextNode = xPathContext.getCurrentExpressionNode();
        this.m_execContext = xPathContext;
        this.m_stackFrameIndex = xPathContext.getVarStack().getCurrentStackFrameIndex();
        this.m_prefixResolver = xPathContext.getNamespaceContext();
        this.m_dhelper = xPathContext.getDOMHelper();
    }

    protected void setNextPosition(int n) {
        this.m_next = n;
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    void incrementNextPosition() {
        ++this.m_next;
    }

    public void setShouldCacheNodes(boolean bl) {
        if (bl) {
            this.m_cachedNodes = new NodeSet();
            return;
        }
        this.m_cachedNodes = null;
    }

    public void setCurrentPos(int n) {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.setNextPosition(n);
        this.m_cachedNodes.setCurrentPos(n);
    }

    public int size() {
        if (this.m_cachedNodes == null) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }

    public Node item(int n) {
        this.resetToCachedList();
        return this.m_cachedNodes.item(n);
    }

    public int getLength() {
        this.resetToCachedList();
        return this.m_cachedNodes.getLength();
    }

    private void resetToCachedList() {
        int n = this.getCurrentPos();
        if (this.m_cachedNodes == null || n != 0) {
            this.setShouldCacheNodes(true);
        }
        this.runTo(-1);
        this.setCurrentPos(n);
    }

    public boolean isFresh() {
        return this.getCurrentPos() == 0;
    }

    public Node previousNode() throws DOMException {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public int getWhatToShow() {
        return -17;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public Node getRoot() {
        return this.m_context;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public void detach() {
        this.m_context = null;
        this.m_execContext = null;
        this.m_stackFrameIndex = 0;
        this.m_prefixResolver = null;
        this.m_dhelper = null;
        this.m_pool.freeInstance(this);
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        LocPathIterator locPathIterator = (LocPathIterator)this.clone();
        locPathIterator.reset();
        return locPathIterator;
    }

    public Object clone() throws CloneNotSupportedException {
        LocPathIterator locPathIterator = (LocPathIterator)super.clone();
        AxesWalker axesWalker = this.m_firstWalker;
        AxesWalker axesWalker2 = null;
        while (axesWalker != null) {
            AxesWalker axesWalker3 = (AxesWalker)axesWalker.clone();
            axesWalker3.setLocPathIterator(locPathIterator);
            if (locPathIterator.m_lastUsedWalker == axesWalker) {
                locPathIterator.m_lastUsedWalker = axesWalker3;
            }
            if (axesWalker2 == null) {
                locPathIterator.m_firstWalker = axesWalker3;
                axesWalker2 = axesWalker3;
            } else {
                axesWalker2.setNextWalker(axesWalker3);
                axesWalker3.setPrevWalker(axesWalker2);
                axesWalker2 = axesWalker3;
            }
            axesWalker = axesWalker.getNextWalker();
        }
        return locPathIterator;
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_lastFetched = null;
        this.m_lastUsedWalker = this.m_firstWalker;
        this.m_firstWalker.setRoot(this.m_context);
        this.m_waiting.removeAllElements();
    }

    public Node nextNode() throws DOMException {
        if (this.m_cachedNodes != null && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            Node node = this.m_cachedNodes.nextNode();
            this.setCurrentPos(this.m_cachedNodes.getCurrentPos());
            return node;
        }
        if (this.m_firstWalker.getRoot() == null) {
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(this.m_context);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
        return this.returnNextNode(this.m_firstWalker.nextNode());
    }

    private Node returnNextNode(Node node) {
        if (node != null) {
            if (this.m_cachedNodes != null) {
                this.m_cachedNodes.addElement(node);
            }
            this.incrementNextPosition();
        }
        this.m_lastFetched = node;
        if (node == null) {
            this.m_foundLast = true;
        }
        return node;
    }

    public Node getCurrentNode() {
        return this.m_lastFetched;
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int var1_1) {
        if (this.m_foundLast || var1_1 >= 0 && var1_1 <= this.getCurrentPos()) {
            return;
        }
        if (var1_1 != -1) ** GOTO lbl9
        while ((var2_2 = this.nextNode()) != null) {
        }
        return;
lbl-1000:
        // 1 sources

        {
            if (this.getCurrentPos() < var1_1) continue;
            return;
lbl9:
            // 2 sources

            ** while ((var2_3 = this.nextNode()) != null)
        }
lbl10:
        // 1 sources

    }

    public AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public void setLastUsedWalker(AxesWalker axesWalker) {
        this.m_lastUsedWalker = axesWalker;
    }

    public AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    public void addToWaitList(AxesWalker axesWalker) {
        this.m_waiting.addElement(axesWalker);
    }

    public void removeFromWaitList(AxesWalker axesWalker) {
        this.m_waiting.removeElement(axesWalker);
    }

    public boolean getFoundLast() {
        return this.m_foundLast;
    }

    public XPathContext getXPathContext() {
        return this.m_execContext;
    }

    public DOMHelper getDOMHelper() {
        return this.m_dhelper;
    }

    public Node getContext() {
        return this.m_context;
    }

    public int getStackFrameIndex() {
        return this.m_stackFrameIndex;
    }

    public Node getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public void setCurrentContextNode(Node node) {
        this.m_currentContextNode = node;
    }

    public PrefixResolver getPrefixResolver() {
        return this.m_prefixResolver;
    }
}

