/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import org.apache.xpath.axes.AncestorOrSelfWalker;
import org.apache.xpath.axes.AncestorWalker;
import org.apache.xpath.axes.AttributeWalker;
import org.apache.xpath.axes.AttributeWalkerOneStep;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ChildWalker;
import org.apache.xpath.axes.ChildWalkerMultiStep;
import org.apache.xpath.axes.ChildWalkerOneStep;
import org.apache.xpath.axes.DescendantOrSelfWalker;
import org.apache.xpath.axes.DescendantWalker;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.FollowingSiblingWalker;
import org.apache.xpath.axes.FollowingWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.NamespaceWalker;
import org.apache.xpath.axes.ParentWalker;
import org.apache.xpath.axes.PrecedingSiblingWalker;
import org.apache.xpath.axes.PrecedingWalker;
import org.apache.xpath.axes.RootWalker;
import org.apache.xpath.axes.SelfWalker;
import org.apache.xpath.axes.SelfWalkerOneStep;
import org.apache.xpath.compiler.Compiler;
import org.xml.sax.SAXException;

public class WalkerFactory {
    static final int NO_OPTIMIZE = 1;
    static final int ONESTEP_SELF = 2;
    static final int ONESTEP_CHILDREN = 3;
    static final int ONESTEP_ATTR = 4;
    static final int ONESTEP_DESCENDANTS = 5;
    static final int MULTISTEP_CHILDREN = 6;
    static final int HAS_PREDICATE = 1;
    static final int HAS_NOPREDICATE = 2;
    static final int HAS_BOOLEANPREDICATE = 3;
    static final int MAYHAVE_INDEXPREDICATE = 4;

    static AxesWalker loadOneWalker(LocPathIterator locPathIterator, Compiler compiler, int n) throws SAXException {
        AxesWalker axesWalker = null;
        int n2 = compiler.getOpMap()[n];
        if (n2 != -1) {
            axesWalker = WalkerFactory.createDefaultWalker(compiler, n2, locPathIterator, 0);
            axesWalker.init(compiler, n, n2);
        }
        return axesWalker;
    }

    static AxesWalker loadWalkers(LocPathIterator locPathIterator, Compiler compiler, int n, int n2) throws SAXException {
        int n3;
        AxesWalker axesWalker = null;
        AxesWalker axesWalker2 = null;
        int[] nArray = compiler.getOpMap();
        int n4 = WalkerFactory.analyze(compiler, n, n2);
        while ((n3 = nArray[n]) != -1) {
            AxesWalker axesWalker3 = WalkerFactory.createDefaultWalker(compiler, n, locPathIterator, n4);
            axesWalker3.init(compiler, n, n3);
            axesWalker3.setAnalysis(n4);
            if (axesWalker == null) {
                axesWalker = axesWalker3;
            } else {
                axesWalker2.setNextWalker(axesWalker3);
                axesWalker3.setPrevWalker(axesWalker2);
            }
            axesWalker2 = axesWalker3;
            n = compiler.getNextStepPos(n);
            if (n < 0) break;
        }
        return axesWalker;
    }

    private static int analyze(Compiler compiler, int n, int n2) throws SAXException {
        int n3;
        int[] nArray = compiler.getOpMap();
        int n4 = 0;
        int n5 = 1;
        while ((n3 = nArray[n]) != -1) {
            ++n4;
            compiler.getWhatToShow(n);
            compiler.getStepNS(n);
            String string = compiler.getStepLocalName(n);
            if (string != null) {
                string.equals("*");
            }
            WalkerFactory.analyzePredicate(compiler, n, n3);
            switch (n3) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    return 1;
                }
                case 50: {
                    return 1;
                }
                case 37: {
                    return 1;
                }
                case 38: {
                    return 1;
                }
                case 39: {
                    if (n4 == 1) {
                        n5 = 4;
                        break;
                    }
                    return 1;
                }
                case 49: {
                    return 1;
                }
                case 40: {
                    if (n4 == 1) {
                        n5 = 3;
                        break;
                    }
                    if (n5 == 3 || n5 == 6) {
                        n5 = 6;
                        break;
                    }
                    return 1;
                }
                case 41: {
                    return 1;
                }
                case 42: {
                    return 1;
                }
                case 43: {
                    return 1;
                }
                case 44: {
                    return 1;
                }
                case 46: {
                    return 1;
                }
                case 47: {
                    return 1;
                }
                case 45: {
                    return 1;
                }
                case 48: {
                    if (n4 == 1) {
                        n5 = 2;
                        break;
                    }
                    return 1;
                }
                case 51: {
                    return 1;
                }
                case 52: {
                    return 1;
                }
                case 53: {
                    return 1;
                }
                default: {
                    throw new RuntimeException("Programmer's assertion: unknown opcode: " + n3);
                }
            }
            n = compiler.getNextStepPos(n);
            if (n < 0) break;
        }
        return n5;
    }

    static int analyzePredicate(Compiler compiler, int n, int n2) throws SAXException {
        switch (n2) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int n3 = compiler.getArgLength(n);
                break;
            }
            default: {
                int n4 = compiler.getArgLengthOfStep(n);
            }
        }
        int n5 = compiler.getFirstPredicateOpPos(n);
        int n6 = compiler.countPredicates(n5);
        if (n6 > 0) {
            return 1;
        }
        return 2;
    }

    private static AxesWalker createDefaultWalker(Compiler compiler, int n, LocPathIterator locPathIterator, int n2) {
        AxesWalker axesWalker;
        int n3 = compiler.getWhatToShow(n);
        int n4 = compiler.getOp(n);
        boolean bl = false;
        boolean bl2 = false;
        block0 : switch (n4) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                axesWalker = new FilterExprWalker(locPathIterator);
                bl2 = true;
                break;
            }
            case 50: {
                axesWalker = new RootWalker(locPathIterator);
                bl2 = true;
                break;
            }
            case 37: {
                axesWalker = new AncestorWalker(locPathIterator);
                break;
            }
            case 38: {
                axesWalker = new AncestorOrSelfWalker(locPathIterator);
                break;
            }
            case 39: {
                switch (n2) {
                    case 4: {
                        axesWalker = new AttributeWalkerOneStep(locPathIterator);
                        break block0;
                    }
                }
                axesWalker = new AttributeWalker(locPathIterator);
                break;
            }
            case 49: {
                axesWalker = new NamespaceWalker(locPathIterator);
                break;
            }
            case 40: {
                switch (n2) {
                    case 3: {
                        if (bl) {
                            System.out.println("analysis -- onestep child: " + n2 + ", " + compiler.toString());
                        }
                        axesWalker = new ChildWalkerOneStep(locPathIterator);
                        break block0;
                    }
                    case 6: {
                        if (bl) {
                            System.out.println("analysis -- multi-step child: " + n2 + ", " + compiler.toString());
                        }
                        axesWalker = new ChildWalkerMultiStep(locPathIterator);
                        break block0;
                    }
                }
                axesWalker = new ChildWalker(locPathIterator);
                break;
            }
            case 41: {
                axesWalker = new DescendantWalker(locPathIterator);
                break;
            }
            case 42: {
                axesWalker = new DescendantOrSelfWalker(locPathIterator);
                break;
            }
            case 43: {
                axesWalker = new FollowingWalker(locPathIterator);
                break;
            }
            case 44: {
                axesWalker = new FollowingSiblingWalker(locPathIterator);
                break;
            }
            case 46: {
                axesWalker = new PrecedingWalker(locPathIterator);
                break;
            }
            case 47: {
                axesWalker = new PrecedingSiblingWalker(locPathIterator);
                break;
            }
            case 45: {
                axesWalker = new ParentWalker(locPathIterator);
                break;
            }
            case 48: {
                switch (n2) {
                    case 2: {
                        axesWalker = new SelfWalkerOneStep(locPathIterator);
                        break block0;
                    }
                }
                axesWalker = new SelfWalker(locPathIterator);
                break;
            }
            case 51: {
                axesWalker = new AttributeWalker(locPathIterator);
                break;
            }
            case 52: {
                axesWalker = new ChildWalker(locPathIterator);
                break;
            }
            case 53: {
                axesWalker = new ChildWalker(locPathIterator);
                break;
            }
            default: {
                throw new RuntimeException("Programmer's assertion: unknown opcode: " + n4);
            }
        }
        if ((n3 & 0x43) == 0 || n3 == -1) {
            axesWalker.initNodeTest(n3);
        } else {
            axesWalker.initNodeTest(n3, compiler.getStepNS(n), compiler.getStepLocalName(n));
        }
        return axesWalker;
    }
}

