/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import org.apache.trax.ProcessorException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.utils.PrefixResolver;
import org.apache.xalan.utils.QName;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.UnionPathIterator;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.functions.FuncExtFunction;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XString;
import org.apache.xpath.operations.And;
import org.apache.xpath.operations.Bool;
import org.apache.xpath.operations.Div;
import org.apache.xpath.operations.Equals;
import org.apache.xpath.operations.Gt;
import org.apache.xpath.operations.Gte;
import org.apache.xpath.operations.Lt;
import org.apache.xpath.operations.Lte;
import org.apache.xpath.operations.Minus;
import org.apache.xpath.operations.Mod;
import org.apache.xpath.operations.Mult;
import org.apache.xpath.operations.Neg;
import org.apache.xpath.operations.NotEquals;
import org.apache.xpath.operations.Number;
import org.apache.xpath.operations.Operation;
import org.apache.xpath.operations.Or;
import org.apache.xpath.operations.Plus;
import org.apache.xpath.operations.Quo;
import org.apache.xpath.operations.String;
import org.apache.xpath.operations.UnaryOperation;
import org.apache.xpath.operations.Variable;
import org.apache.xpath.patterns.AncestorStepPattern;
import org.apache.xpath.patterns.FunctionPattern;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Compiler
extends OpMap {
    private PrefixResolver m_currentPrefixResolver;
    ErrorHandler m_errorHandler;
    Locator m_locator;

    public Compiler(ErrorHandler errorHandler, Locator locator) {
        this.m_errorHandler = errorHandler;
        this.m_locator = locator;
    }

    public Compiler() {
        this.m_errorHandler = null;
        this.m_locator = null;
    }

    public Expression compile(int n) throws SAXException {
        int n2 = this.m_opMap[n];
        switch (n2) {
            case 1: {
                return this.compile(n + 2);
            }
            case 2: {
                return this.or(n);
            }
            case 3: {
                return this.and(n);
            }
            case 4: {
                return this.notequals(n);
            }
            case 5: {
                return this.equals(n);
            }
            case 6: {
                return this.lte(n);
            }
            case 7: {
                return this.lt(n);
            }
            case 8: {
                return this.gte(n);
            }
            case 9: {
                return this.gt(n);
            }
            case 10: {
                return this.plus(n);
            }
            case 11: {
                return this.minus(n);
            }
            case 12: {
                return this.mult(n);
            }
            case 13: {
                return this.div(n);
            }
            case 14: {
                return this.mod(n);
            }
            case 15: {
                return this.quo(n);
            }
            case 16: {
                return this.neg(n);
            }
            case 17: {
                return this.string(n);
            }
            case 18: {
                return this.bool(n);
            }
            case 19: {
                return this.number(n);
            }
            case 20: {
                return this.union(n);
            }
            case 21: {
                return this.literal(n);
            }
            case 22: {
                return this.variable(n);
            }
            case 23: {
                return this.group(n);
            }
            case 27: {
                return this.numberlit(n);
            }
            case 26: {
                return this.arg(n);
            }
            case 24: {
                return this.compileExtension(n);
            }
            case 25: {
                return this.compileFunction(n);
            }
            case 28: {
                return this.locationPath(n);
            }
            case 29: {
                return null;
            }
            case 30: {
                return this.matchPattern(n + 2);
            }
            case 31: {
                return this.locationPathPattern(n);
            }
        }
        this.error(24, new Object[]{Integer.toString(this.m_opMap[n])});
        return null;
    }

    private Expression compileOperation(Operation operation, int n) throws SAXException {
        int n2 = OpMap.getFirstChildPos(n);
        int n3 = this.getNextOpPos(n2);
        operation.setLeftRight(this.compile(n2), this.compile(n3));
        return operation;
    }

    private Expression compileUnary(UnaryOperation unaryOperation, int n) throws SAXException {
        int n2 = OpMap.getFirstChildPos(n);
        unaryOperation.setRight(this.compile(n2));
        return unaryOperation;
    }

    protected Expression or(int n) throws SAXException {
        return this.compileOperation(new Or(), n);
    }

    protected Expression and(int n) throws SAXException {
        return this.compileOperation(new And(), n);
    }

    protected Expression notequals(int n) throws SAXException {
        return this.compileOperation(new NotEquals(), n);
    }

    protected Expression equals(int n) throws SAXException {
        return this.compileOperation(new Equals(), n);
    }

    protected Expression lte(int n) throws SAXException {
        return this.compileOperation(new Lte(), n);
    }

    protected Expression lt(int n) throws SAXException {
        return this.compileOperation(new Lt(), n);
    }

    protected Expression gte(int n) throws SAXException {
        return this.compileOperation(new Gte(), n);
    }

    protected Expression gt(int n) throws SAXException {
        return this.compileOperation(new Gt(), n);
    }

    protected Expression plus(int n) throws SAXException {
        return this.compileOperation(new Plus(), n);
    }

    protected Expression minus(int n) throws SAXException {
        return this.compileOperation(new Minus(), n);
    }

    protected Expression mult(int n) throws SAXException {
        return this.compileOperation(new Mult(), n);
    }

    protected Expression div(int n) throws SAXException {
        return this.compileOperation(new Div(), n);
    }

    protected Expression mod(int n) throws SAXException {
        return this.compileOperation(new Mod(), n);
    }

    protected Expression quo(int n) throws SAXException {
        return this.compileOperation(new Quo(), n);
    }

    protected Expression neg(int n) throws SAXException {
        return this.compileUnary(new Neg(), n);
    }

    protected Expression string(int n) throws SAXException {
        return this.compileUnary(new String(), n);
    }

    protected Expression bool(int n) throws SAXException {
        return this.compileUnary(new Bool(), n);
    }

    protected Expression number(int n) throws SAXException {
        return this.compileUnary(new Number(), n);
    }

    protected Expression literal(int n) {
        n = OpMap.getFirstChildPos(n);
        return (XString)this.m_tokenQueue[this.m_opMap[n]];
    }

    protected Expression numberlit(int n) {
        n = OpMap.getFirstChildPos(n);
        return (XNumber)this.m_tokenQueue[this.m_opMap[n]];
    }

    protected Expression variable(int n) throws SAXException {
        Variable variable = new Variable();
        n = OpMap.getFirstChildPos(n);
        java.lang.String string = (java.lang.String)this.m_tokenQueue[this.m_opMap[n]];
        QName qName = new QName(string, this.getNamespaceContext());
        variable.setQName(qName);
        return variable;
    }

    protected Expression group(int n) throws SAXException {
        return this.compile(n + 2);
    }

    protected Expression arg(int n) throws SAXException {
        return this.compile(n + 2);
    }

    protected Expression union(int n) throws SAXException {
        return new UnionPathIterator(this, n);
    }

    public Expression locationPath(int n) throws SAXException {
        return new LocPathIterator(this, n);
    }

    public Expression predicate(int n) throws SAXException {
        return this.compile(n + 2);
    }

    protected Expression matchPattern(int n) throws SAXException {
        int n2 = n;
        int n3 = 0;
        while (this.m_opMap[n2] == 31) {
            n2 = this.getNextOpPos(n2);
            ++n3;
        }
        if (n3 == 1) {
            return this.compile(n);
        }
        UnionPattern unionPattern = new UnionPattern();
        StepPattern[] stepPatternArray = new StepPattern[n3];
        n3 = 0;
        while (this.m_opMap[n] == 31) {
            n2 = this.getNextOpPos(n);
            stepPatternArray[n3] = (StepPattern)this.compile(n);
            n = n2;
            ++n3;
        }
        unionPattern.setPatterns(stepPatternArray);
        return unionPattern;
    }

    public Expression locationPathPattern(int n) throws SAXException {
        n = OpMap.getFirstChildPos(n);
        return this.stepPattern(n, 0, null);
    }

    public int getWhatToShow(int n) {
        int n2 = this.getOp(n);
        int n3 = this.getOp(n + 3);
        switch (n3) {
            case 1030: {
                return 128;
            }
            case 1031: {
                return 132;
            }
            case 1032: {
                return 64;
            }
            case 1033: {
                return -1;
            }
            case 35: {
                return 256;
            }
            case 1034: {
                return 65536;
            }
            case 34: {
                switch (n2) {
                    case 49: {
                        return 4098;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 52: 
                    case 53: {
                        return 1;
                    }
                }
                return 1;
            }
        }
        return -1;
    }

    protected StepPattern stepPattern(int n, int n2, StepPattern stepPattern) throws SAXException {
        StepPattern stepPattern2;
        int n3;
        int n4 = n;
        int n5 = this.getOpMap()[n];
        if (n5 == -1) {
            return null;
        }
        int n6 = this.getNextOpPos(n);
        switch (n5) {
            case 25: {
                n3 = this.m_opMap[n + 1];
                stepPattern2 = new FunctionPattern(this.compileFunction(n));
                break;
            }
            case 50: {
                n3 = this.getArgLengthOfStep(n);
                n = OpMap.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(256);
                break;
            }
            case 51: {
                n3 = this.getArgLengthOfStep(n);
                n = OpMap.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(2, this.getStepNS(n4), this.getStepLocalName(n4));
                break;
            }
            case 52: {
                n3 = this.getArgLengthOfStep(n);
                n = OpMap.getFirstChildPosOfStep(n);
                stepPattern2 = new AncestorStepPattern(this.getWhatToShow(n4), this.getStepNS(n4), this.getStepLocalName(n4));
                break;
            }
            case 53: {
                n3 = this.getArgLengthOfStep(n);
                n = OpMap.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(this.getWhatToShow(n4), this.getStepNS(n4), this.getStepLocalName(n4));
                break;
            }
            default: {
                this.error(16, null);
                return null;
            }
        }
        stepPattern2.setPredicates(this.getCompiledPredicates(n + n3));
        stepPattern2.setRelativePathPattern(stepPattern);
        StepPattern stepPattern3 = this.stepPattern(n6, n2 + 1, stepPattern2);
        if (stepPattern3 != null) {
            return stepPattern3;
        }
        return stepPattern2;
    }

    public Expression[] getCompiledPredicates(int n) throws SAXException {
        int n2 = this.countPredicates(n);
        if (n2 > 0) {
            Expression[] expressionArray = new Expression[n2];
            this.compilePredicates(n, expressionArray);
            return expressionArray;
        }
        return null;
    }

    public int countPredicates(int n) throws SAXException {
        int n2 = 0;
        while (this.getOp(n) == 29) {
            ++n2;
            n = this.getNextOpPos(n);
        }
        return n2;
    }

    private void compilePredicates(int n, Expression[] expressionArray) throws SAXException {
        int n2 = 0;
        while (this.getOp(n) == 29) {
            expressionArray[n2] = this.predicate(n);
            n = this.getNextOpPos(n);
            ++n2;
        }
    }

    Expression compileFunction(int n) throws SAXException {
        int n2 = n + this.m_opMap[n + 1] - 1;
        n = OpMap.getFirstChildPos(n);
        int n3 = this.m_opMap[n];
        ++n;
        if (n3 != -1) {
            Function function = FunctionTable.getFunction(n3);
            try {
                int n4 = 0;
                int n5 = n;
                while (n5 < n2) {
                    function.setArg(this.compile(n5), n4);
                    n5 = this.getNextOpPos(n5);
                    ++n4;
                }
                function.checkNumberArgs(n4);
            }
            catch (WrongNumberArgsException wrongNumberArgsException) {
                java.lang.String string = FunctionTable.m_functions[n3].getName();
                throw new SAXException(java.lang.String.valueOf(string) + " only allows " + wrongNumberArgsException.m_argsExpected + " arguments");
            }
            return function;
        }
        this.warn(7, null);
        return null;
    }

    private Expression compileExtension(int n) throws SAXException {
        int n2 = n + this.m_opMap[n + 1] - 1;
        n = OpMap.getFirstChildPos(n);
        java.lang.String string = (java.lang.String)this.m_tokenQueue[this.m_opMap[n]];
        java.lang.String string2 = (java.lang.String)this.m_tokenQueue[this.m_opMap[++n]];
        FuncExtFunction funcExtFunction = new FuncExtFunction(string, string2, java.lang.String.valueOf(java.lang.String.valueOf(++n)) + java.lang.String.valueOf(this.hashCode()));
        try {
            int n3 = 0;
            while (n < n2) {
                int n4 = this.getNextOpPos(n);
                ((Function)funcExtFunction).setArg(this.compile(n), n3);
                n = n4;
                ++n3;
            }
        }
        catch (WrongNumberArgsException wrongNumberArgsException) {}
        return funcExtFunction;
    }

    public void warn(int n, Object[] objectArray) throws SAXException {
        java.lang.String string = XSLMessages.createXPATHWarning(n, objectArray);
        if (this.m_errorHandler != null) {
            this.m_errorHandler.warning(new ProcessorException(string));
        }
    }

    public void assert(boolean bl, java.lang.String string) throws SAXException {
        if (!bl) {
            java.lang.String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    public void error(int n, Object[] objectArray) throws SAXException {
        java.lang.String string = XSLMessages.createXPATHMessage(n, objectArray);
        ProcessorException processorException = new ProcessorException(string, this.m_locator);
        if (this.m_errorHandler != null) {
            this.m_errorHandler.fatalError(processorException);
            return;
        }
        throw processorException;
    }

    public PrefixResolver getNamespaceContext() {
        return this.m_currentPrefixResolver;
    }

    public void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_currentPrefixResolver = prefixResolver;
    }
}

