/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import org.apache.xpath.objects.XBooleanStatic;
import org.apache.xpath.objects.XObject;
import org.xml.sax.SAXException;

public class XBoolean
extends XObject {
    public static XBoolean S_TRUE = new XBooleanStatic(true);
    public static XBoolean S_FALSE = new XBooleanStatic(false);
    boolean m_val;

    public XBoolean(boolean bl) {
        this.m_val = bl;
    }

    public int getType() {
        return 1;
    }

    protected String getTypeString() {
        return "#BOOLEAN";
    }

    public double num() {
        if (this.m_val) {
            return 1.0;
        }
        return 0.0;
    }

    public boolean bool() {
        return this.m_val;
    }

    public String str() {
        if (this.m_val) {
            return "true";
        }
        return "false";
    }

    public Object object() {
        return new Boolean(this.m_val);
    }

    public boolean equals(XObject xObject) throws SAXException {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        return this.m_val == xObject.bool();
    }
}

