/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import org.apache.xalan.utils.StringVector;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.objects.Comparator;
import org.apache.xpath.objects.EqualComparator;
import org.apache.xpath.objects.GreaterThanComparator;
import org.apache.xpath.objects.GreaterThanOrEqualComparator;
import org.apache.xpath.objects.LessThanComparator;
import org.apache.xpath.objects.LessThanOrEqualComparator;
import org.apache.xpath.objects.NotEqualComparator;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class XNodeSet
extends XObject {
    static LessThanComparator S_LT = new LessThanComparator();
    static LessThanOrEqualComparator S_LTE = new LessThanOrEqualComparator();
    static GreaterThanComparator S_GT = new GreaterThanComparator();
    static GreaterThanOrEqualComparator S_GTE = new GreaterThanOrEqualComparator();
    static EqualComparator S_EQ = new EqualComparator();
    static NotEqualComparator S_NEQ = new NotEqualComparator();

    public XNodeSet(NodeIterator nodeIterator) {
        super(nodeIterator);
    }

    public XNodeSet() {
        super(new NodeSet());
    }

    public XNodeSet(Node node) {
        super(new NodeSet());
        if (node != null) {
            ((NodeSet)this.m_obj).addNode(node);
        }
    }

    public int getType() {
        return 4;
    }

    protected String getTypeString() {
        return "#NODESET";
    }

    public static double getNumberFromNode(Node node) {
        return XString.castToNum(XNodeSet.getStringFromNode(node));
    }

    public double num() {
        NodeIterator nodeIterator = this.nodeset();
        Node node = nodeIterator.nextNode();
        if (node != null) {
            return XNodeSet.getNumberFromNode(node);
        }
        return Double.NaN;
    }

    public boolean bool() {
        return this.nodeset().nextNode() != null;
    }

    public static String getStringFromNode(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: {
                return DOMHelper.getNodeData(node);
            }
            case 3: 
            case 4: {
                return ((Text)node).getData();
            }
            case 2: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        return DOMHelper.getNodeData(node);
    }

    public String str() {
        NodeIterator nodeIterator = this.nodeset();
        Node node = nodeIterator.nextNode();
        if (node != null) {
            return XNodeSet.getStringFromNode(node);
        }
        return "";
    }

    public DocumentFragment rtree(XPathContext xPathContext) {
        Node node;
        DocumentFragment documentFragment = xPathContext.getDOMHelper().getDOMFactory().createDocumentFragment();
        NodeIterator nodeIterator = this.nodeset();
        while ((node = nodeIterator.nextNode()) != null) {
            documentFragment.appendChild(node.cloneNode(true));
        }
        return documentFragment;
    }

    public NodeIterator nodeset() {
        NodeIterator nodeIterator = (NodeIterator)this.m_obj;
        if (nodeIterator instanceof ContextNodeList) {
            if (((ContextNodeList)((Object)nodeIterator)).isFresh()) {
                return nodeIterator;
            }
            try {
                return ((ContextNodeList)((Object)nodeIterator)).cloneWithReset();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException.getMessage());
            }
        }
        return nodeIterator;
    }

    public NodeSet mutableNodeset() {
        NodeSet nodeSet;
        if (this.m_obj instanceof NodeSet) {
            nodeSet = (NodeSet)this.m_obj;
        } else {
            nodeSet = new NodeSet(this.nodeset());
            this.m_obj = nodeSet;
        }
        return nodeSet;
    }

    public boolean compare(XObject xObject, Comparator comparator) throws SAXException {
        boolean bl = false;
        int n = xObject.getType();
        if (n == 4) {
            Node node;
            NodeIterator nodeIterator = this.nodeset();
            NodeIterator nodeIterator2 = ((XNodeSet)xObject).nodeset();
            StringVector stringVector = null;
            block0: while ((node = nodeIterator.nextNode()) != null) {
                String string = XNodeSet.getStringFromNode(node);
                if (stringVector == null) {
                    Node node2;
                    while ((node2 = nodeIterator2.nextNode()) != null) {
                        String string2 = XNodeSet.getStringFromNode(node2);
                        if (comparator.compareStrings(string, string2)) {
                            bl = true;
                            continue block0;
                        }
                        if (stringVector == null) {
                            stringVector = new StringVector();
                        }
                        stringVector.addElement(string2);
                    }
                    continue;
                }
                int n2 = stringVector.size();
                int n3 = 0;
                while (n3 < n2) {
                    if (comparator.compareStrings(string, stringVector.elementAt(n3))) {
                        bl = true;
                        continue block0;
                    }
                    ++n3;
                }
            }
        } else if (n == 1) {
            double d = this.bool() ? 1.0 : 0.0;
            double d2 = xObject.num();
            bl = comparator.compareNumbers(d, d2);
        } else if (n == 2) {
            Node node;
            NodeIterator nodeIterator = this.nodeset();
            double d = xObject.num();
            while ((node = nodeIterator.nextNode()) != null) {
                double d3 = XNodeSet.getNumberFromNode(node);
                if (!comparator.compareNumbers(d3, d)) continue;
                bl = true;
                break;
            }
        } else if (n == 5) {
            double d = xObject.num();
            if (!Double.isNaN(d)) {
                Node node;
                NodeIterator nodeIterator = this.nodeset();
                while ((node = nodeIterator.nextNode()) != null) {
                    double d4 = XNodeSet.getNumberFromNode(node);
                    if (!comparator.compareNumbers(d4, d)) continue;
                    bl = true;
                    break;
                }
            } else {
                Node node;
                String string = xObject.str();
                NodeIterator nodeIterator = this.nodeset();
                while ((node = nodeIterator.nextNode()) != null) {
                    String string3 = XNodeSet.getStringFromNode(node);
                    if (!comparator.compareStrings(string3, string)) continue;
                    bl = true;
                    break;
                }
            }
        } else if (n == 3) {
            Node node;
            String string = xObject.str();
            NodeIterator nodeIterator = this.nodeset();
            while ((node = nodeIterator.nextNode()) != null) {
                String string4 = XNodeSet.getStringFromNode(node);
                if (!comparator.compareStrings(string4, string)) continue;
                bl = true;
                break;
            }
        } else {
            bl = comparator.compareNumbers(this.num(), xObject.num());
        }
        return bl;
    }

    public boolean lessThan(XObject xObject) throws SAXException {
        return this.compare(xObject, S_LT);
    }

    public boolean lessThanOrEqual(XObject xObject) throws SAXException {
        return this.compare(xObject, S_LTE);
    }

    public boolean greaterThan(XObject xObject) throws SAXException {
        return this.compare(xObject, S_GT);
    }

    public boolean greaterThanOrEqual(XObject xObject) throws SAXException {
        return this.compare(xObject, S_GTE);
    }

    public boolean equals(XObject xObject) throws SAXException {
        return this.compare(xObject, S_EQ);
    }

    public boolean notEquals(XObject xObject) throws SAXException {
        return this.compare(xObject, S_NEQ);
    }
}

