/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XString
extends XObject {
    public static XString EMPTYSTRING = new XString("");

    public XString(String string) {
        super(string);
    }

    public int getType() {
        return 3;
    }

    protected String getTypeString() {
        return "#STRING";
    }

    public static double castToNum(String string) {
        double d;
        if (string == null) {
            d = 0.0;
        } else {
            try {
                d = Double.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                d = Double.NaN;
            }
        }
        return d;
    }

    public double num() {
        return XString.castToNum((String)this.m_obj);
    }

    public boolean bool() {
        return this.str().length() > 0;
    }

    public String str() {
        if (this.m_obj != null) {
            return (String)this.m_obj;
        }
        return "";
    }

    public DocumentFragment rtree(XPathContext xPathContext) {
        DocumentFragment documentFragment = xPathContext.getDOMHelper().getDOMFactory().createDocumentFragment();
        Text text = xPathContext.getDOMHelper().getDOMFactory().createTextNode(this.str());
        documentFragment.appendChild(text);
        return documentFragment;
    }

    public boolean equals(XObject xObject) throws SAXException {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        return this.str().equals(xObject.str());
    }
}

