/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NodeTest
extends Expression {
    public static final String WILD = "*";
    protected int m_whatToShow;
    public static final int SHOW_NAMESPACE = 4096;
    public static final int SHOW_BYFUNCTION = 65536;
    String m_namespace;
    String m_name;
    XNumber m_score;
    static final XNumber SCORE_NODETEST = new XNumber(-0.5);
    static final XNumber SCORE_NSWILD = new XNumber(-0.25);
    static final XNumber SCORE_QNAME = new XNumber(0.0);
    static final XNumber SCORE_OTHER = new XNumber(0.5);
    public static final XNumber SCORE_NONE = new XNumber(Double.NEGATIVE_INFINITY);
    private boolean m_isTotallyWild;

    public int getWhatToShow() {
        return this.m_whatToShow;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getLocalName() {
        return this.m_name;
    }

    public NodeTest(int n, String string, String string2) {
        this.initNodeTest(n, string, string2);
    }

    public NodeTest(int n) {
        this.initNodeTest(n);
    }

    public NodeTest() {
    }

    public void initNodeTest(int n) {
        this.m_whatToShow = n;
        this.calcScore();
    }

    public void initNodeTest(int n, String string, String string2) {
        this.m_whatToShow = n;
        this.m_namespace = string;
        this.m_name = string2;
        this.calcScore();
    }

    protected void calcScore() {
        this.m_score = this.m_namespace == null && this.m_name == null ? SCORE_NODETEST : ((this.m_namespace == WILD || this.m_namespace == null) && this.m_name == WILD ? SCORE_NODETEST : (this.m_namespace != WILD && this.m_name == WILD ? SCORE_NSWILD : SCORE_QNAME));
        this.m_isTotallyWild = this.m_namespace == null && this.m_name == WILD;
    }

    public double getDefaultScore() {
        return this.m_score.num();
    }

    public static void debugWhatToShow(int n) {
        Vector<String> vector = new Vector<String>();
        if ((n & 2) != 0) {
            vector.addElement("SHOW_ATTRIBUTE");
        }
        if ((n & 8) != 0) {
            vector.addElement("SHOW_CDATA_SECTION");
        }
        if ((n & 0x80) != 0) {
            vector.addElement("SHOW_COMMENT");
        }
        if ((n & 0x100) != 0) {
            vector.addElement("SHOW_DOCUMENT");
        }
        if ((n & 0x400) != 0) {
            vector.addElement("SHOW_DOCUMENT_FRAGMENT");
        }
        if ((n & 0x200) != 0) {
            vector.addElement("SHOW_DOCUMENT_TYPE");
        }
        if ((n & 1) != 0) {
            vector.addElement("SHOW_ELEMENT");
        }
        if ((n & 0x20) != 0) {
            vector.addElement("SHOW_ENTITY");
        }
        if ((n & 0x10) != 0) {
            vector.addElement("SHOW_ENTITY_REFERENCE");
        }
        if ((n & 0x800) != 0) {
            vector.addElement("SHOW_NOTATION");
        }
        if ((n & 0x40) != 0) {
            vector.addElement("SHOW_PROCESSING_INSTRUCTION");
        }
        if ((n & 4) != 0) {
            vector.addElement("SHOW_TEXT");
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            if (n3 > 0) {
                System.out.print(" | ");
            }
            System.out.print(vector.elementAt(n3));
            ++n3;
        }
        if (n2 == 0) {
            System.out.print("empty whatToShow: " + n);
        }
        System.out.println();
    }

    private static final boolean subPartMatch(String string, String string2) {
        return string == string2 || string != null && (string2 == WILD || string.equals(string2));
    }

    public XObject execute(XPathContext xPathContext) throws SAXException {
        int n = this.getWhatToShow();
        if (n == -1) {
            return this.m_score;
        }
        Node node = xPathContext.getCurrentNode();
        short s = node.getNodeType();
        int n2 = n & 1 << s - 1;
        switch (n2) {
            case 256: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                if (!xPathContext.getDOMHelper().shouldStripSourceNode(node)) {
                    return this.m_score;
                }
                return SCORE_NONE;
            }
            case 64: {
                if (NodeTest.subPartMatch(node.getNodeName(), this.m_name)) {
                    return this.m_score;
                }
                return SCORE_NONE;
            }
            case 2: {
                int n3 = n & 0x1000;
                if (n3 == 0) {
                    DOMHelper dOMHelper = xPathContext.getDOMHelper();
                    if (!dOMHelper.isNamespaceNode(node)) {
                        if (this.m_isTotallyWild || NodeTest.subPartMatch(dOMHelper.getNamespaceOfNode(node), this.m_namespace) && NodeTest.subPartMatch(dOMHelper.getLocalNameOfNode(node), this.m_name)) {
                            return this.m_score;
                        }
                        return SCORE_NONE;
                    }
                    return SCORE_NONE;
                }
                if (xPathContext.getDOMHelper().isNamespaceNode(node)) {
                    String string = node.getNodeValue();
                    if (NodeTest.subPartMatch(string, this.m_name)) {
                        return this.m_score;
                    }
                    return SCORE_NONE;
                }
                return SCORE_NONE;
            }
            case 1: {
                DOMHelper dOMHelper = xPathContext.getDOMHelper();
                if (this.m_isTotallyWild || NodeTest.subPartMatch(dOMHelper.getNamespaceOfNode(node), this.m_namespace) && NodeTest.subPartMatch(dOMHelper.getLocalNameOfNode(node), this.m_name)) {
                    return this.m_score;
                }
                return SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }
}

