/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StepPattern
extends NodeTest
implements SubContextList {
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int n, String string, String string2) {
        super(n, string, string2);
    }

    public StepPattern(int n) {
        super(n);
    }

    public void calcTargetString() {
        int n = this.getWhatToShow();
        switch (n) {
            case 128: {
                this.m_targetString = "#comment";
                return;
            }
            case 4: {
                this.m_targetString = "#text";
                return;
            }
            case -1: {
                this.m_targetString = "*";
                return;
            }
            case 256: {
                this.m_targetString = "/";
                return;
            }
            case 1: {
                if (this.m_name == "*") {
                    this.m_targetString = "*";
                    return;
                }
                this.m_targetString = this.m_name;
                return;
            }
        }
        this.m_targetString = "*";
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void setRelativePathPattern(StepPattern stepPattern) {
        this.m_relativePathPattern = stepPattern;
        this.calcScore();
    }

    public Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    public final int getPredicateCount() {
        if (this.m_predicates == null) {
            return 0;
        }
        return this.m_predicates.length;
    }

    public void setPredicates(Expression[] expressionArray) {
        this.m_predicates = expressionArray;
        this.calcScore();
    }

    protected void calcScore() {
        if (this.getPredicateCount() > 0 || this.m_relativePathPattern != null) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (this.m_targetString == null) {
            this.calcTargetString();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject executeStep(XPathContext xPathContext) throws SAXException {
        void var2_9;
        void var2_6;
        short s = xPathContext.getCurrentNode().getNodeType();
        if (s == 2 && this.m_whatToShow != 2) {
            XNumber xNumber = NodeTest.SCORE_NONE;
        } else if (s == 9 && this.m_whatToShow != 256) {
            XNumber xNumber = NodeTest.SCORE_NONE;
        } else {
            XObject xObject = super.execute(xPathContext);
        }
        if (var2_6 == NodeTest.SCORE_NONE) {
            return var2_6;
        }
        int n = this.getPredicateCount();
        if (n == 0) {
            return var2_6;
        }
        try {
            xPathContext.pushSubContextList(this);
            int n2 = 0;
            while (n2 < n) {
                XObject xObject = this.m_predicates[n2].execute(xPathContext);
                if (xObject.getType() == 2) {
                    if (this.getProximityPosition(xPathContext) != (int)xObject.num()) {
                        XNumber xNumber = NodeTest.SCORE_NONE;
                        break;
                    }
                } else if (!xObject.bool()) {
                    XNumber xNumber = NodeTest.SCORE_NONE;
                    break;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            xPathContext.popSubContextList();
            throw throwable;
        }
        Object var6_13 = null;
        xPathContext.popSubContextList();
        return var2_9;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getProximityPosition(XPathContext xPathContext) {
        Node node = xPathContext.getCurrentNode();
        Node node2 = xPathContext.getDOMHelper().getParentOfNode(node);
        try {
            try {
                xPathContext.pushCurrentNode(node2);
                int n = 0;
                Node node3 = node2.getFirstChild();
                while (node3 != null) {
                    Object var10_7;
                    block7: {
                        int n2;
                        try {
                            xPathContext.pushCurrentNode(node3);
                            if (NodeTest.SCORE_NONE == super.execute(xPathContext)) break block7;
                            ++n;
                            if (!node3.equals(node)) break block7;
                            n2 = n;
                            var10_7 = null;
                            xPathContext.popCurrentNode();
                        }
                        catch (Throwable throwable) {
                            var10_7 = null;
                            xPathContext.popCurrentNode();
                            throw throwable;
                        }
                        Object var6_9 = null;
                        xPathContext.popCurrentNode();
                        return n2;
                    }
                    var10_7 = null;
                    xPathContext.popCurrentNode();
                    node3 = node3.getNextSibling();
                }
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            xPathContext.popCurrentNode();
            throw throwable;
        }
        Object var6_10 = null;
        xPathContext.popCurrentNode();
        return 0;
    }

    public int getLastPos(XPathContext xPathContext) {
        Node node = xPathContext.getCurrentNode();
        Node node2 = xPathContext.getDOMHelper().getParentOfNode(node);
        try {
            try {
                xPathContext.pushCurrentNode(node2);
                int n = 0;
                Node node3 = node2.getFirstChild();
                while (node3 != null) {
                    Object var10_7;
                    block7: {
                        try {
                            xPathContext.pushCurrentNode(node3);
                            if (NodeTest.SCORE_NONE == super.execute(xPathContext)) break block7;
                            ++n;
                        }
                        catch (Throwable throwable) {
                            var10_7 = null;
                            xPathContext.popCurrentNode();
                            throw throwable;
                        }
                    }
                    var10_7 = null;
                    xPathContext.popCurrentNode();
                    node3 = node3.getNextSibling();
                }
                int n2 = n;
                Object var6_10 = null;
                xPathContext.popCurrentNode();
                return n2;
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            xPathContext.popCurrentNode();
            throw throwable;
        }
    }

    public XObject executeRelativePathPattern(XPathContext xPathContext) throws SAXException {
        XObject xObject;
        block4: {
            block3: {
                block2: {
                    Node node = xPathContext.getDOMHelper().getParentOfNode(xPathContext.getCurrentNode());
                    if (node == null) break block3;
                    try {
                        xPathContext.pushCurrentNode(node);
                        xObject = this.execute(xPathContext);
                        if (xObject == NodeTest.SCORE_NONE) break block2;
                        xObject = NodeTest.SCORE_OTHER;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        xPathContext.popCurrentNode();
                        throw throwable;
                    }
                }
                Object var5_4 = null;
                xPathContext.popCurrentNode();
                break block4;
            }
            xObject = NodeTest.SCORE_NONE;
        }
        return xObject;
    }

    public XObject execute(XPathContext xPathContext) throws SAXException {
        XObject xObject = this.executeStep(xPathContext);
        if (xObject != NodeTest.SCORE_NONE && this.m_relativePathPattern != null) {
            xObject = this.m_relativePathPattern.executeRelativePathPattern(xPathContext);
        }
        return xObject;
    }

    public double getMatchScore(XPathContext xPathContext, Node node) throws SAXException {
        xPathContext.pushCurrentNode(node);
        xPathContext.pushCurrentExpressionNode(node);
        try {
            XObject xObject = this.execute(xPathContext);
            double d = xObject.num();
            Object var6_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }
}

