$	goto start
$!
$! INSTALL_XML-J-2_0.COM
$! Installation procedure for Xerces-J 2.0 (based on Apache Xerces-J 2.3.0)
$! and Xalan-J 2.0 (based on Apache Xalan-J 2.4.1).
$!
$!	Copyright  2003 Hewlett-Packard Company
$!
$!	Author:		Paul R. DeStefano	03-Mar-2003
$!
$start:	set noon
$	saved_verify = f$verify(f$trnlnm("install_xml-j$verify"))
$	saved_default = f$env("default")
$	on control_y then goto cleanup
$!      
$	DELETE    := DELETE
$	PURGE     := PURGE
$	OPEN      := OPEN
$	DIRECTORY := DIRECTORY
$	TYPE      := TYPE
$	CLOSE     := CLOSE
$	CALL      := CALL
$	COPY      := COPY
$	DEFINE    := DEFINE
$	DEASSIGN  := DEASSIGN
$	CREATE    := CREATE
$	PRINT     := PRINT
$	SET       := SET
$	SHOW      := SHOW
$	WRITE     := WRITE
$	READ      := READ
$!
$	WS	  := write sys$output
$!
$	SOURCE				= ""
$	SAVED_CASE_LOOKUP		= ""
$	SAVED_JAVA$FILENAME_CONTROLS = f$trnlnm("JAVA$FILENAME_CONTROLS")
$	SAVED_PARSE_STYLE   = f$getjpi("", "PARSE_STYLE_PERM")
$	SAVED_CASE_PRESERVE = f$trnlnm("DECC$EFS_CASE_PRESERVE")
$	SAVED_CASE_SPECIAL  = f$trnlnm("DECC$EFS_CASE_SPECIAL")
$	SAVED_EFS_CHARSET   = f$trnlnm("DECC$EFS_CHARSET")
$!
$	on control_y then goto cleanup
$!
$!      Check hardware architecture and set architecture symbol
$       s_arch_name = f$getsyi ( "arch_name" )
$
$       if s_arch_name .eqs. "Alpha"
$       then
$    	   OS = f$edit(f$getsyi("VERSION"),"COLLAPSE")
$          OS = F$EXTRACT (1,f$length(OS)-1,OS)
$	   if OS .lts. "7.2-2"
$	   then
$	      ws "*****************************************************************"
$	      ws "It appears that the installed OpenVMS version is less than V7.2-2"
$	      ws "Please upgrade before installing the SOAP Tools Kit"
$	      ws "*****************************************************************"
$	      goto cleanup
$	   endif
$       endif
$!
$       if s_arch_name .eqs. "IA64"
$       then
$	   OS = f$edit(f$getsyi("VERSION"),"COLLAPSE")
$          OS = F$EXTRACT (1,f$length(OS)-1,OS)
$	   if OS .lts. "8.1"
$	   then
$	      ws "*****************************************************************"
$	      ws "It appears that the installed OpenVMS version is less than V8.1"
$	      ws "Please upgrade before installing the SOAP Tools Kit"
$	      ws "*****************************************************************"
$	      goto cleanup
$	   endif
$       endif
$ 
$!
$	SET PROCESS/PARSE_STYE=EXTENDED
$	DEFINE/NOLOG DECC$EFS_CASE_PRESERVE ENABLE
$	DEFINE/NOLOG DECC$EFS_CASE_SPECIAL ENABLE
$	DEFINE/NOLOG DECC$EFS_CHARSET ENABLE
$!
$      if s_arch_name .eqs. "Alpha"
$      then
$	  if OS .ges. "7.3-1"	! On Alpha, "set proc/case" is not earlier versions than V7.3
$	  then
$	      SAVED_CASE_LOOKUP = f$getjpi("", "CASE_LOOKUP_PERM")
$	      SET PROCESS/CASE_LOOKUP=BLIND
$	  endif
$      endif
$! 
$!    "set proc/case" is contained in all OpenVMS I64 versions
$      if s_arch_name .eqs. "IA64"
$      then
$          SAVED_CASE_LOOKUP = f$getjpi("", "CASE_LOOKUP_PERM")
$	   SET PROCESS/CASE_LOOKUP=BLIND
$      endif
$!
$! These defines are an attempt to keep the C version as close as possible to
$! the Java version, and to make it easy to change version numbers.
$!
$	LANG		= "J"
$	LCLANG		= "j"
$	XML_BASE_NAME	= "XML-''LANG'"
$	XML_NAME	= "''XML_BASE_NAME' V2.0"
$	XML_VERS	= "''XML_BASE_NAME'-2_0"
$	XML_ROOT	= "XML-2_0"
$	XERCES_VERS	= "Xerces-''LANG'-2_0"
$	XALAN_VERS	= "Xalan-''LANG'-2_0"
$	XML_ROOT_LOG	= "''XML_BASE_NAME'$ROOT"
$	XERCES_ROOT_LOG = "XERCES-''LANG'$ROOT"
$	XALAN_ROOT_LOG  = "XALAN-''LANG'$ROOT"
$!
$	INSTALL_DOCS			= "FALSE,FALSE"
$	INSTALL_SRCS			= "FALSE,FALSE"
$!
$	ws ""
$	ws ""
$	ws "              ''XML_NAME' Installation Procedure"
$	type sys$input
             -----------------------------------

Before installing this kit, please make sure that the following prerequisites
have been met.  If they have not been met, the installation procedure may be
unable to complete and may terminate:

  For the Alpha Architecture:
	1) The installed operating system is OpenVMS Alpha V7.2-2 or later.
	2) Software Development Kit (SDK) for the Java Platform Version
	   1.3.1 (or higher) is installed, including any required OpenVMS
	   patches.

  For the IA64 Architecture:
	1) The installed operating system is OpenVMS I64 Evaluation Release 
           8.1 or later.
	2) Software Development Kit (SDK) for the Java Platform Version
	   1.4.2 (or higher) is installed, including any required OpenVMS
	   patches.

  For either Architecture:
	3) An ODS-5 enabled disk is available and mounted.

	***********************************************************
				 Note
		Questions, where indicated, accept a response of
		 "H" to request additional Help and information.
	***********************************************************

$!
$! Requirement is V7.2-2 or later for Alpha and V8.1 for I64.
$!
$       if s_arch_name .eqs. "Alpha"
$       then
$	    OS = f$edit(f$getsyi("VERSION"),"COLLAPSE")
$           OS = F$EXTRACT (1,f$length(OS)-1,OS)
$	    if OS .lts. "7.2-2"
$	    then
$	        ws "*****************************************************************"
$	        ws "It appears that the installed OpenVMS version is less than V7.2-2."
$	        ws "Please upgrade before installing ''XML_NAME'."
$	        ws "*****************************************************************"
$	        goto cleanup
$	    endif
$       endif
$!
$       if s_arch_name .eqs. "IA64"
$       then
$	    OS = f$edit(f$getsyi("VERSION"),"COLLAPSE")
$           OS = F$EXTRACT (1,f$length(OS)-1,OS)
$	    if OS .lts. "8.1"
$	    then
$	        ws "*****************************************************************"
$	        ws "It appears that the installed OpenVMS version is less than V8.1."
$	        ws "Please upgrade before installing ''XML_NAME'."
$	        ws "*****************************************************************"
$	        goto cleanup
$	    endif
$       endif
$!
$       if f$search("SYS$COMMON:[JAVA*.COM]JAVA$*_SETUP.COM") .eqs. ""
$	then
$           if s_arch_name .eqs. "Alpha"
$           then
$	        type/nopage sys$input

*******************************************************************
It appears that JAVA Version 1.3.1 or later has not been installed.

Please install JAVA Version 1.3.1 or later before invoking this
procedure.
*******************************************************************
$           endif
$!
$           if s_arch_name .eqs. "IA64"
$           then
$	        type/nopage sys$input

*******************************************************************
It appears that JAVA Version 1.4.2 or later has not been installed.

Please install JAVA Version 1.4.2 or later before invoking this
procedure.
*******************************************************************
$           endif
$	    goto cleanup
$	endif
$!
$	TEMP = ""
$	define/nolog sys$output nl:
$	define/nolog sys$error  nl:
$	TEMP = jar
$	deas sys$output
$	deas sys$error
$	if TEMP .eqs. ""
$	then
$!
$! Attempt to startup Java using the most recent version.
$!
$	    next_java = ""
$!
$java_loop:
$!
$	    latest_java = next_java
$	    next_java = f$search("sys$common:[java$*.com]java$*_setup.com","1")
$	    if next_java .nes. "" then goto java_loop
$	    if latest_java .nes. ""
$	    then
$		ws "Invoking ''latest_java'"
$		@'latest_java
$	    else
$               if s_arch_name .eqs. "Alpha"
$               then
$		    ws ""
$		    ws "Unable to locate the Java setup procedure."
$		    ws "Please insure that Java 1.3.1 or higher is installed and/or invoke the"
$		    ws "appropriate Java setup procedure for your installation prior to invoking"
$		    ws "the ''XML_NAME' installation procedure."
$               endif
$!
$               if s_arch_name .eqs. "IA64"
$               then
$		    ws ""
$		    ws "Unable to locate the Java setup procedure."
$		    ws "Please insure that Java 1.4.2 or higher is installed and/or invoke the"
$		    ws "appropriate Java setup procedure for your installation prior to invoking"
$		    ws "the ''XML_NAME' installation procedure."
$               endif
$	    endif
$       endif
$!
$	DEF_SOURCE = f$parse(f$env("PROCEDURE"),,,"DEVICE","SYNTAX_ONLY") +-
		     f$parse(f$env("PROCEDURE"),,,"DIRECTORY","SYNTAX_ONLY")
$	DEF_SOURCE = DEF_SOURCE - ".KIT]"
$	if f$extract(f$length(DEF_SOURCE)-1,1,DEF_SOURCE) .nes. "]"
$	then
$	    DEF_SOURCE = DEF_SOURCE + "]"
$	endif
$!
$GET_SOURCE_LOOP:
$!
$	if SOURCE .eqs. "" THEN SOURCE = DEF_SOURCE
$	INSTALL_FILE = SOURCE - "]" + ".KIT]xalan-j-bin-2_0.SAV"
$	if f$search("''INSTALL_FILE'") .eqs. ""
$	then
$	    ws ""
$	    ws "Unable to locate ''INSTALL_FILE'."
$	    ws "Installation files not found."
$	    ws "
$	    ws "This installation procedure looks for required files in a directory relative to"
$	    ws "the location of the procedure.  This error can occur if the installation procedure"
$	    ws "is moved from its original location.  It can also occur if an update to the
$	    ws "procedure is released and it is not possible to replace the original, as would be"
$	    ws "the case if the original procedure is on a CD."
$	    ws ""
$	    ws "''SOURCE' is assumed to be the top level directory for the kit."
$	    ws "This directory should contain the KIT, SOURCES, EXAMPLES, and DOCUMENTATION"
$	    ws "subdirectories.  If this is incorrect, please enter the correct device"
$	    inquire/nopunct SOURCE "and directory [ ''DEF_SOURCE' ] : "
$	    goto GET_SOURCE_LOOP
$	endif
$!
$GET_TARGET_LOOP:
$!
$	ws ""
$   	ws "Please enter the ODS-5 target destination device and directory or logical name"
$	ws "indicating the location where you would like to install ''XML_NAME'."
$	DEF_DEST = f$parse(f$env("default"),"[000000]",,"DEVICE","SYNTAX_ONLY") + "[XML]"
$!	inquire/nopunct DEST "This location will become the base directory for ''XML_NAME': (H) [ ''DEF_DEST' ] : "
$       open/read infile sys$command
$       read/prompt="This location will become the base directory for ''XML_NAME': (H) [ ''DEF_DEST' ] : " infile DEST
$	Q = f$edit(DEST, "TRIM")
$	if f$extract(0,1,Q) .eqs. "H"
$	then
$	    gosub HELP_GET_DEST
$	    goto GET_TARGET_LOOP
$	endif
$	if DEST .eqs. "" then DEST = DEF_DEST
$	TARGET_DEV	= f$parse("''DEST'","[000000]",,"DEVICE","SYNTAX_ONLY")
$	TARGET_DIR	= f$parse("''DEST'","[000000]",,"DIRECTORY","SYNTAX_ONLY")
$	TARGET_DEST	= TARGET_DEV + TARGET_DIR
$	ROOT_ND		= TARGET_DEST
$	ROOT		= ROOT_ND - "]" + ".]"
$	XERCES_ROOT	= ROOT_ND - "]" + ".Xerces-''LANG'-2_0.]"
$	XALAN_ROOT	= ROOT_ND - "]" + ".Xalan-''LANG'-2_0.]"
$	define/sys/nolog/trans=concealed 'XML_ROOT_LOG    'ROOT
$	define/sys/nolog/trans=concealed 'XERCES_ROOT_LOG 'XERCES_ROOT
$	define/sys/nolog/trans=concealed 'XALAN_ROOT_LOG  'XALAN_ROOT
$!
$	set default 'TARGET_DEST
$	define/user sys$output nl:
$	define/user sys$error nl:
$	directory
$	status = $status
$	if status .eq. %X1001C04A
$	then
$	    ws ""
$	    ws "''Target_DEST' does not exist."
$	    inquire/nopunct ANS "Would you like to create this directory? (Y, N) [Y] : "
$	    if ANS .eqs. "" then ANS = "Y"
$	    if ANS
$	    then
$		create/dir 'TARGET_DEST
$	    else
$		goto cleanup
$	    endif
$	endif
$!
$	gosub GET_VOLUME_TYPE
$	VOLUME_TYPE = $status .AND 7
$	if VOLUME_TYPE .eq. 0
$	then
$	    ws "''TARGET_DEV' appears to be unavailable."
$	    goto GET_TARGET_LOOP
$	endif
$       if VOLUME_TYPE .eq. 2
$	then
$	    ws "''TARGET_DEV' appears to be an ODS-2 volume."
$	    ws "Because of long filenames and directory depth issues,
$	    ws "the installed code base may not function properly."
$	    ws ""
$	    inquire/nopunct ANS "Are you sure you want to install to this disk? (Y, N) [N] : "
$	    if ANS .eqs. "" .OR. .NOT. ANS then goto GET_TARGET_LOOP
$	    ws ""
$	endif
$!
$! Shortcuts for some commonly referenced directories.
$!
$	KIT_SOURCE	    = SOURCE - "]" + ".KIT]"
$	KIT_BIN_SOURCE	    = KIT_SOURCE
$	KIT_EXAMPLES_SOURCE = SOURCE - "]" + ".EXAMPLES]"
$	KIT_SRC_SOURCE	    = SOURCE - "]" + ".SOURCES]"
$	KIT_DOCS_SOURCE	    = SOURCE - "]" + ".DOCUMENTATION]"
$	KIT_TOOLS_SOURCE    = SOURCE - "]" + ".TOOLS]"
$!
$! KIT_DEST	    - Location where files will be installed.
$! KIT_DEST_U 	    - Same as KIT_DEST, but unix style
$!
$       KIT_DEST		= "''XML_ROOT_LOG':[''XML_VERS']"
$	KIT_DEST_U		= "/''XML_ROOT_LOG'/''XML_VERS'/"
$	XERCES_DIR_U		= "/''XML_ROOT_LOG'/''XERCES_VERS'/"
$	XALAN_DIR_U		= "/''XML_ROOT_LOG'/''XALAN_VERS'/"
$!
$	OPTIONAL_DOCS   = "TRUE,TRUE" ! 2 of 2
$	MAX_DOCS	= 2
$	OPTIONAL_SRCS   = "TRUE,TRUE"
$	MAX_SRCS	= 2
$!
$!============================================================================ 
$!		    Determine Which Documentation to Install
$!============================================================================ 
$DETERMINE_DOC_FILES:
$!
$	LOCAL_DOCS_PRESENT	    = "FALSE"
$!
	type/nopage sys$input

  Documentation
------------------

Most documentation is in the form of HTML files.  Using a web browser,
the documentation can be accessed locally or remotely if served by a 
locally installed web server, or accessed locally without a web server 
by accessing the files directly.
 
Installing documentation is optional.  Even if you decide to install 
none of the documentation, it will still be available to you online. 

You can choose to install all of the documentation, or none of it.
$DDF10$:gosub SHOW_SELECTED_DOCS

$	ws ""
$	ws "Enter:  1 through ''MAX_DOCS' - To toggle a selection"
$	type sys$input
	A	    - To select All documentation
	N	    - To select No  documentation
	Y	    - To proceed with the installation

$	QUES = "A, N, 1-''MAX_DOCS', or Y : "
$	inquire/nopunct ANS "''QUES'"
$	if ANS .eqs. "" then goto DETERMINE_DOC_FILES
$	if ANS .eqs. "Y" then goto DDF_DONE
$	if ANS .eqs. "N"
$	then 
$	    INSTALL_DOCS = "FALSE,FALSE"
$	    goto DDF10$
$	else
$	    if ANS .eqs. "A"
$	    then
$		INSTALL_DOCS = OPTIONAL_DOCS
$		goto DDF10$
$	    else
$		selection = f$integer(ANS)
$		if selection .lt. 1 .or. selection .gt. MAX_DOCS then goto DDF10$
$		count = 1
$		NEW_INSTALL_DOCS = ""
$DDF20$:	if count .eq. selection
$		then
$		    if f$element(selection-1, ",", INSTALL_DOCS) .eqs. "FALSE" .and. -
		       f$element(selection-1, ",", OPTIONAL_DOCS) .eqs. "TRUE"
$		    then
$			NEW_INSTALL_DOCS = NEW_INSTALL_DOCS + "TRUE"
$		    else
$			NEW_INSTALL_DOCS = NEW_INSTALL_DOCS + "FALSE"
$		    endif
$		else
$		    NEW_INSTALL_DOCS = NEW_INSTALL_DOCS + f$element(count-1, ",", INSTALL_DOCS)
$		endif
$		count = count + 1
$		if count .lt. 5
$		then
$		    NEW_INSTALL_DOCS = NEW_INSTALL_DOCS + ","
$		    goto DDF20$
$		endif
$		INSTALL_DOCS = NEW_INSTALL_DOCS
$		goto DDF10$
$	    endif
$	endif
$!
$DDF_DONE:
$!============================================================================ 
$!		    Determine Which Sources to Install
$!============================================================================ 
$DETERMINE_SRC_FILES:
$!
	type/nopage sys$input

  Sources
------------

The components included in this kit are implemented entirely in Java.  It is not
necessary to install the sources or to build them.  The sources are provided
for those that may wish build them in order to do development work in this area.

You can choose to install all of the sources, or none of it.
$DSF10$:gosub SHOW_SELECTED_SRCS
$	ws ""
$	ws "Enter:  1 through ''MAX_SRCS' - To toggle a selection"
$	type/nopage sys$input
	A	    - To select All sources
	N	    - To select No  sources
	Y	    - To proceed with the installation

$	QUES = "A, N, 1-''MAX_SRCS', or Y : "
$	inquire/nopunct ANS "''QUES'"
$	if ANS .eqs. "" then goto DETERMINE_SRC_FILES
$	if ANS .eqs. "Y" then goto DSF_DONE
$	if ANS .eqs. "N"
$	then 
$	    INSTALL_SRCS = "FALSE,FALSE,FALSE"
$	    goto DSF10$
$	else
$	    if ANS .eqs. "A"
$	    then
$		INSTALL_SRCS = OPTIONAL_SRCS
$		goto DSF10$
$	    else
$		selection = f$integer(ANS)
$		if selection .lt. 1 .or. selection .gt. 4 then goto DSF10$
$		count = 1
$		NEW_INSTALL_SRCS = ""
$DSF20$:	if count .eq. selection
$		then
$		    if f$element(selection-1, ",", INSTALL_SRCS) .eqs. "FALSE" .and. -
		       f$element(selection-1, ",", OPTIONAL_SRCS) .eqs. "TRUE"
$		    then
$			NEW_INSTALL_SRCS = NEW_INSTALL_SRCS + "TRUE"
$		    else
$			NEW_INSTALL_SRCS = NEW_INSTALL_SRCS + "FALSE"
$		    endif
$		else
$		    NEW_INSTALL_SRCS = NEW_INSTALL_SRCS + f$element(count-1, ",", INSTALL_SRCS)
$		endif
$		count = count + 1
$		if count .lt. 8
$		then
$		    NEW_INSTALL_SRCS = NEW_INSTALL_SRCS + ","
$		    goto DSF20$
$		endif
$		INSTALL_SRCS = NEW_INSTALL_SRCS
$		goto DSF10$
$	    endif
$	endif
$!
$DSF_DONE:
$!
$	ws ""
$	ws "No further questions will be asked."
$	ws ""
$!
$! Do this silently, so that we don't have to special case this for the CD installation.
$! The CD better have the correct attributes set already!
$!
$	define/nolog sys$output nl:
$	define/nolog sys$error nl:
$	SET FILE/ATTRIBUTE=(RFM:FIX,RAT:NONE,LRL:32256) 'KIT_BIN_SOURCE'*.SAV
$	SET FILE/ATTRIBUTE=(RFM:FIX,RAT:NONE,LRL:32256) 'KIT_EXAMPLES_SOURCE'*.SAV
$	SET FILE/ATTRIBUTE=(RFM:FIX,RAT:NONE,LRL:32256) 'KIT_SRC_SOURCE'*.SAV
$	SET FILE/ATTRIBUTE=(RFM:FIX,RAT:NONE,LRL:32256) 'KIT_DOCS_SOURCE'*.SAV
$	SET FILE/ATTRIBUTE=(RFM:FIX,RAT:NONE,LRL:32256) 'KIT_TOOLS_SOURCE'*.SAV
$	deas sys$error
$	deas sys$output
$!
$! Make sure the destination directories exist.  This may not be the case if installed
$! from CD or if installed in a different directory that it was extracted.
$!
$	create/dir/nolog 'KIT_DEST
$	copy    'KIT_SOURCE'INSTALL_'XML_VERS'.COM	    'KIT_DEST
$	copy	'KIT_SOURCE'UNINSTALL_'XML_VERS'.COM	    'KIT_DEST
$	copy    'KIT_SOURCE''XML_VERS'-TP.COM		    'KIT_DEST
$	copy	'KIT_SOURCE'XERCES_SAMPLES_'XML_VERS'.COM   'KIT_DEST
$	copy    'KIT_SOURCE'XALAN_SAMPLES_'XML_VERS'.COM    'KIT_DEST
$	copy	'KIT_SOURCE''XML_VERS'_SetClassPath.com	    'KIT_DEST
$       copy    'KIT_SOURCE'index.html                      'KIT_DEST
$!
$!============================================================================ 
$!		    Install the binaries and samples
$!============================================================================ 
$INSTALL_BIN_FILES:
$!
$! Set JAVA$FILE_CONTROLS to preserve ODS-5 filenames.
$!
$	NEW_JAVA$FILENAME_CONTROLS = SAVED_JAVA$FILENAME_CONTROLS .AND. %XFFCFFFFF
$	define/nolog/job JAVA$FILENAME_CONTROLS 'NEW_JAVA$FILENAME_CONTROLS
$!
$       set def 'ROOT_ND
$       ws ""
$       ws "Installing binaries..."
$       ws "	''XERCES_VERS'..."
$	BACKUP 'KIT_BIN_SOURCE'xerces-'LCLANG'-bin-2_0.SAV/SAVE [...]
$       ws "	''XALAN_VERS'..."
$	BACKUP 'KIT_BIN_SOURCE'xalan-'LCLANG'-bin-2_0.SAV/SAVE [...]
$       ws ""
$       ws "Installing examples..."
$       ws "	''XERCES_VERS'..."
$	BACKUP 'KIT_EXAMPLES_SOURCE'xerces-'LCLANG'-samples-2_0.SAV/SAVE [...]
$       ws "	''XALAN_VERS'..."
$	BACKUP 'KIT_EXAMPLES_SOURCE'xalan-'LCLANG'-samples-2_0.SAV/SAVE [...]
$!
$!============================================================================ 
$!		    Install the Sources
$!============================================================================ 
$!
$	FIRST_SRC		    = "TRUE"
$       OPENIN_FILE = KIT_SOURCE + "SRC_DESCRIPS_''XML_VERS'.TXT"
$	open/read/error=open_in_error IN_FILE 'OPENIN_FILE
$	read/end=ISF_DONE IN_FILE record
$	count = 0
$ISF_LOOP:
$	read/end=ISF_DONE IN_FILE record
$	prod_name    = f$edit(f$element(0, ",", record),"TRIM")
$	prod_version = f$edit(f$element(1, ",", record),"TRIM")
$	src_saveset_name = prod_name + "-src-" + prod_version + ".SAV"
$	if f$element(count, ",", INSTALL_SRCS) .eqs. "TRUE"
$	then
$	    if FIRST_SRC
$	    then
$		ws ""
$		ws "Installing sources..."
$		FIRST_SRC = "FALSE"
$	    endif
$	    ws "	''prod_name'-''prod_version'..."
$	    BACKUP 'KIT_SRC_SOURCE''src_saveset_name'/SAVE  [...]
$	endif
$	count = count + 1
$	goto ISF_LOOP
$!
$ISF_DONE:
$!
$	close IN_FILE
$!
$!============================================================================ 
$!		    Install the Documentation
$!============================================================================ 
$!
$! Unpack the documents. 
$!
$!				Note
$! The target directory name and document jar file name are derived
$! from the records in DOC_DESCRIPS_*.TXT.
$!
$	FIRST_DOC		    = "TRUE"
$       OPENIN_FILE = KIT_SOURCE + "DOC_DESCRIPS_''XML_VERS'.TXT"
$	open/read/error=open_in_error IN_FILE 'OPENIN_FILE
$	read/end=IDF_DONE IN_FILE record
$	count = 0
$IDF_LOOP:
$	read/end=IDF_DONE IN_FILE record
$	prod_name    = f$edit(f$element(0, ",", record),"TRIM")
$	prod_version = f$edit(f$element(1, ",", record),"TRIM")
$	full_name    = f$edit(f$element(2, ",", record),"TRIM")
$	doc_dir_name = prod_name + "-" + prod_version
$	dir_el = 4
$IDFC_LOOP:
$	doc_dir_name = doc_dir_name + "/"
$	next_dir     = f$edit(f$element(dir_el, ",", record),"TRIM")
$	if next_dir .nes. ","
$	then
$	    doc_dir_name = doc_dir_name + next_dir
$	    dir_el = dir_el + 1
$	    goto IDFC_LOOP
$	endif
$	doc_saveset_name = prod_name + "-docs-" + prod_version + ".SAV"
$	if f$element(count, ",", INSTALL_DOCS) .eqs. "TRUE"
$	then
$	    if FIRST_DOC
$	    then
$               ws ""
$		ws "Installing documentation..."
$		FIRST_DOC = "FALSE"
$		LOCAL_DOCS_PRESENT = "TRUE"
$	    endif
$!	    
$	    alias_dir  := "/''XML_ROOT_LOG'/''doc_dir_name'"
$	    alias_name := "''prod_name'-docs"
$	    out_record = "	" + f$fao("!14AS", "''prod_name'-''prod_version'")
$	    ws out_record
$	    BACKUP 'KIT_DOCS_SOURCE''doc_saveset_name'/SAVE [...]
$!
$	endif
$	count = count + 1
$	goto IDF_LOOP
$!
$IDF_DONE:
$!
$	close IN_FILE
$!
$	if LOCAL_DOCS_PRESENT
$	then
$	endif
$	    ws ""
$	    INQUIRE ANS "Press the <Enter> key to continue"
$!============================================================================ 
$!		    Fix up file access
$!============================================================================ 
$!
$!	See SYS$MANAGER:APACHE$CONFIG.COM
$!
$       OPENIN_FILE = KIT_SOURCE + "DOC_DESCRIPS_''XML_VERS'.TXT"
$	open/read/error=open_in_error IN_FILE 'OPENIN_FILE
$	read/end=FUFA_DONE IN_FILE record
$	count = 0
$FUFA_LOOP:
$	read/end=FUFA_EOF IN_FILE record
$	if f$element(count, ",", INSTALL_DOCS) .eqs. "TRUE"
$	then
$	    prod_name    = f$edit(f$element(0, ",", record),"TRIM")
$	    prod_version = f$edit(f$element(1, ",", record),"TRIM")
$	    prod_name_vers = prod_name + "-" + prod_version
$	    out_record = "	" + f$fao("!14AS", "''prod_name_vers'") + "documents"
$	    doc_dir_name = prod_name_vers
$	    dir_el = 4
$FUFA_LOOP2:
$	    next_dir     = f$edit(f$element(dir_el, ",", record),"TRIM")
$	    if next_dir .nes. ","
$	    then
$		target = "''XML_ROOT_LOG':[''doc_dir_name']''next_dir'.DIR"
$		doc_dir_name = doc_dir_name + "." + next_dir
$		target = "''XML_ROOT_LOG':[''doc_dir_name'...]
$		dir_el = dir_el + 1
$		goto FUFA_LOOP2
$	    endif
$	endif
$	count = count + 1
$	goto FUFA_LOOP
$!
$FUFA_EOF:
$	close IN_FILE
$FUFA_DONE:
$!
$	ws ""
$	ws "    ''XML_NAME' Installation complete."
$	ws ""
$	ws "--------------------------------------------------------------------------"
$	ws "    ''XML_ROOT_LOG', ''XERCES_ROOT_LOG' and ''XALAN_ROOT_LOG'  have been defined."
$	ws "    The following lines must be added to SYS$MANAGER:SYLOGICALS.COM so"
$	ws "    that it will be defined each time the system is rebooted."
$	ws ""
$	ws "      $ define/sys/nolog/trans=concealed ''XML_ROOT_LOG' ''ROOT'"
$	ws "      $ define/sys/nolog/trans=concealed ''XERCES_ROOT_LOG' ''XERCES_ROOT'"
$	ws "      $ define/sys/nolog/trans=concealed ''XALAN_ROOT_LOG' ''XALAN_ROOT'"
$	ws "--------------------------------------------------------------------------"
$	ws ""
$	INQUIRE ANS "Press the <Enter> key to continue"
$	ws ""
$	ws " Post Installation Checkout"
$	ws "----------------------------"
$	ws ""
$	ws "Verification of the installation can be performed using the ''XML_BASE_NAME'"
$	ws "Test Procedure.  To run the ''XML_BASE_NAME' Test Procedure, enter the"
$	ws "following command:"
$	ws ""
$	ws "	$ @''XML_ROOT_LOG':[''XML_VERS']''XML_VERS'-TP"
$	ws ""
$	ws "The file ''XML_ROOT_LOG':[''XML_VERS']''XML_VERS'_SetClassPath.com has been"
$	ws "provided to set up the Java class path for the ''XML_BASE_NAME' Test Procedure."
$	ws "It may also be useful to retain for your own XML applications."
$	ws ""
$       ws ""
$       ws "Should you wish to remove ''XML_NAME', enter the following command:"
$       ws ""
$       ws "    @''XML_ROOT_LOG':[''XML_VERS']UNINSTALL_''XML_VERS'"
$       ws ""
$!
$cleanup:
$!
$	if SAVED_JAVA$FILENAME_CONTROLS .nes. ""
$	then
$	    define/nolog/job JAVA$FILENAME_CONTROLS 'SAVED_JAVA$FILENAME_CONTROLS
$	else
$	    define/user sys$error nl:
$	    define/user sys$output nl:
$	    deas/job JAVA$FILENAME_CONTROLS
$	endif
$       if SAVED_PARSE_STYLE .nes. ""
$	then
$	    SET PROCESS/PARSE_STYE='SAVED_PARSE_STYLE
$	endif
$	if SAVED_CASE_LOOKUP .nes. ""
$	then
$	    SET PROCESS/CASE_LOOKUP='SAVED_CASE_LOOKUP
$	endif
$!
$	if SAVED_CASE_PRESERVE .nes. ""
$	then
$	    define/nolog DECC$EFS_CASE_PRESERVE 'SAVED_CASE_PRESERVE
$	else
$	    if f$trnlnm("DECC$EFS_CASE_PRESERVE") .nes. "" then deas DECC$EFS_CASE_PRESERVE
$	endif
$	if SAVED_CASE_SPECIAL .nes. ""
$	then
$	    define/nolog DECC$EFS_CASE_SPECIAL 'SAVED_CASE_SPECIAL
$	else
$	    if f$trnlnm("DECC$EFS_CASE_SPECIAL") .nes. "" then deas DECC$EFS_CASE_SPECIAL
$	endif
$	if SAVED_EFS_CHARSET .nes. ""
$	then
$	    define/nolog DECC$EFS_CHARSET 'SAVED_EFS_CHARSET
$	else
$	    if f$trnlnm("DECC$EFS_CHARSET") .nes. "" then deas DECC$EFS_CHARSET
$	endif
$!	    
$	if f$trnlnm("IN_FILE")    .nes. "" then close IN_FILE
$	if f$trnlnm("OUT_FILE")   .nes. "" then close OUT_FILE
$	if f$trnlnm("CONF_FILE")  .nes. "" then close CONF_FILE
$	if f$trnlnm("HTML_FILE")  .nes. "" then close HTML_FILE
$	set default 'saved_default
$	scratch = f$verify(saved_verify)
$	exit
$!
$open_out_error:
$	ws ""
$	ws "Error opening output file ''OPENOUT_FILE'"
$	ws ""
$	define/user sys$output nl:
$	define/user sys$error nl:
$	delete/sym/global OPENOUT_FILE
$	goto cleanup
$!
$open_in_error:
$	ws ""
$	ws "Error opening input file ''OPENIN_FILE'"
$	ws ""
$	define/user sys$output nl:
$	define/user sys$error nl:
$	delete/sym/global OPENIN_FILE
$	goto cleanup
$!
$!----------------------------------------------------------------------------
$!
$! Subroutine to display a list of documentation selected for installation.
$!
$!	INSTALL_DOCS		List of boolean expressions indicating which
$!				documents are selected.
$!	OPTIONAL_DOCS		List of boolean expressions indicating which
$!				document are allowed for this installation
$!				(client or server).
$!	DOC_DESCRIPS_*.TXT      File containing records corresponding to the
$!				above list.
$!
$!----------------------------------------------------------------------------
$SHOW_SELECTED_DOCS:
$!
$	count = 0
$       OPENIN_FILE == KIT_SOURCE + "DOC_DESCRIPS_''XML_VERS'.TXT"
$	open/read/error=open_in_error IN_FILE 'OPENIN_FILE
$	read/end=ssd_done IN_FILE record
$	ws ""
$	ws "    --------------------------------------------------------------------"
$ssd_loop:
$	read/end=ssd_done IN_FILE record
$	doc_name = f$element(2, ",", record)
$	doc_size = f$element(3, ",", record)
$	count = count + 1
$	if f$element(count-1, "," ,INSTALL_DOCS) .eqs. "TRUE"
$	then output_record = "x"
$	else output_record = " "
$	endif
$	if f$element(count-1, "," ,OPTIONAL_DOCS) .eqs. "TRUE"
$	then 
$	    output_record = "      ''count'.    [" + output_record + "]   " + doc_name + "  ~" + doc_size + " blocks"
$	    ws output_record
$	endif
$	goto ssd_loop
$!
$ssd_done:
$!
$	ws "    --------------------------------------------------------------------"
$	ws "	    [x] = Selected,  [ ] = Not Selected"
$	close IN_FILE
$	return
$!
$!----------------------------------------------------------------------------
$!
$! Subroutine to display a list of sources selected for installation.
$!
$!	INSTALL_SRCS		List of boolean expressions indicating which
$!				sources are selected.
$!	OPTIONAL_SRCS		List of boolean expressions indicating which
$!				sources are allowed for this installation
$!				(client or server).
$!	SRC_DESCRIPS_*.TXT      File containing records corresponding to the
$!				above list.
$!
$!----------------------------------------------------------------------------
$SHOW_SELECTED_SRCS:
$!
$	count = 0
$       OPENIN_FILE == KIT_SOURCE + "SRC_DESCRIPS_''XML_VERS'.TXT"
$	open/read/error=open_in_error IN_FILE 'OPENIN_FILE
$	read/end=sss_done IN_FILE record
$	ws ""
$	ws "    --------------------------------------------------------------------"
$sss_loop:
$	read/end=sss_done IN_FILE record
$	src_name = f$element(2, ",", record)
$	src_size = f$element(3, ",", record)
$	count = count + 1
$	if f$element(count-1, "," ,INSTALL_SRCS) .eqs. "TRUE"
$	then output_record = "x"
$	else output_record = " "
$	endif
$	if f$element(count-1, "," ,OPTIONAL_SRCS) .eqs. "TRUE"
$	then 
$	    output_record = "      ''count'.    [" + output_record + "]   " + src_name + "  ~" + src_size + " blocks"
$	    ws output_record
$	endif
$	goto sss_loop
$!
$sss_done:
$!
$	ws "    --------------------------------------------------------------------"
$	ws "	    [x] = Selected,  [ ] = Not Selected"
$	close IN_FILE
$	return
$!
$GET_VOLUME_TYPE:
$!
$	GVT = 0
$	TEMP_FILE = "SYS$SCRATCH:ISSHDEV.TMP"
$	NOMATCHES = %X08D78053
$	show dev 'TARGET_DEV'/FULL/OUTPUT='TEMP_FILE
$	if ($status .AND. 1) .EQ. 1
$	then
$	    define sys$output nl:
$	    define sys$error  nl:
$	    search 'TEMP_FILE "ODS-5"
$	    if $status .EQ. 1
$	    then
$		ws "GVT = 5"
$		GVT = 5
$	    else
$		search 'TEMP_FILE "ODS-2"
$		if $status .EQ. 1
$		then
$		    ws "GVT = 2"
$		    GVT = 2
$		endif
$	    endif
$	    deas sys$output
$	    deas sys$error
$	endif
$	if f$search("''TEMP_FILE'") .nes. ""
$	then delete/nolog 'TEMP_FILE';
$	endif
$	return (GVT .OR. %X10000000)
$!
$!----------------------------------------------------------------
$HELP_GET_DEST:
$!
$	type/nopage sys$input

    The target destination can be a device and/or directory specification,
    or a logical name pointing to a device and/or directory, or combination
    thereof.  Examples:

	  $6$DKA100:, [MY_XML_DIRECTORY], WORK$:[XML]

    If only the device is specified, the directory trees for the installation
    will be created in the top level directory on that device.  If only the
    directory is specified, the directory trees for the installation will be
    created in that directory on the default device for the current process.

    In all cases, the target destination should reside on an ODS-5 device.
    If installed on an ODS-2 device, some documentation files may be
    inaccessible and source code may not compile.

$	return
$!
$!----------------------------------------------------------------
