/*
 * Decompiled with CFR 0.152.
 */
package InstallOpenVMSProvisioning;

import InstallOpenVMSProvisioning.StreamReader;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;

public class InstallOpenVMSProvisioningJFrame
extends JFrame {
    private final String InstallLogFile = "InstallOpenVMSProvisioning";
    private final String SIM_LOC_CMD = "gsl.exe";
    private final String VMS_TDEF_FILE = "OpenVMS.xml";
    private final String VMS_WAR_FILE = "OpenVMSInfoBlade.war";
    private boolean debugFlag = false;
    private boolean logFileOpen;
    private ImageIcon myCheckIcon;
    private ImageIcon myCrossIcon;
    private String osName;
    private String mxtoolAddCmd;
    private String mxtoolRmCmd;
    private String mxtoolDir;
    private String logDir;
    private String webappsDir;
    private String fileSep;
    private String errMsg;
    private String SIMLocation;
    private File OpenVMSDir;
    private File vmsTDEFFile;
    private File OpenVMSLogDir;
    private File vmsWarFile;
    private File src1;
    private File src2;
    private FileOutputStream installLog;
    private JLabel installComponentIcon;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JProgressBar jProgressBar1;
    private JTextArea outputStr;
    private JLabel updateToolIcon;

    public void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public String execCmd(String cmd) {
        String result = new String();
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            result = reader.getResult();
        }
        catch (Exception e) {
            if (this.debugFlag) {
                this.DumpLog("execCmd Exception: " + e);
            }
            return null;
        }
        if (result.equals("") || result.equals("\r\n")) {
            return null;
        }
        return result;
    }

    public void DumpLog(String msg) {
        if (this.logFileOpen) {
            try {
                String logStr = new String();
                char[] tStr = new char[]{'\r', '\n'};
                String newLine = new String(tStr);
                logStr = "@@@@@@   ";
                logStr = logStr + new Date().toString();
                logStr = logStr + "   " + msg;
                this.installLog.write(logStr.getBytes());
                this.installLog.write(newLine.getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void UpdateScreenOnFail(String msg) {
        final String localMsg = msg;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallOpenVMSProvisioningJFrame.this.installComponentIcon.setIcon(InstallOpenVMSProvisioningJFrame.this.myCrossIcon);
                InstallOpenVMSProvisioningJFrame.this.updateToolIcon.setIcon(InstallOpenVMSProvisioningJFrame.this.myCrossIcon);
                InstallOpenVMSProvisioningJFrame.this.jProgressBar1.setVisible(false);
                InstallOpenVMSProvisioningJFrame.this.outputStr.setForeground(Color.RED);
                InstallOpenVMSProvisioningJFrame.this.outputStr.setText(localMsg);
            }
        });
        this.DumpLog(msg);
    }

    public void UpdateScreen(String msg) {
        final String localMsg = msg;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallOpenVMSProvisioningJFrame.this.outputStr.setForeground(Color.BLUE);
                InstallOpenVMSProvisioningJFrame.this.outputStr.setText(localMsg);
            }
        });
        this.DumpLog(msg);
    }

    public void myDelay() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void myDelay2() {
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean InitPluginInstall(String osName) {
        if (osName.indexOf("Windows") != -1) {
            String execResult = this.execCmd("gsl.exe");
            if (execResult == null) {
                this.errMsg = "HP SIM  installation not found on the system.";
                return false;
            }
            String myStr = new String(execResult);
            StringTokenizer st = new StringTokenizer(myStr, "\r\n");
            this.SIMLocation = (String)st.nextElement();
            if (this.debugFlag) {
                this.DumpLog("SIM_LOC_CMD returned... " + this.SIMLocation);
            }
            this.mxtoolAddCmd = "mxtool -a -f \"" + this.SIMLocation + "\\tools\\OpenVMS\\OpenVMS.xml\"";
            this.mxtoolRmCmd = "mxtool -r -f \"" + this.SIMLocation + "\\tools\\OpenVMS\\OpenVMS.xml\"" + " -x force";
            this.webappsDir = this.SIMLocation + "\\hpwebadmin\\webapps\\";
            this.OpenVMSDir = new File(this.SIMLocation + "\\tools\\OpenVMS");
            this.OpenVMSLogDir = new File(this.SIMLocation + "\\logs\\OpenVMS");
            this.vmsTDEFFile = new File(this.SIMLocation + "\\tools\\OpenVMS\\OpenVMS.xml");
            this.vmsWarFile = new File(this.webappsDir + "OpenVMSInfoBlade.war");
            this.src1 = new File("OpenVMS.xml");
            this.src2 = new File("OpenVMSInfoBlade.war");
        } else if (osName.indexOf("Linux") != -1 || osName.indexOf("HP-UX") != -1) {
            File mxDir = new File("/opt/mx");
            File binDir = new File("/opt/mx/bin");
            File mxtool = new File("/opt/mx/bin/mxtool");
            File webAppsDir = new File("/opt/hpwebadmin/webapps");
            File logsDir = new File("/opt/hpwebadmin/logs");
            File toolsDir = new File("/opt/mx/newconfig/var/opt/mx/tools");
            if (!(mxDir.exists() && binDir.exists() && mxtool.exists() && webAppsDir.exists() && logsDir.exists() && toolsDir.exists())) {
                this.errMsg = "Please Install HP SIM before trying to install this plug-in.";
                return false;
            }
            this.mxtoolAddCmd = "/opt/mx/bin/mxtool -a -f /opt/mx/newconfig/var/opt/mx/tools/OpenVMS/OpenVMS.xml";
            this.mxtoolRmCmd = "/opt/mx/bin/mxtool -r -f /opt/mx/newconfig/var/opt/mx/tools/OpenVMS/OpenVMS.xml -x force";
            this.webappsDir = "/opt/hpwebadmin/webapps/";
            this.OpenVMSDir = new File("/opt/mx/newconfig/var/opt/mx/tools/OpenVMS");
            this.vmsTDEFFile = new File("/opt/mx/newconfig/var/opt/mx/tools/OpenVMS/OpenVMS.xml");
            this.OpenVMSLogDir = new File("/opt/hpwebadmin/logs/OpenVMS");
            this.vmsWarFile = new File(this.webappsDir + "OpenVMSInfoBlade.war");
            this.src1 = new File("OpenVMS.xml");
            this.src2 = new File("OpenVMSInfoBlade.war");
        } else {
            this.errMsg = "Unsupported Hardware.";
            return false;
        }
        return true;
    }

    public void closeLogFile() {
        try {
            this.installLog.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void OperationInstall() {
        String cmdResult;
        this.osName = System.getProperty("os.name");
        if (!(this.osName.indexOf("Linux") == -1 && this.osName.indexOf("HP-UX") == -1 || System.getProperty("user.name").equals("root"))) {
            this.UpdateScreenOnFail("Only root can install this plug-in.");
            this.myDelay2();
            System.exit(1);
        }
        String rawDate = DateFormat.getDateInstance(2, new Locale("en", "US")).format(new Date());
        String fmtDate = new String();
        StringTokenizer st = new StringTokenizer(rawDate, "\r \n , ");
        while (st.hasMoreTokens()) {
            fmtDate = fmtDate + (String)st.nextElement();
        }
        try {
            this.installLog = new FileOutputStream("InstallOpenVMSProvisioning_" + fmtDate + ".log");
        }
        catch (FileNotFoundException e) {
            this.UpdateScreenOnFail("Failed to create installation log file.");
            this.myDelay2();
            System.exit(1);
        }
        this.logFileOpen = true;
        if (!this.InitPluginInstall(this.osName)) {
            this.UpdateScreenOnFail(this.errMsg);
            if (this.logFileOpen) {
                this.closeLogFile();
            }
            return;
        }
        if (this.debugFlag) {
            this.DumpLog("mxtoolRmCmd: " + this.mxtoolRmCmd);
            this.DumpLog("mxtoolAddCmd: " + this.mxtoolAddCmd);
            this.DumpLog("webappsDir: " + this.webappsDir);
        }
        if (this.OpenVMSDir.exists()) {
            if (this.vmsTDEFFile.exists()) {
                this.UpdateScreen("Remove existing OpenVMS tool from HP SIM...");
                cmdResult = this.execCmd(this.mxtoolRmCmd);
                this.myDelay();
                if (this.debugFlag) {
                    this.DumpLog("exec mxtoolRmCmd returned: " + cmdResult);
                }
                if (cmdResult == null) {
                    if (this.debugFlag) {
                        this.DumpLog("exec mxtoolRmCmd returned null, exiting...");
                    }
                    if (this.logFileOpen) {
                        this.closeLogFile();
                    }
                    System.exit(1);
                } else if (cmdResult.indexOf("is not recognized as an internal or external command") != -1) {
                    this.UpdateScreenOnFail("mxtool cmd not recognized on the system.");
                    if (this.logFileOpen) {
                        this.closeLogFile();
                    }
                    System.exit(1);
                }
                if (this.debugFlag) {
                    this.DumpLog("tdef file exists trying to delete...");
                }
                this.UpdateScreen("Delete old OpenVMDS tdef file...");
                this.myDelay();
                if (!this.vmsTDEFFile.delete()) {
                    if (this.debugFlag) {
                        this.DumpLog("failed to delete tdef file should return...");
                    }
                    this.UpdateScreenOnFail("Cannot delete files, Please make sure you are running the application from system account.");
                    if (this.logFileOpen) {
                        this.closeLogFile();
                    }
                    System.exit(1);
                }
            }
        } else {
            this.UpdateScreen("Create OpenVMS tools directory...");
            this.myDelay();
            if (!this.OpenVMSDir.mkdir()) {
                if (this.debugFlag) {
                    this.DumpLog("OpenVMSDir create failed...");
                }
                this.UpdateScreenOnFail("Cannot create OpenVMS tools directory, Please make sure you are running the application from system account.");
                if (this.logFileOpen) {
                    this.closeLogFile();
                }
                System.exit(1);
            }
        }
        this.UpdateScreen("Create OpenVMS log directory if one does not exist...");
        this.myDelay();
        if (!this.OpenVMSLogDir.exists() && !this.OpenVMSLogDir.mkdir()) {
            if (this.debugFlag) {
                this.DumpLog("OpenVMSLogDir create failed...");
            }
            this.UpdateScreenOnFail("Cannot create OpenVMS Log directory, Please make sure you are running the application from system account.");
            if (this.logFileOpen) {
                this.closeLogFile();
            }
            System.exit(1);
        }
        if (this.vmsWarFile.exists()) {
            if (this.debugFlag) {
                this.DumpLog("war file exists trying to delete...");
            }
            this.UpdateScreen("Delete old OpenVMDS war file...");
            this.myDelay();
            if (!this.vmsWarFile.delete()) {
                if (this.debugFlag) {
                    this.DumpLog("failed to delete war file trying to exit...");
                }
                this.UpdateScreenOnFail("Cannot delete files, Please make sure you are running the application from system account.");
                if (this.logFileOpen) {
                    this.closeLogFile();
                }
                System.exit(1);
            }
        }
        try {
            this.UpdateScreen("Copy new OpenVMS tdef file...");
            this.myDelay();
            if (!this.src1.exists()) {
                this.UpdateScreenOnFail("Cannot locate OpenVMS.xml to copy.");
                if (this.logFileOpen) {
                    this.closeLogFile();
                }
                System.exit(1);
            }
            this.copyFile(this.src1, this.vmsTDEFFile);
            this.UpdateScreen("Copy new OpenVMS war file...");
            this.myDelay();
            if (!this.src2.exists()) {
                this.UpdateScreenOnFail("Cannot locate OpenVMS war file to copy.");
                if (this.logFileOpen) {
                    this.closeLogFile();
                }
                System.exit(1);
            }
            this.copyFile(this.src2, this.vmsWarFile);
        }
        catch (Exception e) {
            if (this.debugFlag) {
                this.DumpLog("file copy failed trying to exit...");
            }
            this.UpdateScreenOnFail("Cannot copy files, Please make sure you are running the application from system account.");
            if (this.logFileOpen) {
                this.closeLogFile();
            }
            System.exit(1);
        }
        if (this.debugFlag) {
            this.DumpLog("all files copied next is mxtool update...");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallOpenVMSProvisioningJFrame.this.installComponentIcon.setIcon(InstallOpenVMSProvisioningJFrame.this.myCheckIcon);
            }
        });
        this.myDelay();
        this.UpdateScreen("Update HP SIM tools...");
        this.myDelay();
        cmdResult = this.execCmd(this.mxtoolAddCmd);
        if (this.debugFlag) {
            this.DumpLog("exec mxtoolAddCmd returned: " + cmdResult);
        }
        if (cmdResult == null) {
            if (this.debugFlag) {
                this.DumpLog("exec mxtoolAddCmd returned null, exiting...");
            }
            if (this.logFileOpen) {
                this.closeLogFile();
            }
            System.exit(1);
        } else if (cmdResult.indexOf("Error on line") != -1) {
            if (this.debugFlag) {
                this.DumpLog("TDEF file is corrupt, cannot update SIM tools.");
            }
            this.UpdateScreenOnFail("TDEF file is corrupt, cannot update SIM tools.");
            if (this.logFileOpen) {
                this.closeLogFile();
            }
            System.exit(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallOpenVMSProvisioningJFrame.this.updateToolIcon.setIcon(InstallOpenVMSProvisioningJFrame.this.myCheckIcon);
            }
        });
        this.myDelay();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstallOpenVMSProvisioningJFrame.this.jProgressBar1.setVisible(false);
                InstallOpenVMSProvisioningJFrame.this.outputStr.setForeground(Color.BLUE);
                InstallOpenVMSProvisioningJFrame.this.outputStr.setText("Installation Complete. Please restart your browsers to use OpenVMS Provisioning Tools.");
            }
        });
        if (this.debugFlag) {
            this.DumpLog("Installation successful");
        }
        this.DumpLog("Installation successful...");
        if (this.logFileOpen) {
            this.closeLogFile();
        }
    }

    public InstallOpenVMSProvisioningJFrame() {
        this.initComponents();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle vBounds = new Rectangle();
        GraphicsDevice[] gdArray = ge.getScreenDevices();
        for (int i = 0; i < gdArray.length; ++i) {
            GraphicsDevice gd = gdArray[i];
            GraphicsConfiguration[] gcArray = gd.getConfigurations();
            for (int j = 0; j < gcArray.length; ++j) {
                vBounds = vBounds.union(gcArray[j].getBounds());
            }
        }
        Dimension winSize = vBounds.getSize();
        Rectangle myRect = this.getBounds();
        Rectangle finalRect = new Rectangle();
        finalRect.x = winSize.width / 2 - myRect.width / 2;
        finalRect.y = winSize.height / 2 - myRect.height / 2;
        finalRect.width = myRect.width;
        finalRect.height = myRect.height;
        this.setBounds(finalRect);
        this.fileSep = new String(System.getProperty("file.separator"));
        this.myCheckIcon = new ImageIcon(this.getClass().getResource("/images/check.gif"));
        this.myCrossIcon = new ImageIcon(this.getClass().getResource("/images/cross.gif"));
        this.osName = new String();
        this.mxtoolAddCmd = new String();
        this.mxtoolRmCmd = new String();
        this.mxtoolDir = new String();
        this.webappsDir = new String();
        this.logDir = new String();
        this.errMsg = new String();
        this.SIMLocation = new String();
        this.logFileOpen = false;
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                InstallOpenVMSProvisioningJFrame.this.jProgressBar1.setIndeterminate(true);
                InstallOpenVMSProvisioningJFrame.this.jButton1.setEnabled(false);
                InstallOpenVMSProvisioningJFrame.this.outputStr.setText("");
                Thread worker = new Thread(){

                    public void run() {
                        InstallOpenVMSProvisioningJFrame.this.OperationInstall();
                    }
                };
                worker.start();
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.installComponentIcon = new JLabel();
        this.jLabel7 = new JLabel();
        this.updateToolIcon = new JLabel();
        this.jLabel9 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jButton1 = new JButton();
        this.outputStr = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("OpenVMS Provisioning For HP SIM Installation Wizard");
        this.setBackground(new Color(255, 255, 255));
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(this.jLabel2, -1, 20, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(this.jLabel2, -1, 27, Short.MAX_VALUE));
        this.jPanel3.setBackground(new Color(255, 255, 255));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(this.jLabel5, -1, 20, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(this.jLabel5, -1, 25, Short.MAX_VALUE));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/images/OpenVMS.gif")));
        this.jLabel3.setFont(new Font("Dialog", 1, 14));
        this.jLabel3.setText("HP OpenVMS Provisioning plug-in For HP SIM");
        this.installComponentIcon.setBackground(new Color(255, 255, 255));
        this.installComponentIcon.setHorizontalAlignment(4);
        this.jLabel7.setBackground(new Color(255, 255, 255));
        this.jLabel7.setFont(new Font("Tahoma", 0, 10));
        this.jLabel7.setText("Install HP OpenVMS Provisioning Components...");
        this.updateToolIcon.setBackground(new Color(255, 255, 255));
        this.updateToolIcon.setHorizontalAlignment(4);
        this.jLabel9.setBackground(new Color(255, 255, 255));
        this.jLabel9.setFont(new Font("Tahoma", 0, 10));
        this.jLabel9.setText("Update HP SIM Deploy Tools...");
        this.jProgressBar1.setForeground(new Color(255, 51, 51));
        this.jButton1.setText("Install");
        this.outputStr.setColumns(20);
        this.outputStr.setEditable(false);
        this.outputStr.setForeground(new Color(51, 153, 0));
        this.outputStr.setLineWrap(true);
        this.outputStr.setRows(5);
        this.outputStr.setText("( Click Install To begin Installation )");
        this.outputStr.setWrapStyleWord(true);
        this.outputStr.setBorder(null);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.outputStr, -2, 298, -2).add(jPanel1Layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.installComponentIcon, -2, 33, -2).addPreferredGap(0).add(this.jLabel7, -2, 245, -2)).add(jPanel1Layout.createParallelGroup(2, false).add(1, this.jProgressBar1, -1, -1, Short.MAX_VALUE).add(1, jPanel1Layout.createSequentialGroup().add(this.updateToolIcon, -2, 33, -2).addPreferredGap(0).add(this.jLabel9, -2, 245, -2))).add(jPanel1Layout.createParallelGroup(2).add(this.jButton1, -2, 73, -2).add(this.jLabel3))).addPreferredGap(0).add(this.jPanel2, -2, -1, -2).add(439, 439, 439).add(this.jPanel3, -2, -1, -2)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(42, 42, 42).add(this.jPanel2, -2, -1, -2)).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1, -2, 42, -2).add(this.jLabel3, -2, 30, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.installComponentIcon, -2, 31, -2).add(this.jLabel7, -2, 31, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.updateToolIcon, -2, 31, -2).add(this.jLabel9, -2, 31, -2)))).addPreferredGap(0, -1, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(2).add(this.jPanel3, -2, -1, -2).add(this.jProgressBar1, -2, 11, -2)).add(11, 11, 11).add(jPanel1Layout.createParallelGroup(2).add(this.jButton1).add(this.outputStr, -2, 58, -2)).add(137, 137, 137)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, 406, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, 235, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new InstallOpenVMSProvisioningJFrame().setVisible(true);
            }
        });
    }
}

