$	goto start
$!
$! INSTALL_SOAP-1_1.COM
$! Installation procedure for SOAP 1.1 (based on Apache SOAP 2.3.1).
$!
$!	Copyright  2003 Hewlett-Packard Company
$!
$!	PRD		Paul R. DeStefano	11-Feb-2003
$!	Adapted from INSTALL_SOAP-1_0.COM, this procedure differs from
$!	the 1.0 procedure in the fact that SOAP 1.1 installs on CSWS_JAVA 2.0
$!	or later.  CSWS_JAVA 2.0 includes activation.jar, mail.jar, and
$!	xerces.jar, so these no longer need to be provided in the SOAP Tools
$!	Kit.
$!
$!	Changes to handling of INSTALL_DOCS, INSTALL_SRCS, .TOMCATRC,
$!	APACHE$JAKARTA_CONFIG.COM
$!
$!	Requirements have been tightened: Must be VMS 7.2-2 or later (also
$!	a requirement of SWS and CSWS_JAVA), SWS 1.2 or later, CSWS_JAVA
$!	2.0 or later, Java 1.3.1 or later (also a requirement of CSWS_JAVA).
$!
$start:	set noon
$	saved_verify = f$verify(f$trnlnm("install_soap$verify"))
$	saved_default = f$env("default")
$	on control_y then goto cleanup
$!
$	DELETE    := DELETE
$	PURGE     := PURGE
$	OPEN      := OPEN
$	DIRECTORY := DIRECTORY
$	TYPE      := TYPE
$	CLOSE     := CLOSE
$	CALL      := CALL
$	COPY      := COPY
$	DEFINE    := DEFINE
$	DEASSIGN  := DEASSIGN
$	CREATE    := CREATE
$	PRINT     := PRINT
$	SET       := SET
$	SHOW      := SHOW
$	WRITE     := WRITE
$	READ      := READ
$!
$	WS	  := write sys$output
$!
$	SOURCE				= ""
$	SAVED_CASE_LOOKUP		= ""
$	SAVED_JAVA$FILENAME_CONTROLS = f$trnlnm("JAVA$FILENAME_CONTROLS")
$	SAVED_PARSE_STYLE   = f$getjpi("", "PARSE_STYLE_PERM")
$	SAVED_CASE_PRESERVE = f$trnlnm("DECC$EFS_CASE_PRESERVE")
$	SAVED_CASE_SPECIAL  = f$trnlnm("DECC$EFS_CASE_SPECIAL")
$	SAVED_EFS_CHARSET   = f$trnlnm("DECC$EFS_CHARSET")
$!
$	on control_y then goto cleanup
$!
$	OS = f$edit(f$getsyi("VERSION"),"COLLAPSE")
$	if OS .lts. "V7.2-2"
$	then
$	    ws "*****************************************************************"
$	    ws "It appears that the installed OpenVMS version is less than V7.2-2"
$	    ws "Please upgrade before installing the SOAP Toolkit"
$	    ws "*****************************************************************"
$	    goto cleanup
$	endif
$!
$	SET PROCESS/PARSE_STYE=EXTENDED
$	DEFINE DECC$EFS_CASE_PRESERVE ENABLE
$	DEFINE DECC$EFS_CASE_SPECIAL ENABLE
$	DEFINE DECC$EFS_CHARSET ENABLE
$!
$	if OS .ges. "V7.3-1"		! set proc/case is not in V7.3
$	then
$	    SAVED_CASE_LOOKUP = f$getjpi("", "CASE_LOOKUP_PERM")
$	    SET PROCESS/CASE_LOOKUP=BLIND
$	endif
$!
$	INSTALL_SERVER			= "FALSE"	! Don't install server by default
$	INSTALL_DOCS			= "FALSE,FALSE,FALSE,FALSE"
$	INSTALL_SRCS			= "FALSE,FALSE,FALSE"
$!
$	type sys$input


              SOAP Toolkit V1.1 Installation Procedure
             ------------------------------------------

Before installing this kit, please make sure that the following prerequisites
have been met.  If they have not been met, the installation procedure may be
unable to complete and may terminate:

	1) The installed operating system is OpenVMS Alpha V7.2-2 or later.
	2) Software Development Kit (SDK) for the Java Platform Version
	   1.3.1 (or higher) is installed, including any required OpenVMS
	   patches.
	3) An ODS-5 enabled disk is available and mounted.

If you wish to configure this system as a SOAP server, the following additional
prerequisites must be met:

	4) Secure Web Server (SWS) for OpenVMS Alpha V1.2 (or higher) is
	   installed.
	5) CSWS_JAVA for Secure Web Server for OpenVMS Alpha V2.0 (or
	   higher) is installed.
	6) CSWS_JAVA must have MOD_JK enabled (see the CSWS_JAVA release
	   notes for details).

	***********************************************************
				 Note
		Questions, where indicated, accept a response of
		 "H" to request additional Help and information.
	***********************************************************

$!
$       if f$search("SYS$COMMON:[JAVA*.COM]JAVA$*_SETUP.COM") .eqs. ""
$	then
$	    type/nopage sys$input

*******************************************************************
It appears that JAVA Version 1.3.1 or later has not been installed.

Please install JAVA Version 1.3.1 or later before invoking this
procedure.
*******************************************************************

$	    goto cleanup
$	endif
$!
$	TEMP = ""
$	define/nolog sys$output nl:
$	define/nolog sys$error  nl:
$	TEMP = jar
$	deas sys$output
$	deas sys$error
$	if TEMP .eqs. ""
$	then
$!
$! Attempt to startup Java using the most recent version.
$!
$	    next_java = ""
$!
$java_loop:
$!
$	    latest_java = next_java
$	    next_java = f$search("sys$common:[java$*.com]java$*_setup.com","1")
$	    if next_java .nes. "" then goto java_loop
$	    if latest_java .nes. ""
$	    then
$		ws "Invoking ''latest_java'"
$		@'latest_java
$	    else
$		ws ""
$		ws "Unable to locate the Java setup procedure."
$		ws "Please insure that Java 1.3.1 or higher is installed and/or invoke the"
$		ws "appropriate Java setup procedure for your installation prior to invoking"
$		ws "the SOAP installation procedure."
$	    endif
$       endif
$!
$	DEF_SOURCE = f$parse(f$env("PROCEDURE"),,,"DEVICE","SYNTAX_ONLY") +-
		     f$parse(f$env("PROCEDURE"),,,"DIRECTORY","SYNTAX_ONLY")
$	DEF_SOURCE = DEF_SOURCE - ".KIT]" + "]"
$	if f$extract(f$length(DEF_SOURCE)-1,1,DEF_SOURCE) .nes. "]"
$	then
$	    DEF_SOURCE = DEF_SOURCE + "]"
$	endif
$!
$GET_SOURCE_LOOP:
$!
$	if SOURCE .eqs. "" THEN SOURCE = DEF_SOURCE
$ 	INSTALL_FILE = SOURCE - "]" + ".KIT]SOAP-tools-bin-1_1.jar"
$	if f$search("''INSTALL_FILE'") .eqs. ""
$	then
$	    ws ""
$	    ws "Unable to locate ''INSTALL_FILE'."
$	    ws "Installation files not found."
$	    ws "
$	    ws "This installation procedure looks for required files in a directory relative to"
$	    ws "the location of the procedure.  This error can occur if the installation procedure"
$	    ws "is moved from its original location.  It can also occur if an update to the
$	    ws "procedure is released and it is not possible to replace the original, as would be"
$	    ws "the case if the original procedure is on a CD."
$	    ws ""
$	    ws "''SOURCE' is assumed to be the top level directory for the kit."
$	    ws "This directory should contain the KIT, SOURCES, EXAMPLES, and DOCUMENTATION"
$	    ws "subdirectories.  If this is incorrect, please enter the correct device"
$	    inquire/nopunct SOURCE "and directory [ ''DEF_SOURCE' ] : "
$	    goto GET_SOURCE_LOOP
$	endif
$!
$GET_TARGET_LOOP:
$!
$	ws ""
$   	ws "Please enter the ODS-5 target destination device and directory or logical name"
$	ws "indicating the location where you would like to install the SOAP kit."
$	DEF_DEST = f$parse(f$env("default"),"[000000]",,"DEVICE","SYNTAX_ONLY") + "[SOAP]"
$	inquire/nopunct DEST "This location will become the base directory for SOAP: (H) [ ''DEF_DEST' ] : "
$	Q = f$edit(DEST, "TRIM, UPCASE")
$	if f$extract(0,1,Q) .eqs. "H"
$	then
$	    gosub HELP_GET_DEST
$	    goto GET_TARGET_LOOP
$	endif
$	if DEST .eqs. "" then DEST = DEF_DEST
$	TARGET_DEV	= f$parse("''DEST'","[000000]",,"DEVICE","SYNTAX_ONLY")
$	TARGET_DIR	= f$parse("''DEST'","[000000]",,"DIRECTORY","SYNTAX_ONLY")
$	TARGET_DEST	= TARGET_DEV + TARGET_DIR
$	SOAP_ROOT_ND	= TARGET_DEST
$	SOAP_ROOT	= SOAP_ROOT_ND - "]" + ".]"
$	define/sys/nolog/trans=concealed SOAP$ROOT 'SOAP_ROOT
$!
$	set default 'TARGET_DEST
$	define/user sys$output nl:
$	define/user sys$error nl:
$	directory
$	status = $status
$	if status .eq. %X1001C04A
$	then
$	    ws ""
$	    ws "''Target_DEST' does not exist."
$	    inquire/nopunct ANS "Would you to create this directory? (Y, N) [Y] : "
$	    if ANS .eqs. "" then ANS = "Y"
$	    if ANS
$	    then
$		create/dir 'TARGET_DEST
$	    else
$		goto cleanup
$	    endif
$	endif
$!
$	ws ""
$	gosub GET_VOLUME_TYPE
$	VOLUME_TYPE = $status .AND 7
$	if VOLUME_TYPE .eq. 0
$	then
$	    ws "''TARGET_DEV' appears to be unavailable."
$	    goto GET_TARGET_LOOP
$	endif
$       if VOLUME_TYPE .eq. 2
$	then
$	    ws "''TARGET_DEV' appears to be an ODS-2 volume."
$	    ws "Because of long filenames and directory depth issues,
$	    ws "the installed code base may not function properly."
$	    ws ""
$	    inquire/nopunct ANS "Are you sure you want to install to this disk? (Y, N) [N] : "
$	    if ANS .eqs. "" .OR. .NOT. ANS then goto GET_TARGET_LOOP
$	    ws ""
$	endif
$!
$! Shortcuts for some commonly referenced directories.  This first 2 are read only.
$!
$! SOAP_KIT		 - Location of .jar files and miscellaneous installation files.
$!
$! SOAP_KIT_INSTALL_DEST - Storage for installation files.
$! SOAP_KIT_ORG_DEST	 - Storage for files modified by this installation.
$! SOAP_KIT_NEW_DEST	 - Storage for copies of new files created by this installation.
$! SOAP_KIT_DEST	 - Location when files will be installed.
$! SOAP_KIT_CONF	 - Same as SOAP_KIT_DEST, but unix style
$!
$       SOAP_KIT_SOURCE		= SOURCE
$       SOAP_KIT_DEST		= "SOAP$ROOT:[SOAP_Tools-1_1]"
$	SOAP_KIT_INSTALL_DEST	= SOAP_KIT_DEST   - "]" + ".install]"
$	SOAP_KIT_ORG_DEST	= SOAP_KIT_DEST   - "]" + ".org]"
$	SOAP_KIT_NEW_DEST	= SOAP_KIT_DEST   - "]" + ".new]"
$	SOAP_KIT_CONF		= "/SOAP$ROOT/SOAP_Tools-1_1/"
$!
$	SOAP_KIT_SOURCES	= SOAP_KIT_SOURCE - "]" + ".SOURCES]"
$	SOAP_KIT_EXAMPLES	= SOAP_KIT_SOURCE - "]" + ".EXAMPLES]"
$	SOAP_KIT_DOCS		= SOAP_KIT_SOURCE - "]" + ".DOCUMENTATION]"
$	SOAP_KIT		= SOAP_KIT_SOURCE - "]" + ".KIT]"
$!
$! Make sure the destination directories exist.  This may not be the case if installed
$! from CD or if installed in a different directory that it was extracted.
$!
$	create/dir/nolog/own=apache$www 'SOAP_KIT_DEST
$	create/dir/nolog 'SOAP_KIT_INSTALL_DEST
$	create/dir/nolog 'SOAP_KIT_ORG_DEST
$	create/dir/nolog 'SOAP_KIT_NEW_DEST
$	copy    'SOAP_KIT'STP.COM 'SOAP_KIT_DEST
$	copy    'SOAP_KIT'INSTALL_SOAP-1_1.COM,.TXT -
		    'SOAP_KIT_DEST
$	copy	'SOAP_KIT'UNINSTALL_SOAP-1_1.COM -
		SOAP$ROOT:[000000]
$	copy    'SOAP_KIT'DOC_DESCRIPS-1_1.TXT 'SOAP_KIT_INSTALL_DEST
$	copy    'SOAP_KIT'INDEX.HTML_TEMPLATE  'SOAP_KIT_INSTALL_DEST
$	copy    'SOAP_KIT'INDEX.HTML_TEMPLATE2 'SOAP_KIT_INSTALL_DEST
$	copy    'SOAP_KIT'SRC_DESCRIPS-1_1.TXT 'SOAP_KIT_INSTALL_DEST
$!
$! Determine if the SOAP server should be installed...
$!
$GET_SERVER:
$!
$	inquire/nopunc ANS "Would you like to install the SOAP Server support? (Y, N, H) [N] : "
$	Q = f$edit(ANS, "TRIM, UPCASE")
$	if f$extract(0,1,Q) .eqs. "H"
$	then
$	    gosub HELP_SERVER
$	    goto GET_SERVER
$	endif
$	INSTALL_SERVER = ANS
$       if INSTALL_SERVER
$       then
$	    OPTIONAL_DOCS   = "TRUE" ! 1 of 4
$	    MAX_DOCS	    = 4
$	    OPTIONAL_SRCS   = "TRUE,TRUE,TRUE"
$	    MAX_SRCS	    = 3
$	    !
$	    ! Make sure SWS and CSWS_JAVA have been installed.
$	    !
$	    if f$search("SYS$STARTUP:APACHE$STARTUP.COM") .eqs. ""
$	    then
$		ws ""
$		ws "*****************************************************************"
$		ws "It appears that SWS, The Secure Web Server for OpenVMS Alpha,"
$		ws "has not been installed.  Please install SWS and CSWS_JAVA"
$		ws "before installing the SOAP Tool Kit."
$		ws "*****************************************************************"
$		goto cleanup
$	    endif
$!
$	    temp = f$context("process", context, "prcnam", "APACHE$00", "eql")
$	    PID = f$pid(context)
$	    if PID .eqs. ""
$	    then
$		ws ""
$		ws "The Secure Web Server for OpenVMS Alpha, has not been started."
$		inquire/nopunc ANS "Would you like this procedure to start SWS? (Y, N) [Y] : "
$		if ANS .eqs. "" then ANS = "TRUE"
$		if ANS
$		then
$		    @SYS$STARTUP:APACHE$STARTUP.COM
$		    wait 0:0:5
$		    temp = f$context("process", context, "prcnam", "APACHE$00", "eql")
$		    PID = f$pid(context)
$		    if PID .eqs. ""
$		    then
$			ws ""
$			ws "*****************************************************************"
$			ws "It appears that the Secure Web Server for OpenVMS Alpha did not"
$			ws "start, possibly due to a configuration problem."
$                       ws "Please correct this before proceding with the SOAP installation."
$			ws "See APACHE$ROOT:[000000]apache$$server.log."
$			ws "*****************************************************************"
$			ws ""
$			goto cleanup
$		    endif
$		endif
$	    endif
$!   
$	    if f$trnlnm("APACHE$COMMON") .eqs. ""
$	    then
$		ws ""
$		ws "*****************************************************************"
$		ws "APACHE$COMMON is not defined.  This may indicate a configuration"
$		ws "problem in the Secure Web Server for OpenVMS Alpha."
$               ws "Please correct this before proceding with the SOAP installation."
$		ws "*****************************************************************"
$		ws ""
$		goto cleanup
$	    endif
$!
$! Determine the version of CSWS_JAVA that is installed.
$!
$	    define/user sys$output SYS$SCRATCH:SHOW_PROD.TXT
$	    prod show prod CSWS_JAVA
$	    open/read/error=open_in_error IN_FILE SYS$SCRATCH:SHOW_PROD.TXT
$	    CSWS_JAVA_VERSION = ""
$SP_LOOP:   read/end=SP_DONE IN_FILE record
$	    len = f$length(record)
$	    loc = f$locate("CSWS_JAVA V", record)
$	    if loc .ne. len
$	    then
$		CSWS_JAVA_VERSION = f$extract(loc+11, len, record)
$		CSWS_JAVA_VERSION = f$extract(0, f$locate(" ", CSWS_JAVA_VERSION), CSWS_JAVA_VERSION)
$		goto SP_DONE
$	    else
$		goto SP_LOOP
$	    endif
$SP_DONE:
$	    close IN_FILE
$	    delete/nolog SYS$SCRATCH:SHOW_PROD.TXT;
$!
$	    if CSWS_JAVA_VERSION .eqs. ""
$	    then
$		ws ""
$		ws "*****************************************************************"
$		ws "It appears that CSWS_JAVA has not been installed."
$		ws "Please install SWS and CSWS_JAVA before installing the SOAP Tool Kit."
$		ws "*****************************************************************"
$		goto cleanup
$	    endif
$!
$! Determine where CSWS_JAVA is installed.
$!
$	    define/user sys$output SYS$SCRATCH:SHOW_PROD.TXT
$	    product show object [apache.jakarta.*]/full
$	    open/read/error=open_in_error IN_FILE SYS$SCRATCH:SHOW_PROD.TXT
$	    TOMCAT_HOME = ""
$SP_LOOP2:  read/end=SP_DONE2 IN_FILE record
$	    record = f$edit(record, "TRIM, COMPRESS")
$	    if f$extract(0, 23, record) .nes. "[APACHE.JAKARTA.TOMCAT]" then goto SP_LOOP2
$	    TOMCAT_HOME		= f$element(3," ", record) - "]" + "APACHE.JAKARTA.TOMCAT]"
$	    TOMCAT_WEBAPPS	= TOMCAT_HOME - "]" + ".webapps]"
$	    TOMCAT_CONF		= TOMCAT_HOME - "]" + ".conf]"
$	    TOMCAT_COMMON_LIB	= TOMCAT_HOME - "]" + ".common.lib]"
$	    TOMCAT_SOAP_ADMIN	= TOMCAT_HOME - "]" + ".work.Standalone.localhost.soap.admin]"
$!
$SP_DONE2:  close IN_FILE
$	    delete/nolog SYS$SCRATCH:SHOW_PROD.TXT;
$	    if TOMCAT_HOME .eqs. ""
$	    then
$		ws ""
$		ws "*****************************************************************"
$		ws "Unable to determine the root directory where CSWS_JAVA is installed.
$		ws "*****************************************************************"
$		goto cleanup
$	    endif
$!
$	    ws ""
$GET_JS:    inquire/nopunc ANS "Would you like to install Java Scripting support? (Y, N, H) [N] : "
$	    Q = f$edit(ANS, "TRIM, UPCASE")
$	    if f$extract(0,1,Q) .eqs. "H"
$	    then
$		gosub HELP_JS
$		goto GET_JS
$	    endif
$!
$	    INSTALL_JS = ANS
$	    if INSTALL_JS
$	    then
$		OPTIONAL_DOCS = OPTIONAL_DOCS + ",TRUE,TRUE"
$	    else
$		OPTIONAL_DOCS = OPTIONAL_DOCS + ",FALSE,FALSE"
$	    endif
$!
$! Determine if we should restart TomCat.
$!
$GET_RESTART:
$	    ws ""
$	    ws "Upon completion of the installation, CSWS_JAVA should be restarted."
$	    ws "Would you like this procedure to restart CSWS_JAVA for you?"
$	    inquire/nopunct ANS "If you are not sure, enter H. (Y, N, H) [Y] : "
$	    Q = f$edit(ANS, "TRIM, UPCASE")
$	    if f$extract(0,1,Q) .eqs. "H"
$	    then
$		gosub HELP_RESTART
$		goto GET_RESTART
$	    endif
$	    RESTART_TOMCAT = ANS
$	    if RESTART_TOMCAT .eqs. "" then RESTART_TOMCAT = "TRUE"
$!
$! Set JSSE docs TRUE
$!
$	    OPTIONAL_DOCS = OPTIONAL_DOCS + ",TRUE"
$!
$! If not installing SOAP server, don't install JS, don't restart TomCat,
$! set optional documentation and sources accordingly.
$!
$	else
$	    INSTALL_JS	    = "FALSE"
$	    RESTART_TOMCAT  = "FALSE"
$	    OPTIONAL_DOCS   = "TRUE,FALSE,FALSE,FALSE"
$	    MAX_DOCS	    = 1
$	    OPTIONAL_SRCS   = "TRUE,FALSE,FALSE"
$	    MAX_SRCS	    = 1 
$	endif
$!
$!============================================================================ 
$!		    Determine Which Documentation to Install
$!============================================================================ 
$DETERMINE_DOC_FILES:
$!
$	LOCAL_DOCS_PRESENT	    = "FALSE"
$!
	type/nopage sys$input

  Documentation
------------------

The documentation included in the SOAP Toolkit consists of documentation
for SOAP itself (User's Guide and API reference) as well as documentation
for other components required to install SOAP.

Most documentation is in the form of HTML files, which you can serve locally
and/or access with a web browser.  Installing documentation is optional.
Even if you decide to install none of the documentation, it will still be
available to you online.  A web page with links to the local and online
documents will be provided.

You can choose to install all of the documentation, or none of it, or you can
select the documentation for specific components you would like to install.
$DDF10$:gosub SHOW_SELECTED_DOCS

$	if INSTALL_SERVER
$	then
$	    type/nopage sys$input

				Note
The Java Secure Socket Extension (JSSE) documentation is included and may
be installed, however, the JSSE binaries must be downloaded separately.
See the SOAP release notes for additional information.

$	endif
$	ws ""
$	ws "Enter:  1 through ''MAX_DOCS' - To toggle a selection"
$	type sys$input
	A	    - To select All documentation
	N	    - To select No  documentation
	Y	    - To proceed with the installation

$	QUES = "A, N, 1-''MAX_DOCS', or Y : "
$	inquire/nopunct ANS "''QUES'"
$	if ANS .eqs. "" then goto DETERMINE_DOC_FILES
$	if ANS .eqs. "Y" then goto DDF_DONE
$	if ANS .eqs. "N"
$	then 
$	    INSTALL_DOCS = "FALSE,FALSE,FALSE,FALSE"
$	    goto DDF10$
$	else
$	    if ANS .eqs. "A"
$	    then
$		INSTALL_DOCS = OPTIONAL_DOCS
$		goto DDF10$
$	    else
$		selection = f$integer(ANS)
$		if selection .lt. 1 .or. selection .gt. MAX_DOCS then goto DDF10$
$		count = 1
$		NEW_INSTALL_DOCS = ""
$DDF20$:	if count .eq. selection
$		then
$		    if f$element(selection-1, ",", INSTALL_DOCS) .eqs. "FALSE" .and. -
		       f$element(selection-1, ",", OPTIONAL_DOCS) .eqs. "TRUE"
$		    then
$			NEW_INSTALL_DOCS = NEW_INSTALL_DOCS + "TRUE"
$		    else
$			NEW_INSTALL_DOCS = NEW_INSTALL_DOCS + "FALSE"
$		    endif
$		else
$		    NEW_INSTALL_DOCS = NEW_INSTALL_DOCS + f$element(count-1, ",", INSTALL_DOCS)
$		endif
$		count = count + 1
$		if count .lt. 5
$		then
$		    NEW_INSTALL_DOCS = NEW_INSTALL_DOCS + ","
$		    goto DDF20$
$		endif
$		INSTALL_DOCS = NEW_INSTALL_DOCS
$		goto DDF10$
$	    endif
$	endif
$!
$DDF_DONE:
$	if f$trnlnm("APACHE$COMMON") .nes. "" .AND. -
	    INSTALL_DOCS .nes. "FALSE,FALSE,FALSE,FALSE"

$	then
$	    type/nopage sys$input

If you are planning to share documentation files with Secure Web
Server, it is recommended that you change the directory tree's
ownership for all documentation files to APACHE$WWW.
$!
$GET_OWNERSHIP:
$!
$	    ws ""
$	    inquire/nopunct ANS "Would you like this procedure to change the ownership for you? (Y, N, H) [Y] : "
$	    Q = f$edit(ANS, "TRIM, UPCASE")
$	    if f$extract(0,1,Q) .eqs. "H"
$	    then
$		gosub HELP_OWNERSHIP
$		goto GET_OWNERSHIP
$	    else
$		if ANS .eqs. "" THEN ANS = "TRUE"
$	    endif
$	    CHANGE_OWNERSHIP = ANS
$	else
$	    CHANGE_OWNERSHIP = "FALSE"
$	endif
$!
$!============================================================================ 
$!		    Determine Which Sources to Install
$!============================================================================ 
$DETERMINE_SRC_FILES:
$!
	type/nopage sys$input

  Sources
------------

The sources included in the SOAP Toolkit consist of source files that will
allow you to build SOAP itself, as well as sources for some of the associated
components required to install SOAP.

SOAP and the associated components are implemented entirely in Java.  It is not
necessary to install the sources or to build them.  The sources are provided
for those that may wish to build them in order to do development work in this
area.

You can choose to install all of the sources, or none of them, or you can
select the sources for specific components you would like to install.
$DSF10$:gosub SHOW_SELECTED_SRCS
$	ws ""
$	ws "Enter:  1 through ''MAX_SRCS' - To toggle a selection"
$	type/nopage sys$input
	A	    - To select All sources
	N	    - To select No  sources
	Y	    - To proceed with the installation

$	QUES = "A, N, 1-''MAX_SRCS', or Y : "
$	inquire/nopunct ANS "''QUES'"
$	if ANS .eqs. "" then goto DETERMINE_SRC_FILES
$	if ANS .eqs. "Y" then goto DSF_DONE
$	if ANS .eqs. "N"
$	then 
$	    INSTALL_SRCS = "FALSE,FALSE,FALSE"
$	    goto DSF10$
$	else
$	    if ANS .eqs. "A"
$	    then
$		INSTALL_SRCS = OPTIONAL_SRCS
$		goto DSF10$
$	    else
$		selection = f$integer(ANS)
$		if selection .lt. 1 .or. selection .gt. 4 then goto DSF10$
$		count = 1
$		NEW_INSTALL_SRCS = ""
$DSF20$:	if count .eq. selection
$		then
$		    if f$element(selection-1, ",", INSTALL_SRCS) .eqs. "FALSE" .and. -
		       f$element(selection-1, ",", OPTIONAL_SRCS) .eqs. "TRUE"
$		    then
$			NEW_INSTALL_SRCS = NEW_INSTALL_SRCS + "TRUE"
$		    else
$			NEW_INSTALL_SRCS = NEW_INSTALL_SRCS + "FALSE"
$		    endif
$		else
$		    NEW_INSTALL_SRCS = NEW_INSTALL_SRCS + f$element(count-1, ",", INSTALL_SRCS)
$		endif
$		count = count + 1
$		if count .lt. 8
$		then
$		    NEW_INSTALL_SRCS = NEW_INSTALL_SRCS + ","
$		    goto DSF20$
$		endif
$		INSTALL_SRCS = NEW_INSTALL_SRCS
$		goto DSF10$
$	    endif
$	endif
$!
$DSF_DONE:
$!
$	ws ""
$	ws "No further questions will be asked."
$	ws ""
$!
$!============================================================================ 
$!		    Install the binaries and samples
$!============================================================================ 
$INSTALL_BIN_FILES:
$!
$! Set JAVA$FILE_CONTROLS to preserve ODS-5 filenames.
$!
$	NEW_JAVA$FILENAME_CONTROLS = SAVED_JAVA$FILENAME_CONTROLS .AND. %XFFCFFFFF
$	define/nolog/job JAVA$FILENAME_CONTROLS 'NEW_JAVA$FILENAME_CONTROLS
$!
$       ws ""
$       ws "Installing binaries..."
$       ws "This will take a minute or so..."
$       ws ""
$       set def 'SOAP_ROOT_ND
$	jar xf 'SOAP_KIT'SOAP-tools-bin-1_1.jar
$!
$	set file/owner=apache$www SOAP$ROOT:[000000]SOAP-1_1.DIR
$	set file/owner=apache$www SOAP$ROOT:[000000]BSF-1_0.DIR
$	set file/owner=apache$www SOAP$ROOT:[000000]JS-1_1.DIR
$!
$       jar xf 'SOAP_KIT'SOAP-webapps-1_1.jar
$       ws "Installing example files..."
$       ws "	SOAP..."
$       jar xf 'SOAP_KIT_EXAMPLES'SOAP-samples-1_1.jar
$	if INSTALL_JS
$	then
$	    ws "	BSF..."
$	    jar xf 'SOAP_KIT_EXAMPLES'BSF-samples-1_0.jar
$	    ws "	JS..."
$	    jar xf 'SOAP_KIT_EXAMPLES'JS-samples-1_1.jar
$	endif
$       ws ""
$!
$!============================================================================ 
$!	Move files to the right places.
$!============================================================================ 
$!
$       if INSTALL_JS
$       then
$	    copy SOAP$ROOT:[BSF-1_0]bsf.jar   SOAP$ROOT:[SOAP-1_1.lib]
$	    copy SOAP$ROOT:[JS-1_1]js.jar    SOAP$ROOT:[SOAP-1_1.lib]
$	endif
$!
$	set file/owner=apache$www SOAP$ROOT:[SOAP-1_1...]*.*;*
$	set file/owner=apache$www SOAP$ROOT:[BSF-1_0...]*.*;*
$	set file/owner=apache$www SOAP$ROOT:[JS-1_1...]*.*;*
$!
$! Recommendation is that the web archive be places in webapps directory and
$! manually expanded.  It also needs to be exposed in servlet.xml to make it 
$! accessible.  Note that Tomcat will only expand the archive the first time
$! it is exposed.
$!
$	if INSTALL_SERVER
$	then
$	    ws "Installing SOAP web archive..."
$	    copy SOAP$ROOT:[SOAP-1_1.webapps]soap.war 'TOMCAT_WEBAPPS
$	    set file/owner=apache$www 'TOMCAT_WEBAPPS'soap.war
$	    WEBAPPS_SOAP_DIR = TOMCAT_WEBAPPS - "]" + ".soap]"
$	    WEBAPPS_SOAP_DIRE = WEBAPPS_SOAP_DIR - "]" + "...]"
$	    create/dir 'WEBAPPS_SOAP_DIR
$	    set def 'WEBAPPS_SOAP_DIR
$	    jar xf 'TOMCAT_WEBAPPS'soap.war
$	    set file/owner=apache$www 'WEBAPPS_SOAP_DIRE'*.*;*
$	    set def 'SOAP_ROOT_ND
$           ws ""
$	endif
$!
$!============================================================================ 
$!		    Install the Sources
$!============================================================================ 
$!
$	FIRST_SRC		    = "TRUE"
$       SOAP_OPENIN_FILE = SOAP_KIT + "SRC_DESCRIPS-1_1.TXT"
$	open/read/error=open_in_error IN_FILE 'SOAP_OPENIN_FILE
$	read/end=ISF_DONE IN_FILE record
$	count = 0
$ISF_LOOP:
$	read/end=ISF_DONE IN_FILE record
$	prod_name    = f$edit(f$element(0, ",", record),"TRIM")
$	prod_version = f$edit(f$element(1, ",", record),"TRIM")
$	src_jar_name = prod_name + "-src-" + prod_version + ".jar"
$	if f$element(count, ",", INSTALL_SRCS) .eqs. "TRUE"
$	then
$	    if FIRST_SRC
$	    then
$		ws ""
$		ws "Installing sources..."
$		FIRST_SRC = "FALSE"
$	    endif
$	    ws "	''prod_name'-''prod_version'"
$	    jar xf 'SOAP_KIT_SOURCES''src_jar_name
$	endif
$	count = count + 1
$	goto ISF_LOOP
$!
$ISF_DONE:
$!
$	close IN_FILE
$!
$!============================================================================ 
$!		    Install the Documentation
$!============================================================================ 
$!
$! Unpack the documents.  At the same time, create a SOAP_KIT.CONF to
$! contain alias commands so Apache can access the documents, and INDEX.HTML
$! to contain references to installed and online documentation.
$!
$!				Note
$! The target directory name and document jar file name are derived
$! from the records in DOC_DESCRIPS-1_1.TXT.
$!
$	FIRST_DOC		    = "TRUE"
$       SOAP_OPENIN_FILE = SOAP_KIT + "DOC_DESCRIPS-1_1.TXT"
$	open/read/error=open_in_error IN_FILE 'SOAP_OPENIN_FILE
$	read/end=IDF_DONE IN_FILE record
$	SOAP_OPENOUT_FILE = SOAP_KIT_DEST + "SOAP_KIT.CONF"
$	open/write/error=open_out_error CONF_FILE 'SOAP_OPENOUT_FILE
$	copy 'SOAP_KIT'INDEX.HTML_TEMPLATE 'SOAP_KIT_DEST'INDEX.HTML
$	SOAP_OPENOUT_FILE = SOAP_KIT_DEST + "index.html"
$	open/append/error=open_out_error HTML_FILE 'SOAP_OPENOUT_FILE
$	href      := <A HREF="""/soap/index.html""">
$	href       = href + "SOAP Applications Page</A>"
$	write HTML_FILE "<BR>"
$	write HTML_FILE href
$	write HTML_FILE "<BR>"
$	count = 0
$IDF_LOOP:
$	read/end=IDF_DONE IN_FILE record
$	prod_name    = f$edit(f$element(0, ",", record),"TRIM")
$	prod_version = f$edit(f$element(1, ",", record),"TRIM")
$	full_name    = f$edit(f$element(2, ",", record),"TRIM")
$	doc_dir_name = prod_name + "-" + prod_version
$	dir_el = 4
$IDFC_LOOP:
$	doc_dir_name = doc_dir_name + "/"
$	next_dir     = f$edit(f$element(dir_el, ",", record),"TRIM")
$	if next_dir .nes. ","
$	then
$	    doc_dir_name = doc_dir_name + next_dir
$	    dir_el = dir_el + 1
$	    goto IDFC_LOOP
$	endif
$	doc_jar_name = prod_name + "-docs-" + prod_version + ".jar"
$	if f$element(count, ",", INSTALL_DOCS) .eqs. "TRUE"
$	then
$	    if FIRST_DOC
$	    then
$		type/nopage sys$input

Aliases will be created for all documentation so that you can
reference the documentation using a URL in the form:

	http://<yourhost.yourdomain>/alias/

Note that links to all documentation are provided on the "soaptools"
page, so http://<yourhost.yourdomain>/soaptools/ may be the only alias
you need to make note of.

$		ws "Installing documentation and creating aliases..."
$		ws ""
$		write HTML_FILE "<P>"
$		write HTML_FILE "The following documentation can be found on this server:"
$		write HTML_FILE "<P>"
$		write HTML_FILE ""
$		write HTML_FILE "<UL>"
$		FIRST_DOC = "FALSE"
$		LOCAL_DOCS_PRESENT = "TRUE"
$	    endif
$!	    
$	    alias_dir  := "/SOAP$ROOT/''doc_dir_name'"
$	    alias_name := "''prod_name'docs"
$	    out_record = "	" + f$fao("!14AS", "''prod_name'-''prod_version'") + "alias: ''alias_name'"
$	    ws out_record
$	    jar xf 'SOAP_KIT_DOCS''doc_jar_name
$!
$	    href      := <LI><A HREF="""/''alias_name'/index.html""">
$	    href       = href + "''full_name'</A>"
$	    call WRITE_CONF_FILE "''alias_name'" "''alias_dir'"
$	    write HTML_FILE href
$	endif
$	count = count + 1
$	goto IDF_LOOP
$!
$IDF_DONE:
$!
$	close IN_FILE
$	ws ""
$	alias_dir  := "/SOAP$ROOT/SOAP_Tools-1_1/"
$	alias_name := "soaptools"
$	call WRITE_CONF_FILE "''alias_name'" "''alias_dir'"
$	ws "Added alias ''alias_name'"
$       close CONF_FILE
$	set file/own=APACHE$WWW SOAP$ROOT:[SOAP_Tools-1_1]SOAP_KIT.CONF
$!
$	if LOCAL_DOCS_PRESENT
$	then
$	    write HTML_FILE "</UL>"
$	    write HTML_FILE ""
$	endif
$	close HTML_FILE
$	append 'SOAP_KIT'INDEX.HTML_TEMPLATE2 'SOAP_KIT_DEST'index.html
$	ws ""
$	ws "The file ''SOAP_KIT_DEST'index.html has been created."
$	ws "This page describes the available SOAP documentation."
$	ws "You may want to create a link to this page in the form:"
$	ws ""
$	ws "  http://<yourhost.yourdomain>/soaptools/index.html"
$	ws ""
$!
$	ws ""
$	ws "The file ''SOAP_KIT_DEST'SOAP_KIT.CONF has been created."
$	ws "This file provides aliases and access information for Apache."
$	ws "You may want to modify the access rights."
$	ws ""
$	if f$search("APACHE$COMMON:[CONF]HTTPD.CONF") .nes. ""
$	then
$	    record = "Include ''SOAP_KIT_CONF'SOAP_KIT.CONF"
$	    define/user sys$output nl:
$	    define/user sys$error nl:
$	    sea APACHE$COMMON:[CONF]HTTPD.CONF "''record'"
$	    sea_status = $status
$	    if sea_status .eq. %X08D78053	! NOMATCHES
$	    then
$		copy APACHE$COMMON:[CONF]HTTPD.CONF 'SOAP_KIT_ORG_DEST	! Save original
$		copy APACHE$COMMON:[CONF]HTTPD.CONF APACHE$COMMON:[CONF];	! Create new version
$		SOAP_OPENOUT_FILE = "APACHE$COMMON:[CONF]HTTPD.CONF"
$		open/append/error=open_out_error CONF_FILE 'SOAP_OPENOUT_FILE
$		write CONF_FILE "Include ''SOAP_KIT_CONF'SOAP_KIT.CONF"
$		close CONF_FILE
$		copy APACHE$COMMON:[CONF]HTTPD.CONF 'SOAP_KIT_NEW_DEST	! Save new
$		ws "Include ''SOAP_KIT_CONF'SOAP_KIT.CONF has been appended to"
$		ws "APACHE$COMMON:[CONF]HTTPD.CONF"
$	    else
$		ws ""
$		ws "It appears that APACHE$COMMON:[CONF]HTTPD.CONF"
$		ws "has already been updated."
$		ws ""
$	    endif
$	else
$	    ws "*****************************************************"
$	    ws "Unable to locate APACHE$COMMON:[CONF]HTTPD.CONF."
$	    ws "Please add the following line to the end of this file"
$	    ws "so that Apache can access the documentation files:"
$	    ws ""
$	    ws "     Include ''SOAP_KIT_CONF'SOAP_KIT.CONF"
$	    ws ""
$	    ws "*****************************************************"
$	    ws ""
$	    INQUIRE ANS "Press the <Enter> key to continue"
$	endif
$!
$!============================================================================ 
$!	Update SERVER.XML to expose the SOAP.WAR file to Apache.
$!============================================================================ 
$!
$       if INSTALL_SERVER
$       then
$	    SOAP_OPENIN_FILE = "''TOMCAT_CONF'server.xml"
$	    SOAP_OPENOUT_FILE = "''TOMCAT_CONF'server.xml_new"
$	    ws ""
$	    ws "Updating ''SOAP_OPENIN_FILE'"
$	    CONTEXT_ADDED = "FALSE"
$	    open/read/error=open_in_error IN_FILE 'SOAP_OPENIN_FILE
$	    open/write/error=open_out_error OUT_FILE 'SOAP_OPENOUT_FILE
$XML_LOOP:  read/end=XML_DONE IN_FILE record
$	    if f$locate("Added for SOAP", record) .ne. f$length(record)
$	    then
$		close IN_FILE
$		close OUT_FILE
$		delete/nolog 'SOAP_OPENOUT_FILE';
$		ws ""
$		ws "It appears that ''SOAP_OPENIN_FILE'"
$		ws "has already been updated."
$		ws ""
$		goto XML_EXIT
$	    endif
$!
$	    if .NOT. CONTEXT_ADDED
$	    then
$		if f$locate("</Context>", record) .ne. f$length(record)
$		then
$		    write OUT_FILE record
$		    write OUT_FILE ""
$		    write OUT_FILE "<!-- Added for SOAP -->"
$		    write OUT_FILE ""
$		    write OUT_FILE "         <Context path=""/soap"" docBase=""soap.war"" debug=""0"""
$		    write OUT_FILE "               reloadable=""true"" crossContext=""true"">"
$		    write OUT_FILE "         <Listener className=""org.apache.ajp.tomcat4.config.ApacheConfig"""
$		    write OUT_FILE "               append=""true"" />"
$		    write OUT_FILE "         <Logger className=""org.apache.catalina.logger.FileLogger"""
$		    write OUT_FILE "                   prefix=""localhost_soap_log."" suffix="".txt"""
$		    write OUT_FILE "               timestamp=""true""/>"
$		    write OUT_FILE "        </Context>"
$		    write OUT_FILE ""
$		    CONTEXT_ADDED = "TRUE"
$		    goto XML_LOOP
$		endif
$	    endif
$	    write OUT_FILE record
$	    goto XML_LOOP
$!
$XML_DONE:  close IN_FILE
$	    close OUT_FILE
$	    ws ""
$	    ws "The following changes have been made to:
$	    ws ""
$	    ws "	''SOAP_OPENIN_FILE'"
$	    ws ""
$	    copy 'SOAP_OPENIN_FILE 'SOAP_KIT_ORG_DEST	! Save original
$	    rename/nolog 'SOAP_OPENOUT_FILE .xml
$	    copy 'SOAP_OPENIN_FILE 'SOAP_KIT_NEW_DEST	! Save new
$	    set prot:w:re 'SOAP_OPENIN_FILE
$	    diff/match=20 'SOAP_OPENIN_FILE
$	    ws ""
$	endif
$!
$XML_EXIT:
$!
$!============================================================================ 
$!		    Fix up file access
$!============================================================================ 
$!
$!	See SYS$MANAGER:APACHE$CONFIG.COM
$!
$	if .not. CHANGE_OWNERSHIP then goto FUFA_DONE
$	ws ""
$	ws "Setting file ownership to APACHE$WWW..."
$	out_record = "	" + f$fao("!14AS", "SOAP_Tools-1_1")
$	ws out_record
$	set file/own=APACHE$WWW SOAP$ROOT:[000000]SOAP_Tools-1_1.DIR
$	set file/own=APACHE$WWW SOAP$ROOT:[SOAP_Tools-1_1]index.html
$!
$	out_record = "	" + f$fao("!14AS", "SOAP-1_1") + "webapps"
$	ws out_record
$!
$       SOAP_OPENIN_FILE = SOAP_KIT + "DOC_DESCRIPS-1_1.TXT"
$	open/read/error=open_in_error IN_FILE 'SOAP_OPENIN_FILE
$	read/end=FUFA_DONE IN_FILE record
$	count = 0
$FUFA_LOOP:
$	read/end=FUFA_EOF IN_FILE record
$	if f$element(count, ",", INSTALL_DOCS) .eqs. "TRUE"
$	then
$	    prod_name    = f$edit(f$element(0, ",", record),"TRIM")
$	    prod_version = f$edit(f$element(1, ",", record),"TRIM")
$	    prod_name_vers = prod_name + "-" + prod_version
$	    out_record = "	" + f$fao("!14AS", "''prod_name_vers'") + "documents"
$	    ws out_record
$	    doc_dir_name = prod_name_vers
$	    dir_el = 4
$FUFA_LOOP2:
$	    next_dir     = f$edit(f$element(dir_el, ",", record),"TRIM")
$	    if next_dir .nes. ","
$	    then
$		target = "SOAP$ROOT:[''doc_dir_name']''next_dir'.DIR"
$		set file/own=APACHE$WWW 'target
$		doc_dir_name = doc_dir_name + "." + next_dir
$		target = "SOAP$ROOT:[''doc_dir_name'...]
$		set file/own=APACHE$WWW 'target'*.*;*
$		dir_el = dir_el + 1
$		goto FUFA_LOOP2
$	    endif
$	endif
$	count = count + 1
$	goto FUFA_LOOP
$!
$FUFA_EOF:
$	close IN_FILE
$FUFA_DONE:
$!
$!============================================================================ 
$!		    Create a file to define java$classpath
$!============================================================================ 
$!
$	SOAP_OPENOUT_FILE = "''SOAP_KIT_DEST'Soap-1_1_SetClassPath.com"
$	open/write OUT_FILE 'SOAP_OPENOUT_FILE
$	write OUT_FILE "$ saved_verify = f$verify(f$trnlnm(""soap_set_class_path$verify""))"
$	write OUT_FILE "$!"
$	write OUT_FILE "$! Command procedure to add SOAP paths to JAVA$CLASSPATH"
$	write OUT_FILE "$!"
$	write OUT_FILE "$! Previous class path is saved in OLD_JAVA$CLASSPATH logical"
$	write OUT_FILE "$! for subsequent RESTORE."
$	write OUT_FILE "$!"
$	write OUT_FILE "$! Additional class paths can be specified on the command line."
$	write OUT_FILE "$!"
$	write OUT_FILE "$!	P1  if ""RESTORE"" then restore old class path"
$	write OUT_FILE "$!	    if string, then add string to new classpath"
$	write OUT_FILE "$!"
$	write OUT_FILE "$ SAVED_PARSE_STYLE   = f$getjpi("""", ""PARSE_STYLE_PERM"")"
$	write OUT_FILE "$ SET PROCESS/PARSE_STYE=EXTENDED"
$	write OUT_FILE "$ OS = f$edit(f$getsyi(""VERSION""),""COLLAPSE"")"
$	write OUT_FILE "$ if OS .ges. ""V7.3-1""		! set proc/case is not in V7.3"
$	write OUT_FILE "$ then"
$	write OUT_FILE "$    SAVED_CASE_LOOKUP = f$getjpi("""", ""CASE_LOOKUP_PERM"")"
$	write OUT_FILE "$    SET PROCESS/CASE_LOOKUP=BLIND"
$	write OUT_FILE "$ else"
$	write OUT_FILE "$    SAVED_CASE_LOOKUP		= """"
$	write OUT_FILE "$ endif"
$	write OUT_FILE "$!"
$	write OUT_FILE "$ if P1 .eqs. ""RESTORE"""
$	write OUT_FILE "$ then"
$	write OUT_FILE "$     if f$trnlnm(""OLD_JAVA$CLASSPATH"") .eqs. """""
$	write OUT_FILE "$     then"
$	write OUT_FILE "$         deas JAVA$CLASSPATH"
$	write OUT_FILE "$     else"
$	write OUT_FILE "$         define/nolog JAVA$CLASSPATH 'f$trnlnm(""OLD_JAVA$CLASSPATH"")"
$	write OUT_FILE "$	  deas/sys OLD_JAVA$CLASSPATH"
$	write OUT_FILE "$     endif"
$	write OUT_FILE "$     goto cleanup"
$	write OUT_FILE "$ endif"
$	write OUT_FILE "$!"
$	write OUT_FILE "$ java_classpath = ""''TOMCAT_COMMON_LIB'xerces.jar"""
$	write OUT_FILE "$ java_classpath = java_classpath + "","" + ""SOAP$ROOT:[soap-1_1.lib]soap.jar"""
$	write OUT_FILE "$ java_classpath = java_classpath + "","" + ""''TOMCAT_COMMON_LIB'activation.jar"""
$	write OUT_FILE "$ java_classpath = java_classpath + "","" + ""''TOMCAT_COMMON_LIB'mail.jar"""
$	if INSTALL_JS
$	then
$	    write OUT_FILE "$ java_classpath = java_classpath + "","" + ""SOAP$ROOT:[soap-1_1.lib]js.jar"""
$	    write OUT_FILE "$ java_classpath = java_classpath + "","" + ""SOAP$ROOT:[soap-1_1.lib]bsf.jar"""
$	endif
$	write OUT_FILE "$ CUR_DEFAULT = f$env(""default"")"
$	write OUT_FILE "$ java_classpath = java_classpath + "","" + ""'CUR_DEFAULT"""
$	write OUT_FILE "$!"
$	write OUT_FILE "$ if P1 .nes. """""
$	write OUT_FILE "$ then"
$	write OUT_FILE "$   java_classpath = java_classpath + "","" + ""'P1"""
$	write OUT_FILE "$ endif"
$	write OUT_FILE "$!"
$	write OUT_FILE "$ if f$trnlnm(""JAVA$CLASSPATH"") .eqs. """""
$	write OUT_FILE "$ then"
$	write OUT_FILE "$     define/nolog JAVA$CLASSPATH 'java_classpath"
$	write OUT_FILE "$ else"
$	write OUT_FILE "$     define/nolog OLD_JAVA$CLASSPATH 'f$trnlnm(""JAVA$CLASSPATH"")"
$	write OUT_FILE "$     define/nolog JAVA$CLASSPATH 'f$trnlnm(""JAVA$CLASSPATH""), 'java_classpath"
$	write OUT_FILE "$ endif"
$	write OUT_FILE "$!"
$	write OUT_FILE "$cleanup:"
$	write OUT_FILE "$!"
$	write OUT_FILE "$ if SAVED_PARSE_STYLE .nes. """"
$	write OUT_FILE "$ then"
$	write OUT_FILE "$    SET PROCESS/PARSE_STYE='SAVED_PARSE_STYLE"
$	write OUT_FILE "$ endif"
$	write OUT_FILE "$ if SAVED_CASE_LOOKUP .nes. """"
$	write OUT_FILE "$ then"
$	write OUT_FILE "$    SET PROCESS/CASE_LOOKUP='SAVED_CASE_LOOKUP"
$	write OUT_FILE "$ endif"
$	write OUT_FILE "$!"
$	write OUT_FILE "$ scratch = f$verify(saved_verify)"
$	write OUT_FILE "$ exit"
$	close OUT_FILE
$!
$	ws ""
$	ws "The file ''SOAP_OPENOUT_FILE' has been created."
$	ws "This file is needed to run the SOAP Test Procedure."
$	ws "It may also be useful to retain for your own SOAP applications"
$!
$!
$!============================================================================ 
$!	Create or Update APACHE$ROOT:[000000].TOMCATRC
$!============================================================================ 
$!
$	CREATE_TOMCATRC = "FALSE"
$	TOMCATRC_MERGE_NEEDED = "FALSE"
$	if f$search("APACHE$ROOT:[000000].TOMCATRC") .eqs. ""
$	then
$	    CREATE_TOMCATRC = "TRUE"
$	    SOAP_OPENOUT_FILE = "APACHE$ROOT:[000000].TOMCATRC"
$	    open/write/error=open_out_error TC_FILE 'SOAP_OPENOUT_FILE
$	else
$	    define sys$output nl:
$	    define sys$error  nl:
$	    search APACHE$ROOT:[000000].TOMCATRC APACHE$JAKARTA_USER_CLASSPATH
$	    deas sys$output
$	    deas sys$error
$	    if $status .EQ. 1 then TOMCATRC_MERGE_NEEDED = "TRUE"
$	    copy/nolog APACHE$ROOT:[000000].TOMCATRC 'SOAP_KIT_ORG_DEST   ! Save original
$	    copy/nolog APACHE$ROOT:[000000].TOMCATRC APACHE$ROOT:[000000];  ! Create new version
$	    SOAP_OPENOUT_FILE = "APACHE$ROOT:[000000].TOMCATRC"
$	    open/append/error=open_out_error TC_FILE 'SOAP_OPENOUT_FILE
$	    write TC_FILE "$!"
$	    write TC_FILE "$! Added for SOAP"
$	endif
$!
$	write TC_FILE "$!"
$	write TC_FILE "$ xerces_path	    := ''TOMCAT_COMMON_LIB'xerces.jar"
$	write TC_FILE "$ servlet_path	    := ''TOMCAT_COMMON_LIB'servlet.jar"
$	write TC_FILE "$ soap_path	    := SOAP$ROOT:[SOAP-1_1.lib]soap.jar"
$	write TC_FILE "$ soap_admin_path   := ''TOMCAT_SOAP_ADMIN'"
$	write TC_FILE "$ act_path	    := ''TOMCAT_COMMON_LIB'activation.jar"
$	write TC_FILE "$ mail_path	    := ''TOMCAT_COMMON_LIB'mail.jar"
$	if INSTALL_JS
$	then
$	    write TC_FILE "$ js_path	    := SOAP$ROOT:[SOAP-1_1.lib]js.jar"
$	    write TC_FILE "$ bsf_path	    := SOAP$ROOT:[SOAP-1_1.lib]bsf.jar"
$	endif
$	write TC_FILE "$ DEFINE APACHE$JAKARTA_USER_CLASSPATH -"
$	write TC_FILE "	'xerces_path,'servlet_path,-"
$	write TC_FILE "	'soap_path,'soap_admin_path,'act_path,'mail_path,-"
$	if INSTALL_JS then write TC_FILE "	'js_path,'bsf_path,-"
$	write TC_FILE "	SOAP$ROOT:[SOAP-1_1]
$	close TC_FILE
$       copy/nolog APACHE$ROOT:[000000].TOMCATRC 'SOAP_KIT_NEW_DEST   ! Save new
$!
$	ws ""
$	if CREATE_TOMCATRC
$	then
$	    ws "APACHE$ROOT:[000000].TOMCATRC has been created."
$	else
$	    ws "The following changes were made to APACHE$ROOT:[000000].TOMCATRC:"
$	    diff/match=20 APACHE$ROOT:[000000].TOMCATRC
$	    if TOMCATRC_MERGE_NEEDED
$	    then
$		ws ""
$		ws "The APACHE$JAKARTA_USER_CLASSPATH definition needs to be merged"
$		ws "with the previous definition of APACHE$JAKARTA_USER_CLASSPATH."
$		ws ""
$		ws "Please take a moment to merge these changes before CSWS_JAVA is"
$		ws "restarted."
$		ws ""
$	    endif	    
$	endif
$!
$!
$!============================================================================ 
$!		    Restart TOMCAT to create new webapps aliases
$!============================================================================ 
$!
$	if RESTART_TOMCAT
$	then
$cut_loop:  ws ""
$	    if TOMCATRC_MERGE_NEEDED
$	    then
$		inquire/nopunct ANS "Are you ready to restart CSWS_JAVA? (Y, N) [N] : "
$		if .not ANS then goto cut_loop
$	    endif
$	    ws ""
$	    call restart_tomcat
$	    ws ""
$	else
$!
$	    type/nopage sys$input

    You should manually restart CSWS_JAVA, then manually restart SWS
    before you access the SOAP web application.  To restart CSWS_JAVA,
    enter the following commands:

            $ @SYS$STARTUP:APACHE$JAKARTA_SHUTDOWN
            $ @SYS$STARTUP:APACHE$JAKARTA_STARTUP

    To restart SWS, enter the following command:

	    $ @SYS$STARTUP:APACHE$STARTUP GRACEFUL

    Be sure to wait for CSW_JAVA to be fully started (APACHE$TOMCAT process
    will enter the HIB state) before restarting SWS.

$	endif
$!
$!		    Restart SWS to load new aliases
$!============================================================================ 
$!
$	ws ""
$	ws "Performing graceful restart of SWS..."
$	@sys$startup:apache$startup GRACEFUL
$!
$	type/nopage sys$input

SOAP Toolkit V1.1 Installation complete.

--------------------------------------------------------------------------
    SOAP$ROOT has been defined.  The following line must be added to
    SYS$MANAGER:SYLOGICALS.COM so that it will be defined each time the
    system is rebooted.  Failure to do so will prevent SWS from starting.

$	ws "      $ define/sys/nolog/trans=concealed SOAP$ROOT ''SOAP_ROOT'"
$	type/nopage sys$input
--------------------------------------------------------------------------

$	INQUIRE ANS "Press the <Enter> key to continue"
$	type/nopage sys$input

 Post Installation Checkout
----------------------------

Point your browser to the following URL:

	http://<yourhost.yourdomain>/soaptools/

You should find a list of links to the documentation you elected to install,
as well as links to external documentation that was available at the time
this kit was packaged (these may require updating over time).

At the top of the page is a link to the SOAP applications page.  Here you will
find two more links.  Click on the "Visit the SOAP RPC router URL for this
SOAP server" link.  It should respond with:

"Sorry, I don't speak via HTTP GET - you have to use HTTP POST to talk to me."

This is normal and expected.

Now go back and click on the "Run the Admin client" link.  It should display
"List", "Deploy", and "Un-deploy" options.  Selecting "List" should show that
there are no currently deployed services.

$	type/nopage sys$input

Further verification of the installation can be performed using the SOAP
Test Procedure, which will deploy several services.  This procedure,
however, requires manual intervention and therefore will not be run
automatically.

To run the SOAP Test Procedure, enter the following command:

$	ws "	$ @SOAP$ROOT:[SOAP_Tools-1_1]STP [<host.domain>] [<proxy:port>] [<testname>]"
$	ws ""
$	ws "or enter the following command for additional information:"
$	ws ""
$	ws "	$ @SOAP$ROOT:[SOAP_Tools-1_1]STP ?"
$	ws ""
$	ws "Should you wish to remove the SOAP Toolkit, enter the following command:"
$	ws ""
$	ws "	@SOAP$ROOT:[000000]UNINSTALL_SOAP-1_1"
$	ws ""
$!
$cleanup:
$!
$	if SAVED_JAVA$FILENAME_CONTROLS .nes. ""
$	then
$	    define/nolog/job JAVA$FILENAME_CONTROLS 'SAVED_JAVA$FILENAME_CONTROLS
$	else
$	    define/user sys$output nl:
$	    define/user sys$error nl:
$	    deas/job JAVA$FILENAME_CONTROLS
$	endif
$       if SAVED_PARSE_STYLE .nes. ""
$	then
$	    SET PROCESS/PARSE_STYE='SAVED_PARSE_STYLE
$	endif
$!
$	if SAVED_CASE_LOOKUP .nes. ""
$	then
$	    SET PROCESS/CASE_LOOKUP='SAVED_CASE_LOOKUP
$	endif
$	if SAVED_CASE_PRESERVE .nes. ""
$	then
$	    define/nolog DECC$EFS_CASE_PRESERVE 'SAVED_CASE_PRESERVE
$	else
$	    if f$trnlnm("DECC$EFS_CASE_PRESERVE") .nes. "" then deas DECC$EFS_CASE_PRESERVE
$	endif
$	if SAVED_CASE_SPECIAL .nes. ""
$	then
$	    define/nolog DECC$EFS_CASE_SPECIAL 'SAVED_CASE_SPECIAL
$	else
$	    if f$trnlnm("DECC$EFS_CASE_SPECIAL") .nes. "" then deas DECC$EFS_CASE_SPECIAL
$	endif
$	if SAVED_EFS_CHARSET .nes. ""
$	then
$	    define/nolog DECC$EFS_CHARSET 'SAVED_EFS_CHARSET
$	else
$	    if f$trnlnm("DECC$EFS_CHARSET") .nes. "" then deas DECC$EFS_CHARSET
$	endif
$!
$	if f$trnlnm("IN_FILE")    .nes. "" then close IN_FILE
$	if f$trnlnm("OUT_FILE")   .nes. "" then close OUT_FILE
$	if f$trnlnm("CONF_FILE")  .nes. "" then close CONF_FILE
$	if f$trnlnm("HTML_FILE")  .nes. "" then close HTML_FILE
$	set default 'saved_default
$	scratch = f$verify(saved_verify)
$	exit
$!
$open_out_error:
$	ws ""
$	ws "Error opening output file ''SOAP_OPENOUT_FILE'"
$	ws ""
$	define/user sys$output nl:
$	define/user sys$error nl:
$	delete/sym/global SOAP_OPENOUT_FILE
$	goto cleanup
$!
$open_in_error:
$	ws ""
$	ws "Error opening input file ''SOAP_OPENIN_FILE'"
$	ws ""
$	define/user sys$output nl:
$	define/user sys$error nl:
$	delete/sym/global SOAP_OPENIN_FILE
$	goto cleanup
$!
$!----------------------------------------------------------------------------
$!
$! Subroutine to display a list of documentation selected for installation.
$!
$!	INSTALL_DOCS		List of boolean expressions indicating which
$!				documents are selected.
$!	OPTIONAL_DOCS		List of boolean expressions indicating which
$!				document are allowed for this installation
$!				(client or server).
$!	DOC_DESCRIPS-1_1.TXT    File containing records corresponding to the
$!				above list.
$!
$!----------------------------------------------------------------------------
$SHOW_SELECTED_DOCS:
$!
$	count = 0
$       SOAP_OPENIN_FILE == SOAP_KIT + "DOC_DESCRIPS-1_1.TXT"
$	open/read/error=open_in_error IN_FILE 'SOAP_OPENIN_FILE
$	read/end=ssd_done IN_FILE record
$	ws ""
$	ws "    -----------------------------------------------------------------"
$ssd_loop:
$	read/end=ssd_done IN_FILE record
$	doc_name = f$element(2, ",", record)
$	doc_size = f$element(3, ",", record)
$	count = count + 1
$	if f$element(count-1, "," ,INSTALL_DOCS) .eqs. "TRUE"
$	then output_record = "x"
$	else output_record = " "
$	endif
$	if f$element(count-1, "," ,OPTIONAL_DOCS) .eqs. "TRUE"
$	then 
$	    output_record = "      ''count'.    [" + output_record + "]   " + doc_name + "  ~" + doc_size + " blocks"
$	    ws output_record
$	endif
$	goto ssd_loop
$!
$ssd_done:
$!
$	ws "    -----------------------------------------------------------------"
$	ws "	    [x] = Selected,  [ ] = Not Selected"
$	close IN_FILE
$	return
$!
$!----------------------------------------------------------------------------
$!
$! Subroutine to display a list of sources selected for installation.
$!
$!	INSTALL_SRCS		List of boolean expressions indicating which
$!				sources are selected.
$!	OPTIONAL_SRCS		List of boolean expressions indicating which
$!				sources are allowed for this installation
$!				(client or server).
$!	SRC_DESCRIPS-1_1.TXT    File containing records corresponding to the
$!				above list.
$!
$!----------------------------------------------------------------------------
$SHOW_SELECTED_SRCS:
$!
$	count = 0
$       SOAP_OPENIN_FILE == SOAP_KIT + "SRC_DESCRIPS-1_1.TXT"
$	open/read/error=open_in_error IN_FILE 'SOAP_OPENIN_FILE
$	read/end=sss_done IN_FILE record
$	ws ""
$	ws "    -----------------------------------------------------------------"
$sss_loop:
$	read/end=sss_done IN_FILE record
$	src_name = f$element(2, ",", record)
$	src_size = f$element(3, ",", record)
$	count = count + 1
$	if f$element(count-1, "," ,INSTALL_SRCS) .eqs. "TRUE"
$	then output_record = "x"
$	else output_record = " "
$	endif
$	if f$element(count-1, "," ,OPTIONAL_SRCS) .eqs. "TRUE"
$	then 
$	    output_record = "      ''count'.    [" + output_record + "]   " + src_name + "  ~" + src_size + " blocks"
$	    ws output_record
$	endif
$	goto sss_loop
$!
$sss_done:
$!
$	ws "    -----------------------------------------------------------------"
$	ws "	    [x] = Selected,  [ ] = Not Selected"
$	close IN_FILE
$	return
$!
$GET_VOLUME_TYPE:
$!
$	GVT = 0
$	TEMP_FILE = "SYS$SCRATCH:ISSHDEV.TMP"
$	NOMATCHES = %X08D78053
$	show dev 'TARGET_DEV'/FULL/OUTPUT='TEMP_FILE
$	if ($status .AND. 1) .EQ. 1
$	then
$	    define sys$output nl:
$	    define sys$error  nl:
$	    search 'TEMP_FILE "ODS-5"
$	    if $status .EQ. 1
$	    then
$		ws "GVT = 5"
$		GVT = 5
$	    else
$		search 'TEMP_FILE "ODS-2"
$		if $status .EQ. 1
$		then
$		    ws "GVT = 2"
$		    GVT = 2
$		endif
$	    endif
$	    deas sys$output
$	    deas sys$error
$	endif
$	if f$search("''TEMP_FILE'") .nes. ""
$	then delete/nolog 'TEMP_FILE';
$	endif
$	return (GVT .OR. %X10000000)
$!
$!----------------------------------------------------------------
$HELP_SERVER:
$!
$	type/nopage sys$input

    SOAP software may be installed as a client, so that you can access
    SOAP services services provided by a SOAP server, or the SOAP
    software may be installed to as a SOAP server to provide services.

    Answer "Y" to install the SOAP client and server support.  Answer
    "N" to install only the SOAP client support.

    Installing SOAP server support requires The Secure Web Server for
    OpenVMS Alpha V1.1-1 or later, and CSWS_JAVA for Secure Web Server
    for OpenVMS Alpha V1.0 or later.

    If you elect to install the SOAP server support, you will be asked
    additional questions regarding scripting and secure socket
    support.

$	return

$!
$!----------------------------------------------------------------
$HELP_JS:
$!
$	type/nopage sys$input

    If you are installing SOAP software as a SOAP server, you may wish
    to implement services using scripting languages.  To implement
    these services, additional support is installed consisting of Bean
    Scripting Framework (BSF) and JavaScript.

    Answer "Y" to install BSF and JavaScript.  Answer "N" to skip the
    installation of BSF and JavaScript.

$	return

$!
$!----------------------------------------------------------------
$HELP_OWNERSHIP:
$!
$	type/nopage sys$input

    Documentation for the SOAP Tool Kit is installed using the default
    ownership, i.e., all files will be owned by the installing process,
    presumably SYSTEM.  The Secure Web Server (SWS) requires that all
    html files be owner by APACHE$WWW.

    If you want to be able to serve the documentation pages using SWS,
    then answer "Y" to set the file ownership.  Answer "N" to skip the
    setting of the file ownership.

$	return
$!
$!----------------------------------------------------------------
$HELP_GET_DEST:
$!
$	type/nopage sys$input

    The target destination can be a device and/or directory specification,
    or a logical name pointing to a device and/or directory, or combination
    thereof.  Examples:

	  $6$DKA100:, [MY_SOAP_DIRECTORY], WORK$:[WEB_APPLICATIONS]

    If only the device is specified, the directory trees for the installation
    will be created in the top level directory on that device.  If only the
    directory is specified, the directory trees for the installation will be
    created in that directory on the default device for the current process.

    In all cases, the target destination should reside on an ODS-5 device.
    If installed on an ODS-2 device, some documentation files may be
    inaccessible and source code may not compile.

$	return
$!
$!----------------------------------------------------------------
$HELP_RESTART:
$!
$	type/nopage sys$input

    Upon completion of the installation, CSWS_JAVA must be shutdown
    momentarily and restarted in order to create aliases to make the
    SOAP web application accessible.  Secure Web Server (SWS) must
    be restarted to pick up both the webapps and documentation
    aliases.  SWS can be restarted without interruption of service
    and will always be restarted.

    If you choose Yes, CSWS_JAVA and SWS will be restarted automatically
    and both documentation and webapps aliases will be picked up.

    If you choose No, only SWS will be restarted and only the documentation
    aliases will be picked up.  You will be provided with instructions
    describing how to restart both CSWS_JAVA and SWS at the end of
    installation to pick up the webapps alias.

$	return
$!
$!----------------------------------------------------------------
$WRITE_CONF_FILE: SUBROUTINE
$!
$	alias_dir = "''P2'"
$	write CONF_FILE "Alias /''P1'/ " + """''alias_dir'"""
$       write CONF_FILE ""
$       write CONF_FILE "<Directory " + """''alias_dir'""" + ">"
$!
$! Open set of options...
$!
$!	write CONF_FILE "	Options Indexes MultiViews"
$!	write CONF_FILE "	AllowOverride None"
$!	write CONF_FILE "	Order allow,deny"
$!	write CONF_FILE "	Allow from all"
$!
$! Restrictive set of options...
$!
$	write CONF_FILE "	Options FollowSymLinks"
$	write CONF_FILE "	AllowOverride None"
$!
$	write CONF_FILE "</Directory>"
$	write CONF_FILE ""
$	exit
$	ENDSUBROUTINE
$!
$restart_tomcat: SUBROUTINE
$!
$RS10$: set noon
$       ws "SOAP: Stopping CSWS-JAVA..."
$	@sys$startup:apache$jakarta_shutdown
$       call check_tomcat "SHUTDOWN"	    ! Make sure it isn't running
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS20$
$       wait 00:00:15
$       call check_tomcat "SHUTDOWN"	    ! Make sure it isn't running
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS20$
$	goto RS10$
$RS20$: ws ""
$	ws "SOAP: Starting CSWS-JAVA..."
$	@sys$startup:apache$jakarta_startup
$       call check_tomcat "RUNNING"	    ! Make sure it is running
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS30$
$       wait 00:00:15
$       call check_tomcat "RUNNING"	    ! Make sure it is running
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS30$
$	goto RS20$
$RS30$: call check_tomcat "HIBERNATE"	    ! Make sure it is hibernating
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS40$
$       wait 00:00:15
$       goto RS30$
$RS40$:	ws ""
$	exit
$	ENDSUBROUTINE
$!
$check_tomcat: SUBROUTINE
$!
$	ctx = ""
$	temp = F$CONTEXT ("PROCESS", ctx, "PRCNAM", "APACHE$TOMCAT*","EQL")
$!
$	RETURN_STATUS = 1
$	pid = F$PID(ctx)
$	IF P1 .EQS. "RUNNING"		    ! If we expect Tomcat to be running
$	THEN
$	    IF pid .EQS. ""
$	    THEN WS "SOAP: CSWS_JAVA process (APACHE$TOMCAT) is not running"
$	         RETURN_STATUS = %X10000000
$	    ENDIF
$	ENDIF
$!
$	IF P1 .EQS. "HIBERNATE"		    ! If we expect Tomcat to be hibernating
$	THEN
$	    IF pid .EQS. ""
$	    THEN WS "SOAP: CSWS_JAVA process (APACHE$TOMCAT) is not running"
$	         RETURN_STATUS = 0
$	    ENDIF
$	    IF f$getjpi(pid, "STATE") .NES. "HIB"
$	    THEN WS "SOAP: Waiting for CSWS_JAVA process (APACHE$TOMCAT) startup to complete"
$		 RETURN_STATUS = %X10000000
$	    ENDIF
$	ENDIF
$!
$	IF P1 .EQS. "SHUTDOWN"		    ! If we expect Tomcat to be shutdown
$	THEN
$	    IF pid .NES. ""
$	    THEN WS "SOAP: Waiting for CSWS_JAVA process (APACHE$TOMCAT) to exit"
$	         RETURN_STATUS = %X10000000
$	    ENDIF
$	ENDIF
$!
$	IF F$TYPE(ctx) .eqs. "PROCESS_CONTEXT"
$	THEN
$	    temp = F$CONTEXT ("PROCESS", ctx, "CANCEL")
$	ENDIF
$	exit RETURN_STATUS
$	ENDSUBROUTINE
