$	goto start
$!
$! UNINSTALL_SOAP-1_1.COM
$! Procedure to remove SOAP 1.1.
$!
$!	Copyright  2003 Hewlett-Packard Company
$!
$!	PRD		Paul R. DeStefano	11-Feb-2003
$!	Adapted from UNINSTALL_SOAP-1_0.COM, this procedure differs from
$!	the 1.0 procedure in the fact that it does not have to remove
$!	activation.jar, mail.jar, and xerces.jar, since these are no longer
$!	provided in the SOAP Tools Kit.
$!
$start:
$!
$	set noon
$	saved_verify = f$verify(f$trnlnm("uninstall_soap$verify"))
$	on control_y then goto done
$!
$	DELETE    := DELETE
$	PURGE     := PURGE
$	OPEN      := OPEN
$	DIRECTORY := DIRECTORY
$	TYPE      := TYPE
$	CLOSE     := CLOSE
$	CALL      := CALL
$	COPY      := COPY
$	DEFINE    := DEFINE
$	DEASSIGN  := DEASSIGN
$	CREATE    := CREATE
$	PRINT     := PRINT
$	SET       := SET
$	SHOW      := SHOW
$	WRITE     := WRITE
$	READ      := READ
$!
$	WS		:= write sys$output
$!
$	SAVED_CASE_LOOKUP		= ""
$	SAVED_PARSE_STYLE   = f$getjpi("", "PARSE_STYLE_PERM")
$	SAVED_CASE_PRESERVE = f$trnlnm("DECC$EFS_CASE_PRESERVE")
$	SAVED_CASE_SPECIAL  = f$trnlnm("DECC$EFS_CASE_SPECIAL")
$	SAVED_EFS_CHARSET   = f$trnlnm("DECC$EFS_CHARSET")
$!
$	OS = f$edit(f$getsyi("VERSION"),"COLLAPSE")
$	if OS .ges. "V7.3-1"		! set proc/case is not in V7.3
$	then
$	    SAVED_CASE_LOOKUP = f$getjpi("", "CASE_LOOKUP_PERM")
$	    SET PROCESS/CASE_LOOKUP=BLIND
$	endif
$!
$	SET PROCESS/PARSE_STYE=EXTENDED
$	DEFINE DECC$EFS_CASE_PRESERVE ENABLE
$	DEFINE DECC$EFS_CASE_SPECIAL ENABLE
$	DEFINE DECC$EFS_CHARSET ENABLE
$!
$	type/nopage sys$input

              SOAP Tools Kit V1.1 UnInstall Procedure
             -----------------------------------------
$!
$GET_INSTALL_DEV:
$!
$	ws ""
$	if f$trnlnm("SOAP$ROOT") .nes. ""
$	then
$	    SOAP_ROOT_DIR = f$trnlnm("SOAP$ROOT") - ".]" + "]"
$	    INSTALL_DEV = f$parse("''SOAP_ROOT_DIR'",,,"DEVICE","SYNTAX_ONLY")
$	    INSTALL_DIR = f$parse("''SOAP_ROOT_DIR'",,,"DIRECTORY","SYNTAX_ONLY")
$	else
$	    INSTALL_DEV = f$parse(f$env("DEFAULT"),,,"DEVICE","SYNTAX_ONLY")
$	    INSTALL_DIR = f$parse(f$env("DEFAULT"),,,"DIRECTORY","SYNTAX_ONLY")
$	endif
$	INSTALL_DEF = INSTALL_DEV + INSTALL_DIR
$	inquire/nopunct INSTALL_LOC "Please enter device and directory where the SOAP Tool Kit is installed [ ''INSTALL_DEF' ] : "
$	if INSTALL_LOC .eqs. "" then INSTALL_LOC = INSTALL_DEF
$!
$	INSTALL_DEV = f$parse("''INSTALL_LOC'",,,"DEVICE","SYNTAX_ONLY")
$	INSTALL_DIR = f$parse("''INSTALL_LOC'",,,"DIRECTORY","SYNTAX_ONLY")
$	INSTALL_LOC = INSTALL_DEV + INSTALL_DIR
$	if INSTALL_DEV .eqs. "" then goto GET_INSTALL_DEV
$!
$	if .not. f$getdvi("''INSTALL_DEV'","EXISTS")
$	then
$	    ws "It appears that ''INSTALL_DEV' does not exist."
$	    goto GET_INSTALL_DEV
$	endif
$!
$	if .not. f$getdvi("''INSTALL_DEV'","MNT")
$	then
$	    ws "It appears that ''INSTALL_DEV' is not mounted."
$	    goto GET_INSTALL_DEV
$	endif
$!
$	type/nopage sys$input

			***** Warning *****

    This procedure will delete all files in the following directories
    and all subdirectories of the following directories.  You may wish
    to preserve any changes and additions you have made before continuing
    with this procedure.

$	call warn "''INSTALL_LOC'" "BSF-1_0"
$	call warn "''INSTALL_LOC'" "JS-1_1"
$	call warn "''INSTALL_LOC'" "JSSE-1_1"
$	call warn "''INSTALL_LOC'" "META-INF"
$	call warn "''INSTALL_LOC'" "SOAP-1_1"
$	call warn "''INSTALL_LOC'" "SOAP_TOOLS-1_1"
$!
$!
$! Determine where CSWS_JAVA is installed.
$!
$	define/user sys$output SYS$SCRATCH:SHOW_PROD.TXT
$	product show object [apache.jakarta.*]/full
$	open/read/error=open_in_error IN_FILE SYS$SCRATCH:SHOW_PROD.TXT
$	TOMCAT_HOME = ""
$!
$SP_LOOP2:
$!	
$	read/end=SP_DONE2 IN_FILE record
$	record = f$edit(record, "TRIM, COMPRESS")
$	if f$extract(0, 23, record) .nes. "[APACHE.JAKARTA.TOMCAT]" then goto SP_LOOP2
$	TOMCAT_HOME	    = f$element(3," ", record) - "]" + "APACHE.JAKARTA.TOMCAT]"
$	TOMCAT_WEBAPPS	    = TOMCAT_HOME - "]" + ".webapps]"
$	TOMCAT_CONF	    = TOMCAT_HOME - "]" + ".conf]"
$	TOMCAT_COMMON_LIB   = TOMCAT_HOME - "]" + ".common.lib]"
$!
$SP_DONE2:
$!
$	close IN_FILE
$	delete/nolog SYS$SCRATCH:SHOW_PROD.TXT;
$	if TOMCAT_HOME .nes. ""
$	then
$	    call warn "''TOMCAT_WEBAPPS'" "SOAP"
$	endif
$!
$	ws ""
$	ws "    In addition:
$	ws ""
$	if TOMCAT_HOME .nes. ""
$	then
$	    ws "	''TOMCAT_WEBAPPS'soap.war will be deleted."
$	endif
$!
$	ws "	Files modified by the SOAP installation procedure will be restored,
$	ws "	provided there have been no additional modifications since SOAP was
$	ws "	installed."
$!
$	ws ""
$	inquire/nopunct ANS "Would you like to continue this procedure? (Y, N [N]) "
$	if .not. ANS then goto done
$!
$	ws ""
$	call deltre "''INSTALL_LOC'" "BSF-1_0"
$	call deltre "''INSTALL_LOC'" "JS-1_1"
$	call deltre "''INSTALL_LOC'" "JSSE-1_1"
$	call deltre "''INSTALL_LOC'" "SOAP-1_1"
$	call deltre "''INSTALL_LOC'" "META-INF"
$	if TOMCAT_HOME .nes. ""
$	then
$	    call deltre "''TOMCAT_WEBAPPS'" "SOAP"
$	    delete/nolog 'TOMCAT_WEBAPPS'soap.war;
$	endif
$!
$       ws ""
$	ws "Performing consistency checks on files modified by the SOAP installation..."
$       ws ""
$!
$! These must be before SOAP_TOOLS-1_1 is deleted.
$!
$	call con_check HTTPD.CONF APACHE$ROOT:[CONF]
$	call con_check .TOMCATRC APACHE$ROOT:[000000]
$	call con_check server.xml 'TOMCAT_CONF'
$!
$	call deltre "''INSTALL_LOC'" "SOAP_TOOLS-1_1"
$	RESTART_TOMCAT = "FALSE"
$	if TOMCAT_HOME .nes. ""
$	then
$	    ws ""
$	    ws "CSWS_JAVA should be restarted."
$	    inquire/nopunct ANS "Would you like to restart CSWS_JAVA? (Y, N) [Y] : "
$	    if ANS .eqs. ""
$	    then
$		RESTART_TOMCAT = "TRUE"
$	    else
$		RESTART_TOMCAT = ANS
$	    endif
$	endif
$	ws ""
$	if RESTART_TOMCAT
$	then
$	    call restart_tomcat
$	    if f$trnlnm("APACHE$COMMON") .nes. ""
$	    then
$		@SYS$STARTUP:APACHE$STARTUP GRACEFUL
$	    endif
$	endif
$	type/nopage sys$input

SOAP Tools Kit V1.1 Un-Install complete.

$	ws "				Note"
$	ws "You may wish to delete the top level directory that the SOAP$ROOT"
$	ws "logical equates to ( ''f$trnlnm("SOAP$ROOT")' )."
$	ws ""
$	ws "You may also wish to remove the SOAP$ROOT logical name definition"
$	ws "from SYS$MANAGER:SYLOGICALS.COM."
$	ws ""
$!
$	delete 'f$env("procedure")
$done:
$       if SAVED_PARSE_STYLE .nes. ""
$	then
$	    SET PROCESS/PARSE_STYE='SAVED_PARSE_STYLE
$	endif
$	if SAVED_CASE_LOOKUP .nes. ""
$	then
$	    SET PROCESS/CASE_LOOKUP='SAVED_CASE_LOOKUP
$	endif
$!
$	if SAVED_CASE_PRESERVE .nes. ""
$	then
$	    define/nolog DECC$EFS_CASE_PRESERVE 'SAVED_CASE_PRESERVE
$	else
$	    if f$trnlnm("DECC$EFS_CASE_PRESERVE") .nes. "" then deas DECC$EFS_CASE_PRESERVE
$	endif
$	if SAVED_CASE_SPECIAL .nes. ""
$	then
$	    define/nolog DECC$EFS_CASE_SPECIAL 'SAVED_CASE_SPECIAL
$	else
$	    if f$trnlnm("DECC$EFS_CASE_SPECIAL") .nes. "" then deas DECC$EFS_CASE_SPECIAL
$	endif
$	if SAVED_EFS_CHARSET .nes. ""
$	then
$	    define/nolog DECC$EFS_CHARSET 'SAVED_EFS_CHARSET
$	else
$	    if f$trnlnm("DECC$EFS_CHARSET") .nes. "" then deas DECC$EFS_CHARSET
$	endif
$!
$!	scratch = f$verify(saved_verify)
$	exit
$!
$!----------------------------------------------------------------------------
$! Subroutine to output the directory tree that will be deleted.
$!
$warn: SUBROUTINE
$!
$	INSTALL_LOC	:= "''P1'"
$	TREE_TOP	:= "''P2'"
$	LOC = INSTALL_LOC - "]" + "." + TREE_TOP + "...]"
$	ws "		''LOC'"
$	exit
$	ENDSUBROUTINE
$!
$!----------------------------------------------------------------------------
$! Subroutine to delete a directory tree.
$!
$deltre: SUBROUTINE
$!
$	INSTALL_LOC	:= "''P1'"
$	TREE_TOP	:= "''P2'"
$	LOC = INSTALL_LOC - "]" + "." + TREE_TOP + "...]"
$	if f$search("''INSTALL_LOC'''TREE_TOP'.DIR") .eqs. "" then exit
$	ws "   Removing ''TREE_TOP'..."
$	set prot:o:werd 'LOC'*.*;*
$loop:	define/user sys$output nl:
$	define/user sys$error  nl:
$	delete/nolog 'LOC'*.*;*
$	if $status .eq. %X109311F0 then goto loop
$	delete/nolog 'INSTALL_LOC''TREE_TOP'.dir;
$	exit
$	ENDSUBROUTINE
$!
$!----------------------------------------------------------------------------
$! Subroutine to compare saved original file with ;-1 and current file with
$! the file modified by SOAP.  If the both match, i.e., the only changes are
$! those made by the SOAP installation, then restore the saved original file.
$!
$! P1 = Name of file to check
$! P2 = Location of active file
$!
$! Original files are preserved in SOAP$ROOT:[Soap_Tools-1_1.org]
$! Files as modified by SOAP installation are preserved in
$! SOAP$ROOT:[Soap_Tools-1_1.new]
$!
$con_check: SUBROUTINE
$!
$	if f$search("SOAP$ROOT:[Soap_Tools-1_1.new]''P1'") .nes. ""
$	then
$	    diff SOAP$ROOT:[Soap_Tools-1_1.new]'P1 'P2
$	    new_diff_status = $status
$	    ws ""
$	    if f$search("SOAP$ROOT:[Soap_Tools-1_1.org]''P1'") .nes. ""
$	    then
$		diff SOAP$ROOT:[Soap_Tools-1_1.org]'P1 'P2';-1
$		org_diff_status = $status
$	    else
$		ws "Preserved version of original ''P1' not found"
$		org_diff_status = %X006C8009
$	    ws ""
$	    endif
$	    if (new_diff_status .and. org_diff_status) .eq. %X006C8009
$	    then
$		ws "Deleting SOAP installed version of ''P2'''P1'"
$		delete 'P2''P1';
$	    else
$		ws "''P2'''P1' has been modified"
$		ws "since the SOAP Tools Kit was installed.  These modifications"
$		ws "must be resolved manually."
$		inquire Q "Press <ENTER> key to continue"
$	    endif
$	    ws ""
$	else
$	    ws "Preserved version of revised ''P1' not found"
$	endif
$	exit
$	ENDSUBROUTINE
$!
$restart_tomcat: SUBROUTINE
$!
$RS10$: set noon
$       ws "SOAP: Stopping CSWS-JAVA..."
$	@sys$startup:apache$jakarta_shutdown
$       call check_tomcat "SHUTDOWN"	    ! Make sure it isn't running
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS20$
$       wait 00:00:15
$       call check_tomcat "SHUTDOWN"	    ! Make sure it isn't running
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS20$
$	goto RS10$
$RS20$: ws ""
$	ws "SOAP: Starting CSWS-JAVA..."
$	@sys$startup:apache$jakarta_startup
$       call check_tomcat "RUNNING"	    ! Make sure it is running
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS30$
$       wait 00:00:15
$       call check_tomcat "RUNNING"	    ! Make sure it is running
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS30$
$	goto RS20$
$RS30$: call check_tomcat "HIBERNATE"	    ! Make sure it is hibernating
$       tomcat_status = $status
$       if tomcat_status .eq. 1 then goto RS40$
$       wait 00:00:15
$       goto RS30$
$RS40$:	ws ""
$	exit
$	ENDSUBROUTINE
$!
$check_tomcat: SUBROUTINE
$!
$	ctx = ""
$	temp = F$CONTEXT ("PROCESS", ctx, "PRCNAM", "APACHE$TOMCAT*","EQL")
$!
$	RETURN_STATUS = 1
$	pid = F$PID(ctx)
$	IF P1 .EQS. "RUNNING"		    ! If we expect Tomcat to be running
$	THEN
$	    IF pid .EQS. ""
$	    THEN WS "SOAP: CSWS_JAVA process (APACHE$TOMCAT) is not running"
$	         RETURN_STATUS = %X10000000
$	    ENDIF
$	ENDIF
$!
$	IF P1 .EQS. "HIBERNATE"		    ! If we expect Tomcat to be hibernating
$	THEN
$	    IF pid .EQS. ""
$	    THEN WS "SOAP: CSWS_JAVA process (APACHE$TOMCAT) is not running"
$	         RETURN_STATUS = 0
$	    ENDIF
$	    IF f$getjpi(pid, "STATE") .NES. "HIB"
$	    THEN WS "SOAP: Waiting for CSWS_JAVA process (APACHE$TOMCAT) startup to complete"
$		 RETURN_STATUS = %X10000000
$	    ENDIF
$	ENDIF
$!
$	IF P1 .EQS. "SHUTDOWN"		    ! If we expect Tomcat to be shutdown
$	THEN
$	    IF pid .NES. ""
$	    THEN WS "SOAP: Waiting for CSWS_JAVA process (APACHE$TOMCAT) to exit"
$	         RETURN_STATUS = %X10000000
$	    ENDIF
$	ENDIF
$!
$	IF F$TYPE(ctx) .eqs. "PROCESS_CONTEXT"
$	THEN
$	    temp = F$CONTEXT ("PROCESS", ctx, "CANCEL")
$	ENDIF
$	exit RETURN_STATUS
$	ENDSUBROUTINE
