	.ident "@(#)disable.s	1.0 94#03#18"

	.data				# Data section

	.text				# Text section

	.set    CR0_CD_DIS, 0x40000000	# Disable cache with CR0
	.set    CR0_NW_DIS, 0x20000000	# Disable writethru with CR0
					# Actually, the NW bit is hardwired
					# to 0 at all times on the Cyrix,
					# but we set and clear it anyway...

#
#	void cx_i486cacheoff(void)
#
#	This routine disables and flushes the i486 internal cache.
#
	.align	4
	.globl	_cx_i486cacheoff
_cx_i486cacheoff:
	pushl	%ebp
	movl	%esp, %ebp
	movl    %cr0, %eax              # cr0 -> eax
	orl	$CR0_CD_DIS, %eax	# Turn "off" CD bit
	orl	$CR0_NW_DIS, %eax	# Turn "off" NW bit
	movl    %eax, %cr0              # eax -> cr0
	.byte	0x0f			# INVD instruction:
	.byte	0x08			# Flush i486 cache
	.byte	0x0f			# WBINVD instruction:
	.byte	0x09			# Flush i486 cache with write back
	jmp	cx_postinvd2		# Jmp to next to force queue flush
cx_postinvd2:
	popl	%ebp
	ret
