/****************************************************************/
/*	INTEGRA TECHNOLOGIES INC.									*/
/*																*/
/*	Integra Technologies proprietary software package. 			*/
/*	Copyright(c) 1988-1992 Integra Technologies inc.			*/
/*	All Rights Reserved											*/
/*																*/
/*	FILE: OASLOG.C												*/
/*																*/
/*	This file is supplied to the user for customization			*/
/*	of remote messaging											*/
/*																*/
/****************************************************************/

#include	<time.h>
#include	<stdlib.h>
#include	<stdio.h>

#define INCL_DOS   // wln get OS/2 system calls
#include	<os2.h>

// Begin customization includes*********************************
#include <string.h>   // wln - Used by string function calls
//#include <netcons.h>  // wln - Used by Net message APIs
//#include <message.h>  // wln - Used by Net message APIs
#define   CBFILENAME  (USHORT) 15 // wln - Length of object name buffer
UCHAR	  pszFailName[CBFILENAME];// wln - Buffer to put obj name
HMODULE   hmod; 		  // wln - module handle
unsigned (pascal far * ppfnProcAddr) (const PSZ,PSZ,PSZ,USHORT );
// End customization includes*********************************

#define SOF_MODE    0
#define EOF_MODE    2

#define	CR			0x0D
#define	LF			0x0A

#define TRUE	    1
#define FALSE	    0

#define INTEGRA_LOG_OPEN_FAIL	0
#define LOG_WRITE_FAIL			1
#define	NO_OASAS				2
#define INBUF_SIZE				4096

UCHAR	BootDrive;
char	*log_err[] =
		{
		"OAS0302: Unable to open the \\OASAS\\OASAS.LOG file\n",
		"OAS0303: Unable to write the file \\OASAS\\OASAS.LOG\n",
		"OAS0304E: OASAS not set in CONFIG.SYS file\n"
		};

/* OASAS I log file name */
char		OASAS[] = "C:\\OASAS\\OASAS.LOG";
UCHAR		OASmsg[2048];
UCHAR		outmsg[2048];
int			char_cnt;
struct tm	*newtime;
time_t		aclock;
void		SetOASPath();
void		GetBootDrive();

UCHAR Divider[] ="******************************************************************";

/************************************************************************/
/*																		*/
/*	function: main														*/
/*																		*/
/*	This program is invoked by OASAS utility programs to log the		*/
/*	events to the OASAS.LOG file. The source is supplied to the			*/
/*	user for customization. The OASLOG.EXE program has to be resident	*/
/*	in the \OASAS directory on the boot drive. There are three			*/
/*	parameters passed:													*/
/*		param1 = Time stamp flag  0 = do not put time stamp on message	*/
/*		parma2 = Broadcast flag 0 = do not send message					*/
/*		parma3 = Message to log											*/
/*																		*/
/************************************************************************/
main(argc, argv)
int		argc;
char	*argv[];
{
	HFILE	OASASh;
	USHORT	rc, Action;
	ULONG   new_pointer;
	char    temp_buf[2048];
	char    *s_ptr, *d_ptr;
	int     index;
	UCHAR	c;
	UCHAR	stamp_flag;
	UCHAR	BroadcastFlag;
	
	if (argc < 4)
	   exit(1);
		
	stamp_flag = atoi(&argv[1][0]);
	BroadcastFlag = atoi(&argv[2][0]);
	/*
	 *	Messages with broadcast flag = TRUE are down drive messages,
	 *	reassign block messages, inconsistent LBA messages, ...
	 *
	 *	Messages with broadcast flag = FALSE are utility programs
	 *	starting and ending, etc.
	 *
	 *	All messages will be logged in \OASAS\OASAS.LOG
	 *	Only messages with a broadcast flag = TRUE will be sent to
	 *	Administrator
	 *
	 *	To send all messages to Administrator, uncomment the following
	 *	line.
	 */
//	BroadcastFlag = TRUE;
	strcpy( OASmsg, argv[3]);
	GetBootDrive();
	if (BootDrive == 'A')
		return;
	/*
	 *	Process event description string which includes special
	 *	characters for blanks and line feeds. Convert special
	 *	characters here.
	 */
	s_ptr = OASmsg;
	d_ptr = outmsg;
	while ( *s_ptr )
	{
		if ((c = *s_ptr++) == '_' )
	   	 *d_ptr++ = ' ';
		else
		{
			if (c == '~')
			{
				*d_ptr++ = CR;
				*d_ptr++ = LF;
			}
			else
				*d_ptr++ = c;
		}
	}
	SetOASPath();
	/*	Open OASlog file. File will be created if it does not exist */
	rc = DosOpen(&OASAS[0],&OASASh,&Action,0L,0,0x11,0xA2, 0L);
	if (rc)
		printf( log_err[ INTEGRA_LOG_OPEN_FAIL ] );

	/*
	 *	Move file pointer to end of file so message can be
	 *	appended to the end of the LOG file	
	 */
	rc = DosChgFilePtr(OASASh, 0L, EOF_MODE, &new_pointer);
	rc = DosWrite(	OASASh,				    /* Handle of file	 */
					(PVOID) outmsg,			/* pointer to string */
					strlen(outmsg),			/* length of string  */
					(PUSHORT) &char_cnt );	/* return char count */
	if (rc)
		printf( log_err[ LOG_WRITE_FAIL ] );

	/* get currnt time */
	time(&aclock) ;

	/* get local time */
	newtime = localtime(&aclock);

	/* convert local time to ascii string */
	s_ptr = asctime(newtime);

	strcpy(temp_buf, s_ptr);
	index = strlen(temp_buf);

	/*	Add new line to the end of string */
	temp_buf [index-1] = CR;	/* return			*/
	temp_buf [index] = LF;		/* new line			*/
	temp_buf [index+1] = 0;		/* end of string	*/
	s_ptr = temp_buf;

	if (stamp_flag)
	{
		strcat(outmsg,temp_buf); // add time stamp to message
		/* record current time stamp */
		rc = DosWrite(	OASASh,					/* Handle of file	 */
					   (PVOID) s_ptr,			/* pointer to string */
					   strlen(s_ptr),			/* length of string  */
					   (PUSHORT) &char_cnt );	/* return char count */
		if (rc)
			printf( log_err[ LOG_WRITE_FAIL ] );
		d_ptr = Divider;
		s_ptr = temp_buf;
		while (*d_ptr)
			*s_ptr++ = *d_ptr++;
		*s_ptr++ = CR;
		*s_ptr++ = LF;
		*s_ptr++ = 0;
		rc = DosWrite(	OASASh,				    /* Handle of file	 */
						(PVOID) temp_buf,	    /* pointer to string */
						strlen(temp_buf),	    /* length of string  */
						(PUSHORT) &char_cnt );	/* return char count */
		if (rc)
			printf( log_err[ LOG_WRITE_FAIL ] );
	}
	DosClose(OASASh);

	/*
	 *
	 *	User customization should be done here
	 *
	 */

	// Begin customization sample code
	// the following sample is compiled into OASLOG.EXE

	// Get name of Administrator from environment & send an event message
	if (!BroadcastFlag)
		exit(0); // do not broadcast message to administrator
	if( (s_ptr=getenv("OASAS_MSG_NAME") ) )
	{

		if( !DosLoadModule(	(PSZ) pszFailName,
							(USHORT) CBFILENAME,
							(PSZ) "NETOEM",
							(PHMODULE) & hmod) )
		{
			// Able to get dynalink handle, get proc addr, call & free
			if( !DosGetProcAddr(	(HMODULE) hmod,
									(PSZ) "NETMESSAGEBUFFERSEND",
									(PFN FAR *) &ppfnProcAddr))
			{
				// Call NetMessageBufferSend() API proc addr in dynalink
				ppfnProcAddr (	(const PSZ) 0L,
								(PSZ)	s_ptr,
								(PSZ)	outmsg,
								(USHORT)	strlen(outmsg));
			}

			DosFreeModule(hmod); // Free the "NETOEM" module handle
		}    // End able to get dynalink handle...

	}  // End of attempt to send remote message from environment name
	// End customization *****************************************

	exit(0);
}

void SetOASPath()
{

	OASAS[0] = BootDrive;

	return; // OASAS[] = BootDrive\OASAS\OAS.LOG or something like that
}

void	GetBootDrive()
{
	SEL				GSeg;
	SEL				LSeg;
	GINFOSEG FAR	*info;

	DosGetInfoSeg(&GSeg, &LSeg);
	info = MAKEPGINFOSEG(GSeg);
	BootDrive = (info->bootdrive + 'A') - 1;
	return;
}
