/*==========================================================================*/
/* EJREXIT.H           IBM BookManager Read for Windows                     */
/*                                                                          */    
/* User Exit Routines - this header file is supplied by IBM for use with    */    
/* BookManager Read for Windows.  This file is used in the creation of      */    
/* the user exit DLL - EJREXIT.DLL, and in the creation of the Read for     */    
/* Windows product.  Changes to this file are NOT SUPPORTED by IBM and      */    
/* may CAUSE ERRRORS when using Read for Windows.  This file is already     */
/* included by Read for Windows and must remain compatible.  This file is   */
/* supplied for use as reference material and for inclusion when recreating */    
/* the EJREXIT.DLL.  The EJREXIT.DLL supplied with Read for Windows uses    */    
/* this file and the source code for creating the DLL has been included     */    
/* with the product (EJREXIT.C).                                            */    
/*                                                                          */    
/* See the documentation for complete information on creating and using     */    
/* user exits with Read for Windows.                                        */    
/*                                                                          */    
/*                                                                          */    
/* This file is included by:                                                */    
/*                                                                          */    
/*    Read for Windows,                                                     */    
/*    EJREXIT.C,                                                            */    
/*   (Additional user code named here if appropriate).                      */    
/*                                                                          */    
/* MDW94                                                                    */    
/*==========================================================================*/

#ifndef EJREXIT_H
#define EJREXIT_H

/* Define a structure for passing book information.                         */
/* Used by: EJROpenBookExit, EJRCloseBookExit                               */
extern struct EJRBOOKINFO
	{ 
		char    BookName[10];        // Book file name
		char    BuildDateTime[256];  // Format is MM/DD/YY HH:MM:SS
		char    BookTitle[256];      // 256 - maximum length allowed
		char    DocumentNumber[256]; // 256 - maximum length allowed
		char    QualifiedPath[260];  // 260 - maximum length allowed
	}BookRecord;                   

/* Define a structure for passing search information.                       */
/* Used by: EJRSearchExit                                                   */
extern struct EJRSEARCHINFO
	{ 
		char    Argument[255];       // 255 - maximum length allowed
	}SearchRecord;                   


/* User Exit Prototypes                                                     */ 

short FAR PASCAL _export EJROpenBookExit(struct EJRBOOKINFO pBookDataParm);
short FAR PASCAL _export EJRCloseBookExit(struct EJRBOOKINFO pBookDataParm);
short FAR PASCAL _export EJRSearchExit(struct EJRSEARCHINFO far * pSearchParm);


#endif

