
#include <iostream.h>
#include <memory.h>
#include <conio.h>

typedef unsigned char UCHAR;
typedef unsigned short USHORT;
typedef unsigned long ULONG;

#define FAR		_far
#define BYTESPERSECTION 0x200
#define EXMID		0x96
#define EXMENABLE	0x00000001
#define LSWLOWBYTE	0x8380
#define LSWHIGHBYTE	0x8381
#define MSWLOWBYTE	0x8382
#define MSWHIGHBYTE	0x8386
#define SRAMDATA	0x8384

UCHAR	Slot	=	5;		/* presumes EXM-2 in slot 5 */


void
readsection(UCHAR FAR *target, ULONG sramoffset)
{   UCHAR ob;
    register USHORT rinductor;

    /*
    //	Enable the card to allow register access
    */
    outp(EXMID,Slot);
    ob = inp(0x102);
    outp(0x102,ob | EXMENABLE);
    /*
    //	Load initial offset value (sramoffset should be divisible by 256)
    */
    outp(MSWHIGHBYTE,(USHORT) (sramoffset >> 24));
    outp(MSWLOWBYTE,(USHORT) (sramoffset >> 16));
    outp(LSWHIGHBYTE,(USHORT) (sramoffset >>8));
    outp(LSWLOWBYTE,(USHORT) sramoffset);
    /*
    //	Read a section using the autoincrement feature of the EXM-2A.
    */
    for (rinductor = 0; rinductor < BYTESPERSECTION; rinductor++) {
       *target++ = (UCHAR) inp(SRAMDATA);
    }
    outp(0x102,ob);	/* restore the option byte */
}

void
writesection(UCHAR FAR *source, ULONG sramoffset)
{   UCHAR ob;
    register USHORT rinductor;

    /*
    //	Enable the card to allow register access
    */
    outp(EXMID,Slot);
    ob = inp(0x102);
    outp(0x102,ob | EXMENABLE);
    /*
    //	Load initial offset value (sramoffset should be divisible by 256)
    */
    outp(MSWHIGHBYTE,(USHORT) (sramoffset >> 24));
    outp(MSWLOWBYTE,(USHORT) (sramoffset >> 16));
    outp(LSWHIGHBYTE,(USHORT) (sramoffset >>8));
    outp(LSWLOWBYTE,(USHORT) sramoffset);
    /*
    //	Write a section using the autoincrement feature of the EXM-2A.
    */
    for (rinductor = 0; rinductor < BYTESPERSECTION; rinductor++) {
       outp(SRAMDATA,*source++);
    }
    outp(0x102,ob);	/* restore the option byte */
}

void
main()
{   UCHAR test[BYTESPERSECTION];
    UCHAR readbuffer[BYTESPERSECTION];
    register USHORT minductor;

    for (minductor = 0; minductor < BYTESPERSECTION; minductor++)
	test[minductor] = minductor;
    writesection(test,0);
    readsection(readbuffer,0);
    if (memcmp(test,readbuffer,BYTESPERSECTION))
       cout << "Read/Write test failure" << endl;
    else cout << "Read/Write test successful" << endl;
}
