/************************************************************************
*    Program:    PCVIDEO.DLL                    *
*    Module:        PCVIDEO.H                    *
*    Desription:    'C' prototype definitions for routines        *
*    Version        :1.0                        *
*    Copyright (C) Radisys Corp 1991                    *
************************************************************************/

typedef struct CCONFIG {
    WORD     InputType;
    WORD     Display;
    WORD     Frozen;
    BYTE     xHue;
    BYTE     Saturation;
    WORD     ColorKey;
    WORD     xFB;
    WORD     yFB;
    WORD     cxFB;
    WORD     cyFB;
    WORD     xVI;
    WORD     yVI;
    WORD     cxVI;
    WORD     cyVI;
    WORD     xS;
    WORD     yS;
    WORD     cxS;
    WORD     cyS;
    DWORD    Level;
    WORD     Fitted;
    BYTE     Contrast;
    BYTE     VTR;
} CCONFIG;


/* new library interface */
int FAR PASCAL LibEntry (void);
int FAR PASCAL PCV_Display (int fDisplay);
int FAR PASCAL PCV_FillRect (WORD xFB, WORD yFB, WORD cx, WORD cy, WORD data);
int FAR PASCAL PCV_Freeze (int fFreeze);
void FAR PASCAL PCV_GetAcqWinMap (WORD far * pxVI, WORD far * pyVI,
                  WORD far * pcxVI, WORD far * pcyVI, 
                  WORD far * pxFB, WORD far * pyFB, 
                  WORD far * pcxFB, WORD far * pcyFB);
WORD FAR PASCAL PCV_GetColorKey(void);
int FAR PASCAL PCV_GetComposite (int far * pType, BYTE far * pHue, 
                 BYTE far * pSaturation);
void FAR PASCAL PCV_GetContrast (BYTE far *Level);
int FAR PASCAL PCV_GetHorzRes (WORD far *pRes);
int FAR PASCAL PCV_GetRGB (DWORD far * pLevel);
void FAR PASCAL PCV_GetScrWinMap (WORD far * pxFB, WORD far * pyFB, 
                  WORD far * pxS, WORD far * pyS, 
                  WORD far * pcx, WORD far * pcy);
void FAR PASCAL PCV_GetState (CCONFIG far * config);
int FAR PASCAL PCV_ReadRect (WORD xFB, WORD yFB, WORD cx, WORD cy, LPSTR pBuf);
int FAR PASCAL PCV_SetAcqWinMap (WORD xVI, WORD yVI, WORD cxVI, WORD cyVI, 
                 WORD xFB, WORD yFB, WORD cxFB, WORD cyFB);
void FAR PASCAL PCV_SetColorKey (WORD key);
int FAR PASCAL PCV_SetComposite (WORD type);
void FAR PASCAL PCV_SetCompositeLevel (BYTE Hue, BYTE Saturation);
void FAR PASCAL PCV_SetContrast (BYTE Level);
void FAR PASCAL PCV_SetRGB (DWORD Level);
int FAR PASCAL PCV_SetScrWinMap (WORD xFB, WORD yFB, WORD xS, WORD yS, 
                 WORD cx, WORD cy, BOOL bFit);
void FAR PASCAL PCV_SetState (CCONFIG far * config);
void FAR PASCAL PCV_SetVTR (BYTE type);
int FAR PASCAL PCV_WriteRect (WORD xFB, WORD yFB, WORD cx, WORD cy, LPSTR pBuf);
int FAR PASCAL PCV_SaveBmpFormat(LPSTR lpFile, WORD xPos, WORD yPos, 
                    WORD width, WORD height);
int FAR PASCAL PCV_LoadBmpFormat(LPSTR lpFile, WORD xPos, WORD yPos);
int FAR PASCAL PCV_ClipRect(WORD xPos, WORD yPos, WORD width, WORD height);
int FAR PASCAL PCV_LoadConfiguration(void);
int FAR PASCAL PCV_SaveConfiguration(void);

/* return values */
#define PCV_SUCCESS         0 
#define PCV_FBBOUNDS        1
#define PCV_WRONGTYPE       2
#define PCV_BADSCALE        3
#define PCV_PLLNOTLOCKED    4

/* constants */
#define PCV_RGBVIDEO             0
#define PCV_NTSC               0x1
#define PCV_PAL                0x2
#define PCV_SECAM              0x3
#define PCV_RS170LEVEL    0x808080
#define PCV_RS343LEVEL    0x202020
#define PCV_SVHS              0x10
#define PCV_TYPE_ERROR        0x13
#define PCV_VER_REG_MASK      0xF0

/* Error codes */
#define ERR_API         -1
#define ERR_CREATE      -2
#define ERR_ALLOCATE    -3
#define ERR_DISKFULL    -4
#define ERR_DATA        -5
#define ERR_FORMAT      -6
#define ERR_24RGB       -7
#define ERR_OPEN        -8
#define ERR_PORTADDR    -9
