/*--------------------------------------------
  OS/2 Demo of writing a PM apps with PCVIDEO 
  --------------------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <stdlib.h>
#include "pcvideo.h"

MRESULT EXPENTRY ClientWndProc (HWND, USHORT, MPARAM, MPARAM) ;

HWND  hwndFrame;
int	main (void)
{
	static CHAR  szClientClass [] = "Demo" ;
	static ULONG flFrameFlags = FCF_TITLEBAR | FCF_SYSMENU | FCF_HORZSCROLL|
				    FCF_SIZEBORDER | FCF_MINMAX | 
				    FCF_SHELLPOSITION | FCF_TASKLIST ;
	HAB            hab ;
	HMQ            hmq ;
	QMSG           qmsg ;
 	HWND	       hwndClient ;

	hab = WinInitialize (0) ;
	hmq = WinCreateMsgQueue (hab, 0) ;

	WinRegisterClass (hab, szClientClass, ClientWndProc, 
				CS_SIZEREDRAW | CS_MOVENOTIFY, 0) ;

	hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
	    &flFrameFlags, szClientClass, NULL,
	    0L, NULL, 0, &hwndClient) ;


	while (WinGetMsg (hab, &qmsg, NULL, 0, 0))
		WinDispatchMsg (hab, &qmsg) ;

	WinDestroyWindow (hwndFrame) ;
	WinDestroyMsgQueue (hmq) ;
	WinTerminate (hab) ;
	return 0 ;
}

#define HORZRES 650
#define VERTRES 480

short maxy, cyTitle, cxBorder, xPos, yPos;
HWND hHScroll;
SWP	  swp;

MRESULT EXPENTRY ClientWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	HPS          hps ;
	RECTL        rect ;

	switch (msg) {
	case WM_CREATE:
		/* Initialize the board */
		LibEntry();
		WinQueryWindowPos (HWND_DESKTOP, &swp);
		/* Get system dimemsions */
		maxy = swp.cy;
		cyTitle = (short) WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR);
		cxBorder = (short) WinQuerySysValue(HWND_DESKTOP, SV_CXBORDER);
		hps = WinGetPS (hwnd) ;
		/* Set background color of window to match color key */
		GpiSetBackColor (hps, CLR_PINK);
		WinReleasePS (hps) ;
		/* Get handles of scroll bars */
		hHScroll = WinWindowFromID (WinQueryWindow  (hwnd, QW_PARENT,
						FALSE), FID_HORZSCROLL);

		/* Setting up video source type*/
		PCV_SetComposite (PCV_NTSC);
		/* Setting up the acquisition window and frame buffer */
		PCV_SetAcqWinMap (0, 0, HORZRES, VERTRES, 0, 0, HORZRES, VERTRES);
		/* Color Key for pink */
		PCV_SetColorKey(13);
		/* Unfreeze the video */
		PCV_Freeze (FALSE);
		/* Turn display on */
		PCV_Display (TRUE);

		WinQueryWindowPos (hwndFrame, &swp);
		/* set the scroll range */
		WinSendMsg (hHScroll, SBM_SETSCROLLBAR, MPFROM2SHORT(0, 0),
				MPFROM2SHORT(0, HORZRES - swp.cx));

		/* Transposing the coordinate system and setting up the
		   screen window for displaying the live video */
		PCV_SetScrWinMap (xPos, yPos, swp.x + cxBorder, 
				maxy - swp.y - swp.cy + cyTitle + 2 * cxBorder,
				swp.cx - 3 * cxBorder, 
				swp.cy - cyTitle - 2 * cxBorder, FALSE);
		return 0 ;

	case WM_SIZE:
		WinQueryWindowPos (hwndFrame, &swp);
		/* set the scroll range */
		WinSendMsg (hHScroll, SBM_SETSCROLLBAR, MPFROM2SHORT(0, 0),
				MPFROM2SHORT(0, HORZRES - swp.cx - 3*cxBorder));
		/* Transposing the coordinate system and setting up the
		   screen window for displaying the live video */
		PCV_SetScrWinMap (xPos, yPos, swp.x + cxBorder, 
				maxy - swp.y - swp.cy + cyTitle + 2 * cxBorder,
				swp.cx - 3 * cxBorder, 
				swp.cy - cyTitle - 2 * cxBorder, FALSE);
		return 0;
		break;

	case WM_MOVE:
		WinQueryWindowPos (hwndFrame, &swp);
		/* Transposing the coordinate system and setting up the
		   screen window for displaying the live video */
		PCV_SetScrWinMap (xPos, yPos, swp.x + cxBorder, 
				maxy - swp.y - swp.cy + cyTitle + 2 * cxBorder,
				swp.cx - 3 * cxBorder, 
				swp.cy - cyTitle - 2 * cxBorder, FALSE);
		return 0;
		break;

	case WM_PAINT:
		hps = WinBeginPaint (hwnd, NULL, &rect) ;
		WinFillRect (hps, &rect, CLR_PINK);
		WinEndPaint (hps) ;
		WinQueryWindowPos (hwndFrame, &swp);
		/* Transposing the coordinate system and setting up the
		   screen window for displaying the live video */
		PCV_SetScrWinMap (0, 0, swp.x + cxBorder, 
				 maxy - swp.y - swp.cy + cyTitle + 2 * cxBorder,
				 swp.cx - 3 * cxBorder, 
				 swp.cy - cyTitle - 2 * cxBorder, FALSE);
		return 0 ;

	case WM_CLOSE:
		/* Disable display of live video */
		PCV_Display (FALSE);
		break;

	case WM_HSCROLL:
		switch (SHORT2FROMMP(mp2)) {
			case SB_LINELEFT:
				xPos = max (0, xPos - 1);
			break;

			case SB_LINERIGHT:
				xPos = min (HORZRES, xPos + 1);
			break;

			case SB_PAGELEFT:
				xPos = max (0, xPos - 12);
			break;

			case SB_PAGERIGHT:
				xPos = min (HORZRES, xPos + 12);
			break;

			case SB_SLIDERPOSITION:
				xPos = SHORT1FROMMP (mp2);
			break;

		}

		WinSendMsg (hHScroll, SBM_SETPOS, MPFROMSHORT(xPos), NULL);
		PCV_SetScrWinMap (xPos, yPos, swp.x + cxBorder, 
				maxy - swp.y - swp.cy + cyTitle + 2 * cxBorder,
				swp.cx - 3 * cxBorder, 
				swp.cy - cyTitle - 2 * cxBorder, FALSE);
		return 0;
	}
	return WinDefWindowProc (hwnd, msg, mp1, mp2) ;
}


