/************************************************************************
* Program:	DEMO.EXE						*
* Module:	DEMO.C							*
* Description:	Windows demo for EXM-14					*
* Version:	1.0							*
* Copyright (C) Radisys Corp.						*
************************************************************************/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "demo.h"
#include "pcvideo.h"

HCURSOR	hCur;				/* Holds Wait / Normal cursor */
HANDLE	hInst;				/* Handle to instance of the window */
HANDLE	hAccel;				/* Handle to accelerator table */
HWND	hMainWnd;			/* Handle to main window */
short	xWinSize, yWinSize;		/* Windows' client area size */

static char	*fu_mtext[2] = {
	"UnFree&ze\tCtrl+S", "Free&ze  \tCtrl+S"}; /* FREEZE/UNFREEZE Menu Text */


static short	f_fu = GF_UNFREEZE;	/* Freeze/UnFreeze */
static short	f_iconize = SIZENORMAL;	/* Normal Window vs Iconic window */
static short	f_fitvideo = 1; 	/* Whether to fit video to window */
static short	f_savefitvideo = 1;
static short	f_toggled = 0;
static short	f_ScrollOff = FALSE;	/* =TRUE turn off scroll bars when maximized */
static short	wMaxWidth, wMaxHeight;	/* Dimensions of maximized window */
static HANDLE	hcwbBrush;		/* Brush to match colr key */
static short	orgcolor[7];		/* Original color settings */
POINT	worg;				/* Absolute window origin */
POINT   porg;				/* Pan position in video frame buffer */
BOOL bSuper = FALSE;			/* True if Super VHS */
short	videomode;			/* Current video type */


int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
	MSG msg;

	/* if first instance of application */
	if (!hPrevInstance)
		/* create and register window class */
		if (!InitApplication(hInstance)) 
			return(FALSE);

	if (!InitInstance(hInstance, nCmdShow)) 
		return(FALSE);

	while (GetMessage(&msg, NULL, NULL, NULL)) {
	/* Got a message for our application, dispatch it to MainWndProc() */

		if (!TranslateAccelerator(msg.hwnd, hAccel, &msg)) {
	/* Translate message only if it's not an accelerator message */
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return (msg.wParam);
}


/************************************************************************
*									*
*    FUNCTION: InitApplication(HANDLE)					*
*									*
*    PURPOSE: Initializes window data and registers window class	*
*									*
*    This function can be put in a Init segment (needed one time only)	*
*************************************************************************/

BOOL InitApplication(hInstance)
HANDLE hInstance;
{
	WNDCLASS  wc;

	/* Creating and registering a window class */
	wc.style = CS_VREDRAW | CS_HREDRAW ;
	wc.lpfnWndProc = MainWndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDS_APPS_ICON));
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = NULL; /*GetStockObject(WHITE_BRUSH); */
	wc.lpszMenuName =  MAKEINTRESOURCE(IDS_APPS_MENU);
	wc.lpszClassName = IDS_APPS_CLASS;

	return (RegisterClass(&wc));
}


/************************************************************************
*									*
*    FUNCTION:  InitInstance(HANDLE, int)				*
*									*
*    PURPOSE:  Saves instance handle and creates main window		*
*									*
*    This function can be put in a Init segment (needed one time only)	*
*									*
*************************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
HANDLE	hInstance;
int	nCmdShow;
{
	HDC		hDC;
	TEXTMETRIC	tm;
	HMENU		hMenu;

	hCur = LoadCursor(NULL, IDC_WAIT);	/* hour glass icon */
	hInst = hInstance;
	/* Get menu handle */
	hMenu = LoadMenu(hInstance, MAKEINTRESOURCE(IDS_APPS_MENU));
	hAccel = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDS_APPS_ACCEL));

	/* Creating the display window */
	hMainWnd = CreateWindow(IDS_APPS_CLASS, IDS_APPS_TITLE,
	    WS_OVERLAPPEDWINDOW | WS_HSCROLL | WS_VSCROLL,
	    CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
	    NULL, hMenu, hInstance, NULL);

	if (!hMainWnd) 
		return (FALSE);

	/* Active the window */
	ShowWindow(hMainWnd, nCmdShow);
	ShowScrollBar(hMainWnd, SB_BOTH, FALSE);
	UpdateWindow(hMainWnd);

	return(TRUE);
}


/************************************************************************
*									*
*    FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)			*
*									*
*    PURPOSE:  Processes messages					*
************************************************************************/
long	FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
unsigned	message;
WORD wParam;
LONG lParam;
{
	FARPROC lpProcAbout;
	HDC	hDC;
	HMENU	hMenu;
	PAINTSTRUCT	ps;
	int	err_code, i, xBorder, yBorder;
	LPPOINT lp;
	RECT	rWindowRect;
	WORD	xWndExt, yWndExt;

	switch (message) { /* Which system message ? */
	case WM_COMMAND:
		/* One of our menu command */
		switch (wParam) {
		/* Which of our menu command */
		case IDM_FREEZE:
			/* Freeze the screen */
			HandleFreeze();
			break;

		case IDM_FIT_VIDEO:
			/* Fit or unfit display to window */
			f_fitvideo ^= 1;
			f_savefitvideo = f_fitvideo;
toggle_scaling:
			porg.x = porg.y = 0;

			if (!f_fitvideo) {
				/* Don't fit display to window ie. no scaling */
				hMenu = GetMenu(hWnd);
				CheckMenuItem (hMenu, IDM_FIT_VIDEO, MF_UNCHECKED);

				/* Put up scroll bars if needed. */
				if (xWinSize < HORZ_PAN_RANGE) {
					ShowScrollBar(hWnd, SB_HORZ, TRUE);
					SetScrollPos(hWnd, SB_HORZ, porg.x, TRUE);
				} else 
					ShowScrollBar(hWnd, SB_HORZ, FALSE);

				if (yWinSize < VERT_PAN_RANGE) {
					ShowScrollBar(hWnd, SB_VERT, TRUE);
					SetScrollPos(hWnd, SB_VERT, porg.y, TRUE);
				} else 
					ShowScrollBar(hWnd, SB_VERT, FALSE);

			} else {
				hMenu = GetMenu(hWnd);
				CheckMenuItem (hMenu, IDM_FIT_VIDEO, MF_CHECKED);
				ShowScrollBar(hWnd, SB_BOTH, FALSE);
			}
			worg.x = worg.y = 0;
			ClientToScreen(hWnd, &worg);
			PCV_SetScrWinMap(porg.x, porg.y, worg.x, worg.y,
					xWinSize, yWinSize, f_fitvideo);

			if (f_fu == GF_FREEZE) 
				HandleFreeze();
			break;

		case IDM_SVHS:
			/* Switch between VHS and SVHS */
			bSuper = !bSuper;
			if (bSuper)
				CheckMenuItem (GetMenu (hWnd), IDM_SVHS, 
						MF_CHECKED);
			else
				CheckMenuItem (GetMenu (hWnd), IDM_SVHS, 
						MF_UNCHECKED);

			if (videomode) {
				/* Composite video */
				if (bSuper)
					PCV_SetComposite (PCV_SVHS | videomode);
				else
					PCV_SetComposite (videomode);
			}
			break;

		case IDM_RGB:
		case IDM_NTSC:
		case IDM_SECAM:
			hMenu = GetMenu(hWnd);
			videomode = 0;

			/* Uncheck all modes */
			CheckMenuItem (hMenu, IDM_RGB, MF_UNCHECKED);
			CheckMenuItem (hMenu, IDM_NTSC, MF_UNCHECKED);
			CheckMenuItem (hMenu, IDM_SECAM, MF_UNCHECKED);
			CheckMenuItem (hMenu, wParam, MF_CHECKED);

			if (wParam == IDM_RGB) {
				/* RGB format */
				PCV_SetRGB (PCV_RS170LEVEL);
			} else if (wParam == IDM_NTSC) {
				/* NTSC/PAL format */
				videomode = PCV_NTSC;
				PCV_SetComposite (PCV_NTSC);
				if (bSuper) 
					PCV_SetComposite (PCV_NTSC | PCV_SVHS);
			} else {
				/* SECAM format */
				videomode = PCV_SECAM;
				PCV_SetComposite (PCV_SECAM);
				if (bSuper) 
					PCV_SetComposite (PCV_SECAM | PCV_SVHS);
			}
			break;

		case IDM_ABOUT:
			/* About box */
			lpProcAbout = MakeProcInstance(AboutDlgProc, hInst);
			DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
			FreeProcInstance(lpProcAbout);
			break;

		default:
			return(FALSE);
		}
		break;

	case WM_CREATE:	
		/* Creating color brush to match color key */
		hcwbBrush = CreateSolidBrush(RGB(255, 0, 255));
		hDC = GetDC(hWnd);		/* Get number of colors. */
		i = GetDeviceCaps(hDC, BITSPIXEL);
		i = (short)pow(2, i * GetDeviceCaps(hDC, PLANES));
		PCV_SetColorKey(i - 3);	/* Temporary work-around */
		hMenu = GetMenu(hWnd);
		porg.x = porg.y = 0;

		HORZ_PAN_RANGE = 640 - GetSystemMetrics(SM_CYVSCROLL);
		VERT_PAN_RANGE = 480 - GetSystemMetrics(SM_CXHSCROLL);
		/* set up frame buffer and video acquire window mapping */
		i = PCV_SetAcqWinMap (0, 0, 640, 480, 0, 0, 640, 480);
		break;

	case WM_MOVE:
		/* Window is moved */
		if (f_iconize == SIZEICONIC) 
			goto draw_icon;

		worg.x = worg.y = 0;
		ClientToScreen(hWnd, &worg);
		/* reposition the screen window */
		PCV_SetScrWinMap(porg.x, porg.y, worg.x, worg.y, xWinSize, 
					yWinSize, f_fitvideo);
		InvalidateRect(hWnd, NULL, TRUE);  /* Draw it at one place */
		break;

	case WM_GETMINMAXINFO:
		/* window is maximize */
		xBorder = 2 * GetSystemMetrics(SM_CXFRAME);
		yBorder = 2 * GetSystemMetrics(SM_CYFRAME);
		yBorder = yBorder + GetSystemMetrics(SM_CYMENU) + 
				GetSystemMetrics(SM_CYCAPTION);
		lp = (LPPOINT) lParam;

		if ((lp[1].x >= HORZ_PAN_RANGE + xBorder) && 
				(lp[1].y >= VERT_PAN_RANGE + yBorder)) {
			lp[2].x = 0;
			lp[2].y = 0;
			/* Turn off scroll bars when maximized */
			f_ScrollOff = TRUE; 
		}
		wMaxWidth  = lp[4].x = lp[1].x = min(lp[1].x, 
						     HORZ_PAN_RANGE + xBorder);
		wMaxHeight = lp[4].y = lp[1].y = min(lp[1].y, 
						     VERT_PAN_RANGE + yBorder);
		break;

	case WM_SIZE:
		/* size of window is changed */
		xWinSize = LOWORD(lParam);
		yWinSize = HIWORD(lParam);

		/* if size of window greater than frame buffer, resize
		   window to size of frame buffer */
		if (xWinSize > HORZ_PAN_RANGE) {
			xWinSize = HORZ_PAN_RANGE;
			SetWindowPos(hWnd, hWnd, 0, 0, xWinSize, yWinSize, 
					SWP_NOMOVE | SWP_NOZORDER);
		}

		if (f_fu == GF_FREEZE && f_fitvideo) 
			HandleFreeze();

		/* window is resize to an icon */
		if ((f_iconize = wParam) == SIZEICONIC) {
draw_icon:
			worg.x = worg.y = 0;
			ClientToScreen(hWnd, &worg);
			/* Remap screen window */
			PCV_SetScrWinMap(porg.x, porg.y, worg.x, worg.y, 
						xWinSize, yWinSize, f_fitvideo);
			break;
		} else if (wParam == SIZEFULLSCREEN) {
			if (f_fitvideo && !f_toggled) {
				/* Temporarily disable scaling. */
				f_fitvideo = 0;
				f_toggled = 1;
				goto toggle_scaling;
				break;
			}
		} else {
			f_toggled = 0;
			if (f_fitvideo != f_savefitvideo) {
				f_fitvideo = f_savefitvideo;
				goto toggle_scaling;
			}
		}

		/* Remap screen window */
		PCV_SetScrWinMap(porg.x, porg.y, worg.x, worg.y, xWinSize, 
					yWinSize, f_fitvideo);
		if (!f_fitvideo) {
			if (f_ScrollOff) {
				/*
			If the window is the maximized size and if this is big
			enough to show all video full size, remove the scroll
			bars.
			*/
				GetWindowRect(hWnd, (LPRECT) & rWindowRect);
				xWndExt = rWindowRect.right - rWindowRect.left;
				yWndExt = rWindowRect.bottom - rWindowRect.top;

				if ((xWndExt == wMaxWidth) && 
						(yWndExt == wMaxHeight)) {
					ShowScrollBar(hWnd, SB_BOTH, FALSE);
					PCV_SetScrWinMap(porg.x, porg.y, worg.x,
					worg.y, xWinSize, yWinSize, f_fitvideo);
					break;
				}
			}

			/* Set scroll bar ranges. */
			SetScrollRange(hWnd, SB_HORZ, 0, 
				      min(HORZ_PAN_RANGE - 1, 
					  HORZ_PAN_RANGE - xWinSize - 1), TRUE);
			porg.x = min(HORZ_PAN_RANGE - xWinSize - 1, porg.x);
			SetScrollRange(hWnd, SB_VERT, 0, min(VERT_PAN_RANGE - 1,
					 VERT_PAN_RANGE - yWinSize - 1), TRUE);
			porg.y = min(VERT_PAN_RANGE - yWinSize - 1, porg.y);

			/* remap screen window */
			PCV_SetScrWinMap(porg.x, porg.y, worg.x, worg.y, 
						xWinSize, yWinSize, f_fitvideo);
		}
		break;

	case WM_ERASEBKGND:
		break;	/* return(TRUE) so Window should not paint */

	case WM_PAINT:	
		/* Every PAINT message must have BeginPaint() & EndPaint() */
		worg.x = worg.y = 0;
		ClientToScreen(hWnd, &worg);
		PCV_SetScrWinMap(porg.x, porg.y, worg.x, worg.y, xWinSize, 
			yWinSize, f_fitvideo);

		if (f_iconize != SIZEICONIC) {
			hDC = BeginPaint(hWnd, &ps);
			/* Erase background */
			FillRect(hDC, &(ps.rcPaint), hcwbBrush);
			EndPaint(hWnd, &ps);
		}
		break;

	case WM_VSCROLL:
		switch (wParam) {
		case SB_PAGEDOWN:
			porg.y += 12;
		case SB_LINEDOWN:
			porg.y = min(VERT_PAN_RANGE - yWinSize - 1, porg.y + 4);
			break;
		case SB_PAGEUP:
			porg.y -= 12;
		case SB_LINEUP:
			porg.y = max(0, porg.y - 4);
			break;
		case SB_TOP:
			porg.y = 0;
			break;
		case SB_BOTTOM:
			porg.y = VERT_PAN_RANGE - yWinSize - 1;
			break;
		case SB_THUMBPOSITION:
		case SB_THUMBTRACK:
			porg.y = LOWORD(lParam);
			break;
		default:
			return(FALSE);
		}
		SetScrollPos(hWnd, SB_VERT, porg.y, TRUE);

		/* reposition screen window */
		PCV_SetScrWinMap(porg.x, porg.y, worg.x, worg.y, 
					xWinSize, yWinSize, f_fitvideo);
		break;

	case WM_HSCROLL:
		switch (wParam) {
		case SB_PAGEDOWN:
			porg.x += 12;
		case SB_LINEDOWN:
			porg.x = min(HORZ_PAN_RANGE - xWinSize - 1, porg.x + 4);
			break;
		case SB_PAGEUP:
			porg.x -= 12;
		case SB_LINEUP:
			porg.x = max(0, porg.x - 4);
			break;
		case SB_TOP:
			porg.x = 0;
			break;
		case SB_BOTTOM:
			porg.x = HORZ_PAN_RANGE - xWinSize - 1;
			break;
		case SB_THUMBPOSITION:
		case SB_THUMBTRACK:
			porg.x = LOWORD(lParam);
			break;
		default:
			return(FALSE);
		}
		SetScrollPos(hWnd, SB_HORZ, porg.x, TRUE);

		/* reposition screen window */
		PCV_SetScrWinMap(porg.x, porg.y, worg.x, worg.y, xWinSize, 
					yWinSize, f_fitvideo);
		break;

	case WM_DESTROY:
		PCV_Display(0);
		DeleteObject(hcwbBrush);	/* Delete previous brush */
		PostQuitMessage(0);
		break;

	default:
		return(DefWindowProc(hWnd, message, wParam, lParam));
	}
	return(FALSE);
}


/**************************************************************************
* HandleFreeze() - Toggles freeze and unfreeze menu and does real funtion *
**************************************************************************/
int	HandleFreeze()
{
	HMENU	hMenu;

	f_fu ^= GF_UNFREEZE;		/* Toggle UNFREEZE/FREEZE */
	hMenu = GetMenu(hMainWnd);
	ModifyMenu(hMenu, IDM_FREEZE, MF_STRING, IDM_FREEZE, fu_mtext[f_fu]);
	if (f_fu) 
		PCV_Freeze(0);
	else 
		PCV_Freeze(1);
}


/************************************************************************
*    FUNCTION: AboutWndProc(HWND, unsigned, WORD, LONG)			*
*    PURPOSE:  Processes messages for "About" dialog box		*
*    MESSAGES:								*
*        WM_INITDIALOG - initialize dialog box				*
*        WM_COMMAND    - Input received					*
************************************************************************/

BOOL FAR PASCAL AboutDlgProc(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned	message;
WORD wParam;
LONG lParam;
{
	switch (message) {
	case WM_INITDIALOG:
		return (TRUE);
	case WM_COMMAND:
		if (wParam == IDOK || wParam == IDCANCEL) {
			EndDialog(hDlg, TRUE);
			return (TRUE);
		}
		break;
	}
	return (FALSE);
}


