' ========================  DOUBLETALK PC QB DEMO  ==========================
'
' This program demonstrates each of the routines supplied with the
' DoubleTalk PC QuickBASIC library package.  In order for the examples to
' run from within the QuickBASIC environment, the DTQB.QLB Quick Library
' must first be created and loaded.  To create the Quick Library, type the
' following from the DOS command line:
'
'   LINK /q DTQB.LIB,DTQB.QLB,,BQLB45;                (QB 4.5)
'   LINK /q DTQBX.LIB,DTQBX.QLB,,QBXQLB;              (PDS 7.x)
'
' Load the new Quick Library by including it in the QuickBASIC invocation
' command line:
'
'   QB /l DTQB                                        (QB 4.5)
'   QBX /l DTQBX                                      (PDS 7.x)
'
'
' Combining Other Libraries
' -------------------------
' If you are using another vendor's library with QuickBASIC, you can
' combine it with the DoubleTalk library by following these steps:
'
' To combine the DoubleTalk library and other library into a new
' Quick Library called MY.QLB:
'
'   LINK /q DTQB.LIB + otherlib.LIB,MY.QLB,,BQLB45;   (QB 4.5)
'   LINK /q DTQBX.LIB + otherlib.LIB,MY.QLB,,QBXQLB;  (PDS 7.x)
'
' To combine the DoubleTalk library and other library into a new
' library called MY.LIB:
'
'   LIB DTQB  (PDS 7.x = DTQBX)
'   Operations: +otherlib.LIB
'   List file: <ENTER>
'   Output file: MY.LIB
'
' Start QuickBASIC:
'   QB /l MY                                          (QB 4.5)
'   QBX /l MY                                         (PDS 7.x)
'
' ===========================================================================


DEFINT A-Z

' $DYNAMIC                      ' allows LPC, PCM and TGN data arrays to
                                ' be dynamically allocated

' $INCLUDE: 'DTDECLAR.BI'       ' DTQB library declarations




' --- Init example (DTINIT)
  
' DTINIT initializes the DTQB library and DoubleTalk for use with your
' applications.  Every application program that uses DTQB must use this
' function prior to calling any other DTQB routines.  Among other things,
' DTINIT determines the I/O base address of DoubleTalk (set by the jumper
' block on the card), which is used by most of the other DTQB functions.
' If DoubleTalk was found in the computer, its command character is reset
' to ^A, then reinitialized with the ^A-@ command.  DoubleTalk's base
' I/O address is returned as a two-byte integer, which can be used to
' determine whether or not DoubleTalk is installed in the computer, and/or
' to perform direct hardware I/O with DoubleTalk (see "Tone generator
' example" below).


        PRINT : PRINT "DTINIT function..."
       
        DTAdr = DTINIT          ' DT base I/O address returned from DTINIT
        IF DTAdr = 0 THEN PRINT "DoubleTalk not installed!": END
        PRINT "DoubleTalk base address: "; HEX$(DTAdr); "h"




' --- Get ROM version example (ROMVER$)

' This function returns DoubleTalk's ROM version as a text string.


        PRINT : PRINT "ROMVER$ function..."

        PRINT "DoubleTalk ROM version: "; ROMVER$




' --- Get serial number example (SERNUM)

' This function returns DoubleTalk's serial number as a two-byte integer.


        PRINT : PRINT "SERNUM function..."

        PRINT "DoubleTalk serial number: "; SERNUM




' --- Status example (DTSTS)

' This function returns the status of DoubleTalk's TTS and LPC
' synthesizers.  This information can be used by an application program
' to determine when either synthesizer is finished speaking a phrase,
' allowing other events (such as animation) to be synchronized with
' the speech.


        PRINT : PRINT "DTSTS function..."
       
        StsCode& = DTSTS
        IF StsCode& < 0 THEN StsCode& = StsCode& + 65536
        LPCSts = StsCode& \ 256: TTSSts = StsCode& MOD 256
        PRINT "LPC status="; HEX$(LPCSts); "h    ";
        PRINT "TTS status="; HEX$(TTSSts); "h"




' --- TTS output example (SAY)

' As its name implies, SAY literally speaks the string specified in the
' subroutine's argument.  DoubleTalk commands can also be issued by sending
' them as text strings by themselves, or embedding them within the text
' of a string.


        PRINT : PRINT "SAY subroutine..."
       
        SAY "This is an example of DoubleTalk's text-to-speech synthesizer."




' --- Translate example (XLT$)

' This function converts an ASCII text string into a phoneme string.
' Note that the phoneme string returned is in compiled form (that used
' internally by DoubleTalk).  The program TXTPHM.BAS demonstrates how
' the compiled phoneme string can be decompiled into the standard ASCII
' format.  NOTE: You must make sure that DoubleTalk is in Text mode
' before using this subroutine.  If you want the exception dictionary to
' be used in the translation, issue the command ^A-U before calling
' XLT$.  See the example below.


        PRINT : PRINT "XLT$ function..."
       
        SAY CHR$(1) + "T"       ' force Text mode
        SAY CHR$(1) + "U"       ' enable dictionary (optional)
        T$ = "medicine"
        P$ = XLT$(T$)
        PRINT T$; " (text) = "; P$; " (phonetic)"




' --- Interrogate example (INTGT)

' This subroutine returns the current settings of DoubleTalk's TTS
' synthesizer in an integer array.


        DIM B(10)               ' currently 11 parms returned from call
        CALL INTGT(B(0))


' The order in which the values are returned is shown in the table
' below.  The table also shows the command(s) that control the parameter,
' and the parameter's range (as returned by the INTGT routine).

' Parameter          Command     Range
' =========          =======     =====
' Mode               C/D/T       0=Character; 1=Phoneme; 2=Text
' Punc level         mB          0-7
' Formant freq       mF          0-9
' Pitch              mP          0-99
' Speed              mS          0-9
' Volume             mV          0-9
' Tone               mX          0-2
' Intonation         E/M         0=disabled (monotone); 1=enabled
' Exc Dict loaded    L           1=exception dictionary loaded; 0 otherwise
' Exc Dict status    U           1=exception dictionary enabled; 0 otherwise
' Free RAM           L           # pages (truncated) remaining for text buffer -
'                                function of dictionary size and RAM chip installed




' --- TTS text buffer control example (TTSBUFOFF, TTSBUFON)

' DoubleTalk's TTS synthesizer contains a 2.5K byte text buffer, enabling
' the synthesizer to speak in the background of an application program.
' If you need to disable the text buffer, you may do so with the TTSBUFOFF
' command.  (The text buffer is not actually disabled in the hardware;
' rather, subsequent calls to the SAY subroutine simply wait for the TTS
' synthesizer to finish speaking before returning control to your program.)


        TTSBUFOFF               ' disable buffer
        TTSBUFON                ' enable buffer (default)


                                        

' --- LPC output example (LPC)

' This subroutine activates and drives the LPC synthesizer.  You must pass
' two arguments to the subroutine: The first specifies the location in
' memory of the LPC data file - the second specifies the location in memory
' of the list of words (or phrases) to be spoken from the LPC data file.
' This particular example loads a data file into a double-precision array
' and passes its address to the subroutine.  The list of words to be spoken
' is stored in a second (integer) array as a list of indexes, and its
' address is also passed to the subroutine.  The subroutine returns control
' to the caller when a word/phrase index number of 0 is encountered.
' Note that more than one LPC data file can be resident in memory at one
' time, and memory can be dynamically allocated for each of them.  Both
' 5220 and D6 LPC formats are supported - see the documentation on this
' disk for further details.


        PRINT : PRINT "LPC subroutine..."

        LPCDataFile$ = "WORDS2.LPC"     ' LPC data file


' Allocate storage for LPC data file in LPCData().  Use DOUBLE type
' because 8 bytes of data are loaded for each GET #, which improves
' file access time by as much as four-fold.  Array name is arbitrary.

        DIM LPCData(8000) AS DOUBLE     ' (8 * 8000, or 64000 bytes)
        I = 0

' load data file into array:
        OPEN LPCDataFile$ FOR BINARY AS #255
        DO UNTIL EOF(255)
           GET #255, , LPCData(I)
           I = I + 1
        LOOP
        CLOSE #255

' load array with list of word/phrase indexes to speak:
        DIM WrdArry(20)
        I = 0: A = 99

        DO WHILE A <> 0
           READ A
           WrdArry(I) = A
           I = I + 1
        LOOP
        DATA 31,32,35,35,1,2,3,15,19,4,0

' say the words:
        CALL LPC(LPCData(0), WrdArry(0))




' --- LPC speed example (LPCSPD)

' This subroutine controls the speed (normal or 47% faster) of all subsequent
' LPC speech output.  Both LPC and LPCRPT are affected by this setting.


        PRINT : PRINT "LPCSPD subroutine..."

' say same words from the prior example, at fast speed:
        Normal = 0: Fast = 1
        LPCSPD (Fast)
        CALL LPC(LPCData(0), WrdArry(0))




' --- LPC repeat example (LPCRPT)

' The repeat subroutine causes the last word (or phrase) sent to the LPC
' synthesizer to be repeated.  This may seem to be somewhat of a useless
' function, since the application program could simply call the LPC function
' again with the same word/phrase number.  The repeat subroutine, however,
' causes DoubleTalk to repeat the last word or phrase in its hardware buffer
' (sort of a "replay").  This speeds up program execution because the
' application doesn't have to re-send the LPC data to DoubleTalk.


        PRINT : PRINT "LPCRPT subroutine..."

' say a word at fast speed, then repeat it at normal speed:
        WrdArry(0) = 32: WrdArry(1) = 255
        LPCSPD (Fast)
        CALL LPC(LPCData(0), WrdArry(0))
        LPCSPD (Normal)
        LPCRPT
      
        ERASE LPCData           ' good idea to free memory used by
                                ' LPC data file when finished using it




' --- LPC data buffer control example (LPCBUFOFF, LPCBUFON)

' The LPC synthesizer contains a 4K byte data buffer, enabling an
' application program to speak for up to 30 seconds while doing other
' things (such as animation).  This buffer is also what makes the LPCRPT
' function possible.  If you need to disable the buffer for one reason
' or another, you may do so with the LPCBUFOFF command.  (The hardware
' buffer is not actually disabled; rather, the LPC driver simply waits
' for the synthesizer to stop talking before returning to your program.)
' Note that the LPCRPT command is still operative with the buffer
' disabled, but it too will wait until the synthesizer has stopped
' talking before returning control to you.


        LPCBUFOFF               ' disable buffer
        LPCBUFON                ' enable buffer (default)




' --- PCM sampling rate example (PCMRATE)

' This subroutine sets the sampling rate (playback speed) for the PCM
' synthesizer.  The argument must evaluate to a value between 0 and 99.
' The relationship between the argument's value n and the sampling rate
' fs is:
'
'       fs = 617/(155 - n)   (kHz)
'
' Ordinarily the sampling rate should be set to the same rate the PCM
' data was originally sampled at, but playing it back faster or slower
' can have some pretty interesting effects!


        PCMRATE (99)            ' program 11 kHz sampling rate




' --- PCM output example (PCM)

' This subroutine activates DoubleTalk's PCM synthesizer.  The subroutine's
' syntax and usage is identical to that of the LPC subroutine (see "LPC
' output example," above).  Both PCM and ADPCM (compressed) formats are
' supported - see the documentation on this disk for further details.


        PRINT : PRINT "PCM subroutine..."

        PCMDataFile$ = "PORTAL.PCM"     ' PCM data file
        DIM PCMData(8000) AS DOUBLE
        I = 0

' load data file into array:
        OPEN PCMDataFile$ FOR BINARY AS #255
        DO UNTIL EOF(255)
           GET #255, , PCMData(I)
           I = I + 1
        LOOP
        CLOSE #255

' load array with list of sound indexes to play:
        DIM IndxArry(20)
        I = 0: A = 99

        DO WHILE A <> 0
           READ A
           IndxArry(I) = A
           I = I + 1
        LOOP
        DATA 1,0

' program desired sampling rate and call the PCM routine:
        PCMRATE (78)            ' 8 kHz
        CALL PCM(PCMData(0), IndxArry(0))

        ERASE PCMData           ' free memory of PCM data when finished




' --- Tone generator example (TONES1)

' This subroutine activates DoubleTalk's tone generators.  The subroutine
' requires three arguments.  The first specifies the location in memory
' of the TGN data file - the second sets the volume at which the tone file
' will be played, and the third sets the tempo.  For TGN data file format
' information, see the documentation on this disk.


        PRINT : PRINT "TONES1 subroutine..."

        TGNDataFile$ = "GROOVY.TGN"     ' tone data file
        DIM TGNData(100) AS LONG
        I = 0

' load data file into array:
        OPEN TGNDataFile$ FOR BINARY AS #255
        DO UNTIL EOF(255)
           GET #255, , TGNData(I)
           I = I + 1
        LOOP
        CLOSE #255

' play the tones:
        TGNVol = 200            ' volume (1-255)
        TGNTmpo = 86            ' tempo (1-65535)
        CALL TONES1(TGNData(0), TGNVol, TGNTmpo)

        ERASE TGNData           ' free memory of TGN data when finished


END

