; DT_INTGT.ASM
;
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;                               NOTICE                                      ;
;                                                                           ;
; This software is proprietary to RC Systems, Inc., and is provided as a    ;
; development tool for third party software developers who are developing   ;
; software for the DoubleTalk speech synthesizers. Disclosure of the source ;
; or object code in any form to any other party is strictly prohibited.     ;
;                                                                           ;
;                 Copyright (C) 1992 RC Systems, Inc.                       ;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
;
; Description and use:
;
; DT_Intgt
;    This procedure interrogates DoubleTalk and returns its
;    current settings. On entry, ES:DI should point to the
;    beginning of your data buffer. On exit, CX contains
;    the byte count (length) of the buffer. See README.TXT
;    for a description of the parameters returned.
;
;
;
	  PUBLIC  DT_Intgt

	  .DATA
	  EXTRN   TTS_Port:WORD ; TTS port address of DoubleTalk
				;  (determined by DT_Init; see DT_TTS.ASM)


	  .CODE
	  EXTRN   DT_Tts:FAR    ; TTS write routine (DT_TTS.ASM)
	  EXTRN   DT_Rd:FAR     ; DT read routine (DT_TTS.ASM)
; *********************************************************
;         DT_Intgt: Return current DT parm settings
;
;         Input: ES:DI = address of parm data buffer
;         Output:   CX = number of bytes placed in buffer
; *********************************************************

DT_Intgt  PROC   FAR

	  mov     ah,18h        ; issue interrogate command to DT
	  call    DT_Tts        ;  (DT_Init must have been called
	  mov     ah,1          ;  prior to this!)
	  call    DT_Tts
	  mov     ah,'?'
	  call    DT_Tts
	  cld
	  xor     cx,cx

Igt0:     call    DT_Rd         ; read parms from DT (7fh = end)
	  cmp     al,7fh
	  jne     Igt1
	  cmp     cx,2          ; serial # may contain 7fh byte
	  ja      Igt2
Igt1:     stosb
	  inc     cx
	  jmp     Igt0
Igt2:     ret

DT_Intgt  ENDP
