; DT_LPC.ASM
;
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;                               NOTICE                                      ;
;                                                                           ;
; This software is proprietary to RC Systems, Inc., and is provided as a    ;
; development tool for third party software developers who are developing   ;
; software for the DoubleTalk speech synthesizers. Disclosure of the source ;
; or object code in any form to any other party is strictly prohibited.     ;
;                                                                           ;
;                 Copyright (C) 1992 RC Systems, Inc.                       ;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
;
; Description and use:
;
; DT_Lpc
;    This procedure outputs standard LPC-10 (5220 and D6)
;    data to DoubleTalk's LPC synthesizer. On entry, the
;    procedure expects ES:DI to be pointing to the LPC data
;    buffer and CX to contain the byte count (length).
;
;    NOTE: This procedure cannot be used with the PC/104
;    version of DoubleTalk, since it has no LPC synthesizer.
;    Inspection of the value of the LPC_Port variable will
;    enable a program to determine if the DoubleTalk in use
;    supports LPC; if it is non-zero, LPC is supported. See
;    DT_TTS.ASM for more information.
;
;
;
	  PUBLIC  DT_Lpc

	  .DATA
	  EXTRN   LPC_Port:WORD ; LPC port address of DoubleTalk
				;  (determined by DT_Init; see DT_TTS.ASM)
	  EXTRN   Internal:BYTE ; 1 if DTPC, 0 if DTLT
				;  (determined by DT_Init; see DT_TTS.ASM)


	  .CODE
	  EXTRN   Com_Wr:NEAR   ; serial output routine (DT_TTS.ASM)
	  EXTRN   Com_Rd:NEAR   ; serial input routine (DT_TTS.ASM)
; *********************************************************
;         DT_Lpc: Write LPC data to LPC port
;
;         Input: ES:DI = address of LPC data buffer
;                   CX = number of data bytes in buffer
;         Output: nothing
; *********************************************************

DT_Lpc    PROC    FAR

	  call    LPC_Wait      ; wait for last word to finish
	  call    LPC_Sts       ;  so DTLT will recognize Speak command
	  mov     ah,60h        ; initialize LPC synthesizer, 5220 format
	  call    LPC_Wr        ;  (64h = fast); use 20h/24h for D6 format
	  call    LPC_Dly       ; ... exit here for Repeat function

	  mov     bx,4000       ; output the LPC data
L1:       dec     bx
	  jnz     L3
	  mov     bx,4000
L2:       call    LPC_Sts       ; check LPC BL flag every 4000 bytes
	  and     al,0c0h
	  jz      L4            ; hardware error condition
	  test    al,40h
	  jz      L2
L3:       mov     ah,es:[di]
	  inc     di
	  call    LPC_Wr
	  loop    L1
L4:       ret

DT_Lpc    ENDP



; *********************************************************
;         LPC_Wr: Write byte to LPC port
;
;         Input: AH = byte to output
;         Output: nothing
; *********************************************************

LPC_Wr    PROC    NEAR

	  cmp     Internal,1
	  jne     LW10

	  mov     dx,LPC_Port   ; (DTPC)
	  mov     al,ah
	  out     dx,al
	  call    LPC_Dly
	  ret

LW10:     push    ax            ; (DTLT)
	  shr     ah,1
	  shr     ah,1
	  shr     ah,1
	  shr     ah,1
	  or      ah,50h
	  call    Com_Wr
	  pop     ax
	  and     ah,0fh
	  or      ah,60h
	  call    Com_Wr
	  ret

LPC_Wr    ENDP



; *********************************************************
;         LPC_Dly: LPC delay
;
;         Input: nothing
;         Output: nothing
; *********************************************************

LPC_Dly   PROC    NEAR

	  push    cx
	  mov     cx,500
	  xor     al,al         ; set zf
LD0:      loopnz  LD0           ; magic time constant (jump never taken)
	  loopnz  LD0           ;  each loopnz takes 5 clocks for 8088;
	  loopnz  LD0           ;  11 clocks for 80386
	  loop    LD0
	  pop     cx
	  ret

LPC_Dly   ENDP



; *********************************************************
;         LPC_Wait: Exits when LPC synthesizer is finished
;
;         Input: nothing
;         Output: nothing
; *********************************************************

LPC_Wait  PROC    NEAR

	  cmp     Internal,1
	  jne     LWt10

LWt0:     call    LPC_Sts       ; (DTPC)
	  test    al,80h
	  jnz     LWt0
	  call    LPC_Dly
	  ret

LWt10:    mov     dx,LPC_Port   ; (DTLT)
	  add     dx,6          ; MSR
LWt11:    in      al,dx         ; wait for RI to drop
	  test    al,40h
	  jz      LWt11
	  ret

LPC_Wait  ENDP



; *********************************************************
;         LPC_Sts: Returns LPC status
;
;         Input: nothing
;         Output: AL = status
; *********************************************************

LPC_Sts   PROC    NEAR

	  cmp     Internal,1
	  jne     LS10

	  mov     dx,LPC_Port   ; (DTPC)
	  in      al,dx
	  ret

LS10:     mov     ah,40h        ; (DTLT)
	  call    Com_Wr
	  call    Com_Rd
	  ror     al,1
	  ror     al,1
	  ror     al,1
	  ret

LPC_Sts   ENDP
