; DT_PCM.ASM
;
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;                               NOTICE                                      ;
;                                                                           ;
; This software is proprietary to RC Systems, Inc., and is provided as a    ;
; development tool for third party software developers who are developing   ;
; software for the DoubleTalk speech synthesizers. Disclosure of the source ;
; or object code in any form to any other party is strictly prohibited.     ;
;                                                                           ;
;                 Copyright (C) 1992 RC Systems, Inc.                       ;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
;
; Description and use:
;
; DT_Pcm
;    This procedure outputs PCM data to DoubleTalk's PCM hardware.
;    On entry, the procedure expects ES:DI to be pointing to the
;    PCM data buffer and CX to contain the byte count (length).
;    Register BL should be set to the desired playback sampling
;    rate, 0-99d (4-11 kHz). If DoubleTalk LT (referred to as
;    "external" in the source code comments) is detected, up/down
;    sampling and baud rate adjustments are performed automatically.
;
;
;
	  PUBLIC  DT_Pcm

	  .DATA
	  EXTRN   TTS_Port:WORD ; TTS port address of DoubleTalk
				;  (determined by DT_Init; see DT_TTS.ASM)
	  EXTRN   Internal:BYTE ; 1 if DTPC, 0 if DTLT
				;  (determined by DT_Init; see DT_TTS.ASM)
Cmd3      DB      1eh,1
PCM_SR    DW      '00'
	  DB      '#'
C3Len     EQU     $-Cmd3
Smpl_K    DB      0             ; for up/down-sampling (external)
Samples   DB      0


	  .CODE
	  EXTRN   DT_Tts:FAR    ; TTS write routine (DT_TTS.ASM)
	  EXTRN   CnfgCom:NEAR  ; configures com port (DT_TTS.ASM)
	  EXTRN   Com_Wr:NEAR   ; serial output routine (DT_TTS.ASM)
; *********************************************************
;         Pcm: PCM output driver
;
;         Input: ES:DI = address of PCM data buffer
;                   CX = number of data bytes in buffer
;                   BL = sampling rate (0-99d)
;         Output: nothing
; *********************************************************

DT_Pcm    PROC    FAR

	  mov     al,bl         ; bl = sample rate (binary)
	  cbw
	  aam                   ; convert to 2-digit ASCII
	  add     ax,'00'
	  xchg    al,ah
	  mov     PCM_SR,ax     ; for PCM mode command
	  xor     al,al         ; calculate up/dn sampling constant (external)
	  sub     bl,78         ; (Use 78# command for min. distortion @ 8 kHz)
	  jz      DP1           ; 8.0 kHz: no adjustment necessary
	  mov     ax,82         ; 82 / (n - 78)
	  idiv    bl
DP1:      mov     Smpl_K,al
	  mov     Samples,al

	  push    cx             ; initiate PCM mode
	  mov     si,OFFSET Cmd3
	  mov     cx,C3Len
DP2:      mov     ah,[si]
	  inc     si
	  call    DT_Tts
	  loop    DP2
	  mov     ah,1          ; 115200 baud (external)
	  call    CnfgCom
	  pop     cx

DP3:      mov     ah,es:[di]    ; send each sample to DT
	  inc     di
	  cmp     ah,80h        ; in case looks like end-of-data byte
	  je      DP4
	  call    PCM_Wr
DP4:      loop    DP3

	  mov     ah,80h        ; send end-of-data byte
	  call    DT_Tts

	  mov     ah,12         ; back to 9600 baud (external)
	  call    CnfgCom

	  ret

DT_Pcm    ENDP



; *********************************************************
;         PCM_Wr: Writes PCM sample to TTS port
;
;         Input: AH = sample to output
;         Output: nothing
; *********************************************************

PCM_Wr    PROC    NEAR

	  cmp     Internal,1
	  jne     PW10

	  call    DT_Tts        ; (internal)
	  ret

PW10:     cmp     Smpl_K,0      ; (external)
	  je      PW12
	  js      PW11

	  dec     Samples       ; up-sample
	  jnz     PW12
	  mov     al,Smpl_K
	  mov     Samples,al
	  ret

PW11:     inc     Samples       ; down-sample
	  jnz     PW12
	  push    ax
	  call    Com_Wr
	  pop     ax
	  mov     al,Smpl_K
	  mov     Samples,al

PW12:     call    Com_Wr
	  ret

PCM_Wr    ENDP
