; DT_XLT.ASM
;
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;                               NOTICE                                      ;
;                                                                           ;
; This software is proprietary to RC Systems, Inc., and is provided as a    ;
; development tool for third party software developers who are developing   ;
; software for the DoubleTalk speech synthesizers. Disclosure of the source ;
; or object code in any form to any other party is strictly prohibited.     ;
;                                                                           ;
;                 Copyright (C) 1992 RC Systems, Inc.                       ;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
;
; Description and use:
;
; DT_Xlt
;    This procedure converts a text string into a phoneme
;    string, using DoubleTalk's built in text-to-phoneme
;    translator. On entry, ES:SI should point to the
;    beginning of the input text string, ES:DI the phoneme
;    buffer (the output), and CX should be set to the length
;    of the text string. On return, the value of CX indicates
;    the number of phonemes returned in the phoneme buffer.
;
;    Before DT_Xlt is called, you should ensure that Text
;    mode is the current operating mode of the TTS
;    synthesizer (^A-T). If you want the exception
;    dictionary to be used in the translation, enable it
;    with ^A-U after issuing the Text mode command.
;
;    Note that the phoneme string returned by this function
;    is in compiled form (that used internally by DoubleTalk).
;    Single-character phonemes, such as I, K, T, etc., are
;    returned unchanged, and are always an uppercase letter.
;    Double-character phonemes, such as AA, IY, SH, etc., are
;    returned as single-character tokens, and are never
;    uppercase letters. Use the lookup table below to convert
;    these tokens into the corresponding phonemes.
;
;
;     Token   Phoneme         Token   Phoneme
;
;       a       UW              t       AY
;       b       UH              u       AX
;       c       TH              v       AW
;       d       SH              w       AO
;       g       OY              x       AH
;       h       OW              y       AE
;       i       NY              z       AA
;       j       NX              %       ZH
;       k       JH              $       YY
;       l       IY              #       WH
;       m       IH              _       TX
;       n       EY              `       PX
;       o       ER              >       KX
;       p       EI              {       IX
;       q       EH              <       DX
;       r       DH              !       RR
;       s       CH              *       EW
;
;
;    For example, the phoneme string "DuBuLTzK" translates
;    to "D AX B AX L T AA K."
;
;
;
	  PUBLIC  DT_Xlt

	  .DATA
	  EXTRN   TTS_Port:WORD ; TTS port address of DoubleTalk
				;  (determined by DT_Init; see DT_TTS.ASM)


	  .CODE
	  EXTRN   DT_Tts:FAR    ; TTS write routine (DT_TTS.ASM)
	  EXTRN   DT_Rd:FAR     ; DT read routine (DT_TTS.ASM)
; *********************************************************
;         DT_Xlt: Return phoneme string
;
;         Input: ES:SI = address of input text string
;                ES:DI = address of output phoneme string
;                   CX = number of bytes in text string
;         Output:   CX = number of bytes in phoneme string
; *********************************************************

DT_Xlt    PROC    FAR

	  mov     ah,18h        ; issue translate command to DT
	  call    DT_Tts        ;  (DT_Init must have been called
	  mov     ah,1          ;  prior to this!)
	  call    DT_Tts
	  mov     ah,'H'
	  call    DT_Tts
DX0:      mov     ah,es:[si]
	  call    DT_Tts
	  inc     si
	  loop    DX0
	  xor     ah,ah         ; force translation
	  call    DT_Tts
	  cld
	  xor     cx,cx

DX1:      call    DT_Rd         ; read phoneme string from DT
	  cmp     al,0dh
	  je      DX2
	  stosb
	  inc     cx
	  jmp     DX1
DX2:      ret

DT_Xlt    ENDP
