/*
 *   Example Program using API board level functions
 */


/* nicode.h contains constants, declarations required to make API calls to
 * the driver. */

#define INCL_DOSFILEMGR
#define INCL_DOSDEVICES
/* nictl_32.h contains the macro defintion that expands the nictl C 
 * function to a DosDevIOCtl call for 32 bit compilers.   */

#include <os2.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include "nictl_32.h"
#include "nicode.h"

#define DISABLE_ERRORPOPUPS 0

void gpiberr(HFILE bdh, char *msg);

char buffer[200];

main() {

   HFILE bdh;
   ULONG ActionTaken;
   ULONG BytesWritten    = 0;
   ULONG BufferLength;
   ULONG ParmLength=0;
   ULONG DataLength=0;
   APIRET rc; 
   unsigned short cnt; 
   void *cmdbuf;
   struct nidev nid;


   rc = DosError(DISABLE_ERRORPOPUPS);
   rc  = DosOpen("DEV1",  &bdh,  &ActionTaken,
                 0L,          /* file's new size */
                 FILE_READONLY,   /* file attribute is read only */
                 OPEN_ACTION_OPEN_IF_EXISTS,   /* open the file if it already exists */
                 OPEN_FLAGS_WRITE_THROUGH | OPEN_FLAGS_FAIL_ON_ERROR | 
           		  OPEN_FLAGS_NOINHERIT | OPEN_SHARE_DENYNONE | 
					  OPEN_ACCESS_READWRITE,
                 0);
   if (rc) {
     gpiberr(bdh, "DosOpen Error");
   }


   ParmLength = sizeof(nid);
   DataLength = 0;
   rc = DosDevIOCtl(bdh, CATEGORY, DConfRd, &nid, ParmLength, &ParmLength,
				  NULL, DataLength, &DataLength);
   printf("uflags=0x%x,pad=%d,sad=%d, eos=0x%x, timo=%d, brdno=%d\n",
             nid.uflags, nid.pad, nid.sad, nid.eos, nid.timo, nid.brdno);
   if (rc) {
     gpiberr(bdh,"BConfRd Error");
   }
   nid.uflags &= ~UNAD; 
   nid.uflags &= ~UGPIB;
   ParmLength = sizeof(nid);
   DataLength = 0;
   rc = DosDevIOCtl(bdh, CATEGORY, DConfWrt, &nid, ParmLength, &ParmLength,
				  NULL, DataLength, &DataLength);
   if (rc) {
     printf("rc=%x\n", rc);
     gpiberr(bdh,"BConfWrt Error");
   }

   rc = DosDevIOCtl(bdh, CATEGORY, DTempRd, &nid, ParmLength, &ParmLength,
				  NULL, DataLength, &DataLength);
   if (rc) {
     gpiberr(bdh,"BTempRd Error");
   }

   nid.uflags &= ~UDMA;
   nid.uflags &= ~UGPIB;
   ParmLength = sizeof(nid);
   DataLength = 0;
   rc = DosDevIOCtl(bdh, CATEGORY, DTempWrt, &nid, ParmLength, &ParmLength,
				  NULL, DataLength, &DataLength);
   if (rc) {
     gpiberr(bdh,"BTempWrt Error");
   }
   cnt = 4;
   cmdbuf = "?_@!";
   ParmLength = sizeof(cnt);
   DataLength = sizeof(cmdbuf);
   rc = DosDevIOCtl(bdh, CATEGORY, CMD, &cnt, ParmLength, &ParmLength,
               cmdbuf, DataLength, &DataLength);
   if (rc) {
     printf("CMD Error: rc=%x\n", rc);
     gpiberr(bdh, "CMD Error");
   }

  /* Write "hello" onto the GPIB. If the device at Address 1 has issued
   * a read, then these bytes would received by the device.
   * If a non zero is returned, call gpiberr with an error message.
   */

   BufferLength = 5;
   rc = DosWrite (bdh,"hello",BufferLength,&BytesWritten);
   if (rc) {
     gpiberr(bdh, "DosWrite Error");
   }
  
  /* Send out the UnListen (ASCII "?") and UnTalk Command (ASCII "_") , adrress
   * the GPIB interface board to listen (ASCII " ") and a device at GPIB primary
   * address 1 to talk (ASCII "A") . 
   * If a non zero is returned, call gpiberr with an error message.
   */

   cnt = 4;
   cmdbuf = "?_A ";
   ParmLength = sizeof(cnt);
   DataLength = sizeof(cmdbuf);
   rc = DosDevIOCtl(bdh, CATEGORY, CMD, &cnt, ParmLength, &ParmLength,
               cmdbuf, DataLength, &DataLength);
   if (rc) {
     gpiberr(bdh, "CMD Error");
   }
  /* Read data bytes from the GPIB. If the device at address 1 sends
   * data bytes, a DosRead will cause those bytes to be read into
   * Buffer Area. 
   * If a non zero is returned, call gpiberr with an error message.
   */

   BufferLength = 100;
   rc = DosRead (bdh,buffer,BufferLength,&BytesWritten);
   if (rc) {
     gpiberr(bdh, "DosRead Error");
   }

   /* Call OFFLINE to disable the hardware and software. */

   ParmLength = 0;
   DataLength = 0;

 	rc = DosDevIOCtl(bdh, CATEGORY, OFFLINE, NULL, ParmLength, &ParmLength, NULL,
              DataLength, &DataLength); 

}

/*
 * ===========================================================================
 *                      Function GPIBERR
 *  This function will notify you that a NI-488 function failed by
 *  printing an error message.  The status variable status will also be
 *  printed in hexadecimal along with the mnemonic meaning of the bit position. 
 *  The status variable error will be printed in decimal along with the
 *  mnemonic meaning of the decimal value.  
 *
 *  The API function OFFLINE is called to disable the hardware and software.
 *
 *  The EXIT function will terminate this program.
 * ===========================================================================
 */

void gpiberr(HFILE bdh, char *msg)
{
   unsigned short status;
   unsigned short error;
   APIRET rc;
   ULONG ParmLength = 0;
   ULONG DataLength = 0; 

   printf("%s\n", msg);
   ParmLength = sizeof(status);
   DataLength = 0;
   rc = DosDevIOCtl(bdh, CATEGORY, STATUS, &status, ParmLength, &ParmLength,
                     0, DataLength, &DataLength);
   printf("status = &H%x   <", status);
    if (status & BERR )  printf (" ERR");
    if (status & BTIMO)  printf (" TIMO");
    if (status & BEND )  printf (" END");
    if (status & BSRQI)  printf (" SRQI");
    if (status & BRQS )  printf (" RQS");
    if (status & BCMPL)  printf (" CMPL");
    if (status & BLOK )  printf (" LOK");
    if (status & BREM )  printf (" REM");
    if (status & BCIC )  printf (" CIC");
    if (status & BATN )  printf (" ATN");
    if (status & BTACS)  printf (" TACS");
    if (status & BLACS)  printf (" LACS");
    if (status & BDTAS)  printf (" DTAS");
    if (status & BDCAS)  printf (" DCAS");
    printf (" >\n");             

   error = rc & 0x00FF ;
    if (error == EDVR) printf (" EDVR <DOS Error>\n");
    if (error == ECIC) printf (" ECIC <Not CIC>\n");
    if (error == ENOL) printf (" ENOL <No Listener>\n");
    if (error == EADR) printf (" EADR <Address error>\n");
    if (error == EARG) printf (" EARG <Invalid argument>\n");
    if (error == ESAC) printf (" ESAC <Not Sys Ctrlr>\n");
    if (error == EABO) printf (" EABO <Op. aborted>\n");
    if (error == ENEB) printf (" ENEB <No GPIB board>\n");
    if (error == EOIP) printf (" EOIP <Async I/O in prg>\n");
    if (error == ECAP) printf (" ECAP <No capability>\n");
    if (error == EFSO) printf (" EFSO <File sys. error>\n");
    if (error == EBUS) printf (" EBUS <Command error>\n");
    if (error == ESTB) printf (" ESTB <Status byte lost>\n");
    if (error == ESRQ) printf (" ESRQ <SRQ stuck on>\n");
    if (error == ETAB) printf (" ETAB <Table Overflow>\n");

   /* Call OFFLINE to disable the hardware and software. */
	rc = nictl(bdh, OFFLINE, 0, 0, ParmLength, DataLength); 
   exit (1);
}

