/* OS/2 Example Program 2 -- Clearing and Triggering */

#include <stdio.h>
#include <stdlib.h>
#include "decl.h"

#define BUF_SIZE 1024
extern disp_wav(char *bufptr, int size);

main() {

   int osc;                   /* file descriptor for digital oscilloscope */
   int i;                     /* loop control variable*/
   char *buffer;              /* stores the measurements obtained*/

   buffer=malloc(BUF_SIZE);
   if (buffer==NULL)
      report_error(osc,"Could not allocate enough memory\n");

   if ((osc = ibfind("OSC_01")) < 0)
      report_error(osc, "Could not open OSC_01 device");

   /*Clear oscilloscope*/
   ibclr(osc);                   
   if (ibsta & ERR)
      report_error(osc, "Could not clear device");

   /*Set up to acquire waveform on trigger*/
   ibwrt(osc, "WAV=TRIG", 8);    
   if (ibsta & ERR)
      report_error(osc, "Could not write to device");

   /*Take 100 readings*/
   for (i=0; i < 100; i++){

   /*Trigger the scope -- will cause it to acquire data*/
   ibtrg(osc);         
   if (ibsta & ERR)
      report_error(osc, "Could not trigger device");

   /*Request data from scope*/
   ibwrt(osc, "CURV?", 5);     
   if (ibsta & ERR)
      report_error(osc, "Could not write to device");
  
   /*Read waveform*/
   ibrd(osc, buffer, BUF_SIZE);    
   if (ibsta & ERR)
      report_error(osc, "Could not read from device");

   /*Call external routine to display waveform*/
   disp_wav(buffer, BUF_SIZE);

   }

   /*Take the scope off-line*/
   ibonl(osc, 0);        
}

report_error(int fd, char *errmsg) {

   fprintf(stderr, "Error %d: %s\n", iberr, errmsg);

   if (fd != -1) {
      printf("Cleanup: taking board off-line\n");
      ibonl(fd,0);
   }
   exit(1);              /* abort program */
}
