'  Microsoft BASIC NI-488 Example Program - Board Level
'
' This sample program is for reference only. It can only be expected to
' function with a Fluke 8840 Digital Multimeter that has been properly
' configured in IBCONF.
'

DECLARE SUB finderr ()
DECLARE SUB gpiberr ()
DECLARE SUB dvmerror ()


REM $INCLUDE: 'decl.bas'

'  Assign a unique identifier to board 0 and store in variable brd0%.

   bdname$ = "GPIB0"
   brd0% = ibfind%(bdname$)

'  Check for error on IBFIND call.

   IF brd0% < 0 THEN CALL finderr

'  Send the Interface Clear (IFC) message to all devices.

   CALL ibsic(brd0%)

'  Check for an error on each GPIB call to be safe.

   IF ibsta% < 0 THEN CALL gpiberr

'  Turn on the Remote Enable (REN) signal.

   CALL ibsre(brd0%, (1))
   IF ibsta% < 0 THEN CALL gpiberr

'  Inhibit front panel control with the Local Lockout (LLO) command (hex 11).
'  Place the device in remote mode by addressing it to listen. The listen address
'  of device three is its primary address, 3, plus hex 20.  This is an ASCII
'  "#".  Send the Device Clear (DCL) message (hex 14) to clear internal device
'  functions.  Finally, address the GPIB0 to talk by sending its talk address,
'  the pad 0 plus hex 40, or ASCII "@".  These commands can be found in Appendix
'  A of the Software Reference Manual.

   cmd$ = CHR$(LLO) + "#" + CHR$(DCL) + "@"	'LLO MLA3 DCL MTA0
   CALL ibcmd(brd0%, cmd$)
   IF ibsta% < 0 THEN CALL gpiberr

'  Write the function, range, and trigger source instructions to the device.
'  This string is meaningful to the Fluke 8840 Digital Multimeter.

   wrt$ = "F3R7T3"
   CALL ibwrt(brd0%, wrt$)
   IF ibsta% < 0 THEN CALL gpiberr

'  Send the GGET message (hex 8) to trigger a measurement reading.

   cmd$ = CHR$(GGET)
   CALL ibcmd(brd0%, cmd$)
   IF ibsta% < 0 THEN CALL gpiberr

'  Wait for the device to set SRQ (hex 1000) or for a timeout (hex 4000).
'  These status bits are listed in Section Four of the Software Reference
'  manual.  If the current time limit is too short, use IBTMO to change it.

   mask% = TIMO OR SRQI
   CALL ibwait(brd0%, mask%)
   IF (ibsta% AND (EERR OR TIMO)) <> 0 THEN CALL gpiberr

'  If neither a timeout nor an error occurred, IBWAIT must have returned
'  on SRQ.  Next do a serial poll.  First unaddress bus devices by sending
'  the untalk (UNT) command (ASCII "_", or hex 5F) and the unlisten (UNL)
'  command (ASCII "?", or hex 3F).  Then send the Serial Poll Enable (SPE)
'  command (hex 18) and the device's talk address (device three's pad, 3, plus
'  hex 40, or ASCII "C") and the GPIB0 listen address (pad 0 plus hex 20,
'  or ASCII space).  These commands can be found in Appendix A of the Software
'  Reference Manual.

   cmd$ = "?_" + CHR$(SPE) + "C "
   CALL ibcmd(brd0%, cmd$)
   IF ibsta% < 0 THEN CALL gpiberr

'  Now read the status byte.  If it is &HC0, the device has valid data to send;
'  otherwise, it has a fault condition to report.

   rd$ = SPACE$(1)
   CALL ibrd(brd0%, rd$)
   IF ibsta% < 0 THEN CALL gpiberr

   IF ASC(rd$) <> &HC0 THEN CALL dvmerror

'  If more than one device were attached to the bus, it would be necessary to
'  explicitly check the &H40 bit of the device status word to be sure that
'  another  device had not been  responsible for asserting SRQ.  Complete the
'  serial poll by sending the Serial Poll Disable (SPD) message (hex 19).
'  These commands can be found in Appendix A of the Software Reference Manual.

   cmd$ = CHR$(SPD)
   CALL ibcmd(brd0%, cmd$)
   IF ibsta% < 0 THEN CALL gpiberr

'  Since the DVM ("digital voltmeter") and GPIB board are still addressed
'  to talk and listen, the measurement can be read as follows.

   rd$ = SPACE$(16)
   CALL ibrd(brd0%, rd$)
   IF ibsta% < 0 THEN CALL gpiberr

'  To close out a programming sequence, send IFC to initialize the bus and
'  call the IBONL function to disable the hardware and software.

   CALL ibsic(brd0%)
   CALL ibonl(brd0%, (0))
   END


'  A routine at this location would notify you that the IBFIND call failed,
'  and refer you to the handler software configuration procedures.

SUB finderr STATIC
    PRINT "IBFIND ERROR"
END SUB

'  An error checking routine at this location would, among other things,
'  check iberr to determine the exact cause of the error condition and then
'  take action appropriate to the application.  For errors during data
'  transfers, ibcnt may be examined to determine the actual number of bytes
'  transferred.

SUB gpiberr STATIC
   PRINT "GPIB ERROR"
END SUB

'  A routine at this location would analyze the fault code returned in the
'  board's status byte and take appropriate action.

SUB dvmerror STATIC
   PRINT "DVM ERROR"
END SUB


