/* C Example Program - NI Board Level Functions       */

/*
 This sample program is for reference only and can only be expected to
 function with a Fluke 8840 Digital Multimeter that has been properly
 configured in IBCONF.
*/

#include <fcntl.h>
#include <stdio.h>
#include "nicode.h"
#include <os2.h>
#include "nictl.h"

/* Error termination macros
 */
#define errck  if (RetCode) {printf("nictl error:%i", (char) RetCode); goto bye;}


main()
{
	int   brd0;			 /* board handle	    */
	int   cnt;			 /* count		    */
	int   response; 		 /* serial poll response    */
	int   RetCode;			 /* API return code	    */
	int   mask = (BTIMO | BSRQ);	 /* wait mask		    */
	char  rd[512];			 /* read data buffer	    */


/* Get the board handle, exit on error.
 */
	brd0 = open("GPIB0",O_RDWR);
	if (brd0 == -1) {
		printf("Unable to open board");
		exit(1);
	}

/* Send Interface Clear.
 */
	RetCode = nictl(brd0,SENDIFC,0,0);
	errck;

/*  Turn on the Remote Enable (REN) signal.
 */
	RetCode = nictl(brd0,SETREMOTE,0,0);
	errck;

/* Inhibit front panel control with the Local Lockout (LLO) command (hex 11).
 * Place the device in remote mode by addressing it to listen. The listen
 * address of device three is its primary address, 3, plus hex 20.  This is an
 * ASCII "#".  Send the Device Clear (DCL) message (hex 14) to clear internal
 * device functions.  Finally, address the GPIB0 to talk by sending its talk
 * address, the pad 0 plus hex 40, or ASCII "@".  These commands can be found
 * in Appendix A of the Software Reference Manual.
 */
	cnt = 4;
	RetCode = nictl(brd0,CMD,&cnt,"\021#\024@");
	errck;

/* Write the function, range, and trigger source instructions to the device.
 * This string is meaningful to the Fluke 8840 Digital Multimeter.
 */
	write(brd0,"F3R7T3",6);

/*  Send the GGET message (hex 8) to trigger a measurement reading.
 */
	cnt = 1;
	RetCode = nictl(brd0,CMD,&cnt,"\010");
	errck;

/* Wait for the DVM to set SRQ (hex 800) or for a timeout (hex 40).
 * These status constants are defined in NICODE.H. If the current time
 * limit is too short, use BTempWrt to change it.
 */

	RetCode = nictl(brd0,BWAIT,&mask,0);
	errck;

/*  If neither a timeout nor an error occurred, BWAIT must have returned
 *  on SRQ.  Next do a serial poll.  First unaddress bus devices by sending
 *  the untalk (UNT) command (ASCII "_", or hex 5F) and the unlisten (UNL)
 *  command (ASCII "?", or hex 3F).  Then send the Serial Poll Enable (SPE)
 *  command (hex 18) and the DVM's talk address (device three's pad, 3, plus
 *  hex 40, or ASCII "C") and the GPIB0 listen address (pad 0 plus hex 20,
 *  or ASCII space).  These commands can be found in Appendix A of the Software
 *  Reference Manual.
 */

	cnt = 5;
	RetCode = nictl(brd0,CMD,&cnt,"?_\030C ");
	errck;

/* Now read the status byte.  If response is 0xC0, the device has
 * valid data to send; otherwise, it has a fault condition to report.
 */

	cnt = read(brd0,&response,1);
	if (!(response & 0xC0)) printf("Fault condition.");

 /* If more than one device were attached to the bus, it would be necessary to
    explicitly check the 0x40 bit of the device status word to be sure that
    another device had not been responsible for asserting SRQ.		      */

/* Complete the serial poll by sending the Serial Poll Disable (SPD) message
 * (hex 19). This command can be found in Appendix A of the Software
 * Reference Manual.
 */

	cnt = 1;
    RetCode = nictl(brd0,CMD,&cnt,"\031");
    errck;

/*
 * If the data is valid, read the measurement.
 */
	cnt = read(brd0,rd,16);

bye:

	close(brd0);
}
