/*********
 *  CBIB.C - C portion of interface for BASIC applications using NI488.C
 *
 *  Contains functions called by BBIB.BAS.
 */

/* NI488 function codes */

#define NIBNA	 0
#define NICAC	 1
#define NICLR	 2
#define NICMD	 3
#define NICMDA	 4
#define NIDMA	 5
#define NIEOS	 6
#define NIEOT	 7
#define NIGTS	 8
#define NIIST	 9
#define NILOC	 10
#define NIONL	 11
#define NIPAD	 12
#define NIPCT	 13
#define NIPPC	 14
#define NIRD	 15
#define NIRDA	 16
#define NIRDF	 17
#define NIRPP	 18
#define NIRSC	 19
#define NIRSP	 20
#define NIRSV	 21
#define NISAD	 22
#define NISIC	 23
#define NISRE	 24
#define NITMO	 25
#define NITRG	 26
#define NIWAIT	 27
#define NIWRT	 28
#define NIWRTA	 29
#define NIWRTF	 30

extern int ibsta, iberr, ibcnt; 	/* status variables defined in NI488.C */

/* NI-488 functions */

extern pascal ibbna(int, char *);	/* called by cibstr */
extern pascal ibcac(int, int);		/* called by cib2   */
extern pascal ibclr(int);		/* called by cib1   */
extern pascal ibcmd(int, char *, int);	/* called by cibbuf */
extern pascal ibcmda(int, char *, int); /* called by cibbuf */
extern pascal ibdma(int, int);		/* called by cib2   */
extern pascal ibeos(int, int);		/* called by cib2   */
extern pascal ibeot(int, int);		/* called by cib2   */
extern int pascal ibfind(char *);	/* called by cibfind*/
extern pascal ibgts(int, int);		/* called by cib2   */
extern pascal ibist(int, int);		/* called by cib2   */
extern pascal ibloc(int);		/* called by cib1   */
extern pascal ibonl(int, int);		/* called by cib2   */
extern pascal ibpad(int, int);		/* called by cib2   */
extern pascal ibpct(int);		/* called by cib1   */
extern pascal ibppc(int, int);		/* called by cib2   */
extern pascal ibrd(int, char *, int);	/* called by cibbuf */
extern pascal ibrda(int, char *, int);	/* called by cibbuf */
extern pascal ibrdf(int, char *);	/* called by cibstr */
extern pascal ibrpp(int, int *);	/* called by cibpoll*/
extern pascal ibrsc(int, int);		/* called by cib2   */
extern pascal ibrsv(int, int);		/* called by cib2   */
extern pascal ibrsp(int, int *);	/* called by cibpoll*/
extern pascal ibsad(int, int);		/* called by cib2   */
extern pascal ibsic(int);		/* called by cib1   */
extern pascal ibsre(int, int);		/* called by cib2   */
extern pascal ibtmo(int, int);		/* called by cib2   */
extern pascal ibtrg(int);		/* called by cib1   */
extern pascal ibwait(int, int); 	/* called by cib2   */
extern pascal ibwrt(int, char *, int);	/* called by cibbuf */
extern pascal ibwrta(int, char *, int); /* called by cibbuf */
extern pascal ibwrtf(int, char *);	/* called by cibstr */


/* Entry for GPIB functions taking a device descriptor and a string pointer: */

pascal cibstr(ibfn, ud, str, bibsta, biberr, bibcnt)
int ibfn, *ud;
char *str;
int *bibsta, *biberr, *bibcnt;
{
	switch (ibfn) {
		case NIBNA:
			ibbna(*ud, str);
			break;
		case NIRDF:
			ibrdf(*ud, str);
			break;
		case NIWRTF:
			ibwrtf(*ud, str);
			break;
		}
	*bibsta = ibsta;
	*biberr = iberr;
	*bibcnt = ibcnt;
}

/* Entry for GPIB functions taking a device descriptor and a mode or mask: */

pascal cib2(ibfn, ud, v, bibsta, biberr, bibcnt)
int ibfn;
int *ud, *v;
int *bibsta, *biberr, *bibcnt;
{
	switch (ibfn) {
		case NICAC:
			ibcac(*ud, *v);
			break;
		case NIDMA:
			ibdma(*ud, *v);
			break;
		case NIEOS:
			ibeos(*ud, *v);
			break;
		case NIEOT:
			ibeot(*ud, *v);
			break;
		case NIGTS:
			ibgts(*ud, *v);
			break;
		case NIIST:
			ibist(*ud, *v);
			break;
		case NIONL:
			ibonl(*ud, *v);
			break;
		case NIPAD:
			ibpad(*ud, *v);
			break;
		case NIPPC:
			ibppc(*ud, *v);
			break;
		case NIRSC:
			ibrsc(*ud, *v);
			break;
		case NIRSV:
			ibrsv(*ud, *v);
			break;
		case NISAD:
			ibsad(*ud, *v);
			break;
		case NISRE:
			ibsre(*ud, *v);
			break;
		case NITMO:
			ibtmo(*ud, *v);
			break;
		case NIWAIT:
			ibwait(*ud, *v);
			break;
		}
	*bibsta = ibsta;
	*biberr = iberr;
	*bibcnt = ibcnt;
}

/* Entry for GPIB functions taking only a device descriptor: */

pascal cib1(ibfn, ud, bibsta, biberr, bibcnt)
int ibfn;
int *ud;
int *bibsta, *biberr, *bibcnt;
{
	switch (ibfn) {
		case NICLR:
			ibclr(*ud);
			break;
		case NILOC:
			ibloc(*ud);
			break;
		case NIPCT:
			ibpct(*ud);
			break;
		case NISIC:
			ibsic(*ud);
			break;
		case NITRG:
			ibtrg(*ud);
			break;
		}
	*bibsta = ibsta;
	*biberr = iberr;
	*bibcnt = ibcnt;
}


/* Entry for ibfind.							*/

int pascal cibfind(udname, bibsta, biberr, bibcnt)
char *udname;
int *bibsta, *biberr, *bibcnt;
{
	int bd;
	bd = ibfind (udname);
	*bibsta = ibsta;
	*biberr = iberr;
	*bibcnt = ibcnt;
	return bd;
}

/* Entry for GPIB functions taking a device descriptor, a buffer, and a count: */

pascal cibbuf(ibfn, ud, buf, cnt, bibsta, biberr, bibcnt)
int ibfn, *ud;
char *buf;
int cnt, *bibsta, *biberr, *bibcnt;
{
	switch (ibfn) {
		case NICMD:
			ibcmd(*ud, buf, cnt);
			break;
		case NICMDA:
			ibcmda(*ud, buf, cnt);
			break;
		case NIRD:
			ibrd(*ud, buf, cnt);
			break;
		case NIRDA:
			ibrda(*ud, buf, cnt);
			break;
		case NIWRT:
			ibwrt(*ud, buf, cnt);
			break;
		case NIWRTA:
			ibwrta(*ud, buf, cnt);
			break;
		}
	*bibsta = ibsta;
	*biberr = iberr;
	*bibcnt = ibcnt;
}

/* Entry for GPIB polling functions:				 */

pascal cibpoll(ibfn, ud, response, bibsta, biberr, bibcnt)
int ibfn;
int *ud, *response;
int *bibsta, *biberr, *bibcnt;
{
	switch (ibfn) {
		case NIRPP:
			ibrpp(*ud, response);
			break;
		case NIRSP:
			ibrsp(*ud, response);
			break;
		}
	*bibsta = ibsta;
	*biberr = iberr;
	*bibcnt = ibcnt;
}
