' Microsoft BASIC NI Example Program - Device Level
'
' This sample program is for reference only. It can only be expected to
' function with a Fluke 8840 Digital Multimeter that has been properly
' configured in IBCONF.
'

REM $INCLUDE: 'BSEDOSFL.BI'
REM $INCLUDE: 'NICODE.BAS'

' Begin

' Open the digital voltmeter ("DVM") as #1.

	ON ERROR GO TO ErrOpen

	OPEN "DVM" FOR BINARY AS #1


' Get the device's OS/2 file handle.

	dvm% = FILEATTR(1,2)

	ON ERROR GO TO ErrSub

' Clear the DVM.

	RetCode% = DosDevIOCtl%(0,0,0,0, DCLEAR, CATEGORY, dvm%)

' Write the function, range, and trigger source instructions to the DVM.
' This string is meaningful to the Fluke 8840 Digital Multimeter.

	wrt$ = "F3R7T3" : PUT #1, 1, wrt$

' Trigger the device.

	RetCode% = DosDevIOCtl%(0,0,0,0, TRIGGER, CATEGORY, dvm%)

'  
' Wait for an SRQ (hex 800) or for a timeout (hex 40); if the device's time
' limit is too short, use DTempWrt to change it.  The mask bits BTIMO and
' BSRQ are described in NICODE.BAS.

	mask% = BTIMO OR BSRQ
	RetCode% = DosDevIOCtl%( 0, 0,_
			VARSEG(mask%), VARPTR(mask%), BWAIT, CATEGORY, dvm%)
'
' Next, serial poll the device.
'  
	RetCode% = DosDevIOCtl%(0,0, VARSEG(spr%), VARPTR(spr%), SPOLL, CATEGORY, dvm%)
   
' Now test the status byte (spr%). If spr% is &HC0, the device has valid data
' to send; otherwise, it has a fault condition to report.
'  
	IF spr% <> &HC0 THEN PRINT "Fault condition"
'
' If the data is valid, read the measurement.
'  
	 rd$ = SPACE$(16)
	 RetCode% = DOSREAD%(dvm%, VARSEG(rd$), SADD(rd$), 16, cnt%)


' Close device 0

	CLOSE 1

END

'      A routine at this location would report the failure to open the device,
'      and would refer you to driver software configuration procedures.

ErrOpen:
	PRINT "UNABLE TO OPEN DEVICE"
	ON ERROR GO TO 0

'      An error checking routine at this location would, among other things,
'      check device status to determine the exact cause of the error condition
'      and then take action appropriate to the application.  For errors during
'      DosRead or DosWrite, cnt may be examined to determine the actual number
'      of bytes transferred.

ErrSub:
	PRINT "GPIB ERROR" : RESUME NEXT
