/* C Example Program - NI-488 Device Level Functions	  */
/*
  This sample program is for reference only and can only be expected to
  function with a Fluke 8840 Digital Multimeter that has been properly
  configured in IBCONF.
*/

#include <stdio.h>
#include "decl.h"

/* Application program variables passed to GPIB functions */

char rd[512];                /* read data buffer          */
int  dvm;                    /* device number             */
int spr;		     /* serial poll response byte */


main() {

/* Assign a unique identifier to the DVM ("Digital Voltmeter") and store in
 * variable dvm.  Check for error. (IBFIND error = negative value returned.)
*/

    if ((dvm = ibfind ("DVM")) < 0) finderr();

 /* Clear the device.  Check for error on each GPIB call to be safe.  Note
    that GPIB status is available both through global variable ibsta and
    through the return values of all GPIB functions except IBFIND.	      */

    if (ibclr (dvm) & ERR) error();

/* Write the function, range, and trigger source instructions to the DVM.
 * This string is meaningful to the Fluke 8840 Digital Multimeter.
 */

    ibwrt (dvm,"F3R7T3",6);
    if (ibsta & ERR) error();

 /* Trigger the device. 			   */

    if (ibtrg (dvm) & ERR) error();

/* Wait for the DVM to set SRQ (hex 1000) or for a timeout (hex 4000).
 * These status bits are listed in Section Four of the Software Reference
 * manual.  If the current time limit is too short, use IBTMO to change it.
 */

    if (ibwait (dvm,TIMO|SRQI) & (ERR|TIMO)) error();

 /* If neither a timeout nor an error occurred, IBWAIT must have returned on
    SRQ.  Next serial poll the device.					      */

    if (ibrsp (dvm,&spr) & ERR) error();

 /* Now read the status byte.  If it is 0xC0, the device has valid data to send;
    otherwise it has a fault condition to report.			      */

    if (spr != 0xC0)  dvmerr();

 /* If the data is valid, read the measurement.    */

    if (ibrd (dvm,rd,16) & ERR) error();

 /* To close out a programming sequence, call the IBONL function to disable
    the hardware and software. */

    ibonl (dvm,0);
}


finderr() {
/* This routine would notify you that the IBFIND call failed, and refer you to
   the handler software configuration procedures.			      */

   printf("Ibfind error; does device or board\n");
   printf("name given match configuration name?\n");
   }


error() {
/* An error checking routine at this location would, among other things, check
   iberr to determine the exact cause of the error condition and then take
   action appropriate to the application.  For errors during data transfers,
   ibcnt may be examined to determine the actual number of bytes transferred. */

   printf("GPIB function call error:\n");
   printf("ibsta=0x%x, iberr=%d, ibcnt=%d\n",ibsta,iberr,ibcnt);
   }

dvmerr() {
/* A routine at this location would analyze the fault code returned in the
   device's status byte and take appropriate action.                          */

   printf("Device error\n");
   printf("ibsta=0x%x, iberr=%d, ibcnt=%d\n",ibsta,iberr,ibcnt);
   }
